/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import java.util.HashMap;
import net.malisis.core.renderer.element.RenderParameters;
import net.malisis.core.renderer.element.Vertex;
import net.minecraft.util.IIcon;

public class Face {
    private Vertex[] vertexes;
    private RenderParameters params = new RenderParameters();

    public Face(Vertex[] vertexes, RenderParameters params) {
        this.vertexes = new Vertex[vertexes.length];
        for (int i = 0; i < vertexes.length; ++i) {
            this.vertexes[i] = new Vertex(vertexes[i]);
        }
        if (params == null) {
            params = RenderParameters.setDefault();
        }
        this.params = new RenderParameters(params);
    }

    public Face(Vertex[] vertexes) {
        this(vertexes, null);
    }

    public Face(Face face) {
        this(face, face.params);
    }

    public Face(Face face, RenderParameters params) {
        this(face.vertexes, params);
    }

    public Vertex[] getVertexes() {
        return this.vertexes;
    }

    public Face setParameters(RenderParameters params) {
        this.params = params;
        return this;
    }

    public RenderParameters getParameters() {
        return this.params;
    }

    public Face setColor(int color) {
        for (Vertex v : this.vertexes) {
            v.setColor(color);
        }
        return this;
    }

    public Face setAlpha(int alpha) {
        for (Vertex v : this.vertexes) {
            v.setAlpha(alpha);
        }
        return this;
    }

    public Face setBrightness(int brightness) {
        for (Vertex v : this.vertexes) {
            v.setBrightness(brightness);
        }
        return this;
    }

    public Face setTexture(IIcon icon) {
        return this.setTexture(icon, this.params.uvFactor, this.params.flipU, this.params.flipV);
    }

    public Face setTexture(IIcon icon, float[][] uvFactor) {
        return this.setTexture(icon, uvFactor, this.params.flipU, this.params.flipV);
    }

    public Face setTexture(IIcon icon, float[][] uvFactor, boolean flippedU, boolean flippedV) {
        if (uvFactor == null) {
            return this;
        }
        float u = icon.func_94209_e();
        float v = icon.func_94206_g();
        float U = icon.func_94212_f();
        float V = icon.func_94210_h();
        for (int i = 0; i < this.vertexes.length; ++i) {
            this.vertexes[i].setUV(this.interpolate(u, U, uvFactor[i][0], flippedU), this.interpolate(v, V, uvFactor[i][1], flippedV));
        }
        return this;
    }

    private float interpolate(float min, float max, float factor, boolean flipped) {
        if (flipped) {
            factor = 1.0f - factor;
            float t = max;
            max = min;
            min = t;
        }
        return min + (max - min) * factor;
    }

    public void translate(double x, double y, double z) {
        for (Vertex v : this.vertexes) {
            v.add(x, y, z);
        }
    }

    public void scale(float f) {
        this.scale(f, 0.5, 0.5, 0.5);
    }

    public void scale(float f, double x, double y, double z) {
        for (Vertex v : this.vertexes) {
            v.scale(f, x, y, z);
        }
    }

    public void rotateAroundX(double angle) {
        this.rotateAroundX(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundX(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundX(angle, centerX, centerY, centerZ);
        }
    }

    public void rotateAroundY(double angle) {
        this.rotateAroundY(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundY(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundY(angle, centerX, centerY, centerZ);
        }
    }

    public void rotateAroundZ(double angle) {
        this.rotateAroundZ(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundZ(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundZ(angle, centerX, centerY, centerZ);
        }
    }

    public String name() {
        String[] dirs;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String dir : dirs = new String[]{"North", "South", "East", "West", "Top", "Bottom"}) {
            map.put(dir, 0);
            for (Vertex v : this.vertexes) {
                if (!v.name().contains(dir)) continue;
                map.put(dir, (Integer)map.get(dir) + 1);
            }
            if ((Integer)map.get(dir) != 4) continue;
            return dir;
        }
        return "";
    }

    public String toString() {
        String s = this.name() + "[";
        for (Vertex v : this.vertexes) {
            s = s + v.name() + ", ";
        }
        return s + "]";
    }
}

