/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.Rotation;
import net.malisis.core.renderer.animation.Scale;
import net.malisis.core.renderer.animation.Translation;
import net.malisis.core.renderer.element.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.minecraft.client.Minecraft;

public class AnimationRenderer {
    private BaseRenderer renderer;
    private long startTime;
    private long worldTotalTime;
    private int globalDelay;
    private float partialTick;
    private float elapsedTime;
    private Animation firstAnimation;
    private Animation lastAnimation;
    private HashMap<String, AnimElement> listAnimations = new HashMap();
    private ArrayList<String> excludeRenderList = new ArrayList();

    public AnimationRenderer(BaseRenderer renderer) {
        this.renderer = renderer;
    }

    public void setTime(long start) {
        this.startTime = start;
        this.worldTotalTime = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        this.partialTick = this.renderer.partialTick;
        this.elapsedTime = (float)(this.worldTotalTime - this.startTime) + this.partialTick;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public float getElapsedTime() {
        return this.elapsedTime;
    }

    public void add(Animation animation) {
        if (this.firstAnimation == null) {
            this.firstAnimation = animation;
            this.lastAnimation = animation;
        } else {
            this.lastAnimation.next = animation;
            animation.prev = this.lastAnimation;
            this.lastAnimation = animation;
        }
    }

    public void clearAnimation(String name) {
        this.listAnimations.remove(name);
    }

    public void clearAnimations() {
        this.listAnimations.clear();
        this.globalDelay = 0;
    }

    public AnimationRenderer nextAnimation(int delay) {
        this.startTime += (long)delay;
        this.elapsedTime = (float)(this.worldTotalTime - this.startTime) + this.partialTick;
        return this;
    }

    public boolean animationReady() {
        return this.elapsedTime >= 0.0f;
    }

    public AnimationRenderer translate(float x, float y, float z) {
        this.add(new Translation(x, y, z));
        return this;
    }

    public AnimationRenderer rotate(float angle, float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        this.add(new Rotation(angle, x, y, z, offsetX, offsetY, offsetZ));
        return this;
    }

    public AnimationRenderer rotate(float angle, float x, float y, float z) {
        return this.rotate(angle, x, y, z, 0.0f, 0.0f, 0.0f);
    }

    public AnimationRenderer scaleFrom(float f) {
        return this.scaleFrom(f, f, f);
    }

    public AnimationRenderer scaleFrom(float x, float y, float z) {
        this.add(new Scale(x, y, z));
        return this;
    }

    public AnimationRenderer scaleTo(float f) {
        return this.scaleTo(f, f, f);
    }

    public AnimationRenderer scaleTo(float x, float y, float z) {
        if (this.lastAnimation instanceof Scale) {
            ((Scale)this.lastAnimation).scaleTo(x, y, z);
        }
        return this;
    }

    public AnimationRenderer globalDelay(int delay) {
        this.globalDelay = delay;
        return this;
    }

    public AnimationRenderer clearDelay() {
        this.globalDelay = 0;
        return this;
    }

    public AnimationRenderer forTicks(int duration) {
        return this.forTicks(duration, 0);
    }

    public AnimationRenderer forTicks(int duration, int delay) {
        if (this.lastAnimation != null) {
            this.lastAnimation.forTicks(duration, delay);
        }
        return this;
    }

    public AnimationRenderer loop(int loops) {
        return this.loop(loops, 0, 0);
    }

    public AnimationRenderer loop(int loops, int startDelay, int resetDelay) {
        if (this.lastAnimation != null) {
            this.lastAnimation.loop(loops, startDelay, resetDelay);
        }
        return this;
    }

    public AnimationRenderer linear() {
        if (this.lastAnimation != null) {
            this.lastAnimation.movement(0);
        }
        return this;
    }

    public AnimationRenderer sinusoidal() {
        if (this.lastAnimation != null) {
            this.lastAnimation.movement(1);
        }
        return this;
    }

    public AnimationRenderer animate(String name, Shape s) {
        return this.animate(name, new Shape[]{s}, null);
    }

    public AnimationRenderer animate(String name, Shape s, RenderParameters rp) {
        return this.animate(name, new Shape[]{s}, rp);
    }

    public AnimationRenderer animate(String name, Shape[] shapes) {
        return this.animate(name, shapes, null);
    }

    public AnimationRenderer animate(String name, Shape[] shapes, RenderParameters rp) {
        this.listAnimations.put(name, new AnimElement(this.firstAnimation, shapes, rp, this.globalDelay));
        this.lastAnimation = null;
        this.firstAnimation = null;
        return this;
    }

    public void renderAllBut(String ... names) {
        this.excludeRenderList = new ArrayList<String>(Arrays.asList(names));
        this.render(new String[0]);
        this.excludeRenderList.clear();
    }

    public void render(String ... names) {
        if (names.length == 0) {
            names = this.listAnimations.keySet().toArray(new String[0]);
        }
        for (String name : names) {
            AnimElement el;
            if (this.excludeRenderList.contains(name) || (el = this.listAnimations.get(name)) == null) continue;
            for (Shape s : el.getTransformedShapes(this.elapsedTime)) {
                this.renderer.drawShape(s, el.renderParameters);
            }
        }
    }

    private class AnimElement {
        public Animation animation;
        public Shape[] shapes;
        public RenderParameters renderParameters;
        public int delay;

        public AnimElement(Animation anim, Shape[] s, RenderParameters param, int d) {
            this.animation = anim;
            this.shapes = s;
            this.renderParameters = param;
            this.delay = d;
        }

        public Shape[] getTransformedShapes(float elapsed) {
            if (this.animation == null || elapsed < (float)this.delay) {
                return new Shape[0];
            }
            Shape[] transformedShapes = new Shape[this.shapes.length];
            int i = 0;
            for (Shape s : this.shapes) {
                if (s == null) continue;
                Shape ts = new Shape(s);
                if (this.animation != null) {
                    this.animation.transformAll(ts, elapsed - (float)this.delay);
                }
                transformedShapes[i++] = ts;
            }
            return transformedShapes;
        }
    }
}

