/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.demo.stargate;

import java.util.ArrayList;
import net.malisis.core.demo.stargate.StargateBlock;
import net.malisis.core.demo.stargate.StargateTileEntity;
import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.animation.Rotation;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.FacePreset;
import net.malisis.core.renderer.preset.ShapePreset;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class StargateRenderer
extends BaseRenderer {
    public static int renderId;
    public static ResourceLocation rlPlatform;
    int slices = 5;
    float sliceHeight = 1.0f / (float)this.slices;
    int deployTimer = StargateBlock.deployTimer;
    int openTimer = (int)((float)this.deployTimer * 0.3f);
    int rotationTimer = (int)((float)this.deployTimer * 0.3f);
    int archTimer = (int)((float)this.deployTimer * 0.5f);
    int fadeTimer = (int)((float)this.deployTimer * 0.2f);
    AnimationRenderer ar = new AnimationRenderer(this);

    public StargateRenderer() {
        this.createOpeningAnimation();
        this.createUnrollingAnimation();
        this.createArchAnimation();
        this.createFloatingAnimation();
    }

    private void createOpeningAnimation() {
        int ot = this.openTimer / this.slices;
        for (int i = 1; i < this.slices; ++i) {
            int t = ot * i;
            Shape sW = ShapePreset.Cube().setBounds(0.0f, 0.0f, 0.0f, 0.5f, this.sliceHeight, 1.0f);
            sW.translate(0.0f, this.sliceHeight * (float)i, 0.0f);
            this.ar.translate(-0.5f * (float)i, 0.0f, 0.0f).forTicks(t).translate(0.0f, -this.sliceHeight * (float)i, 0.0f).forTicks(t, ot).animate("openW" + i, sW);
            Shape sE = new Shape(sW).translate(0.5f, 0.0f, 0.0f);
            this.ar.translate(0.5f * (float)i, 0.0f, 0.0f).forTicks(t).translate(0.0f, -this.sliceHeight * (float)i, 0.0f).forTicks(t, ot).animate("openE" + i, sE);
        }
    }

    private void createUnrollingAnimation() {
        this.ar.globalDelay(this.openTimer);
        RenderParameters rp = new RenderParameters();
        rp.useBlockBrightness = false;
        int rt = this.rotationTimer * 2 / 5;
        int delay = rt / 2;
        float y = -0.5f + this.sliceHeight / 2.0f;
        ArrayList<Animation> north = new ArrayList<Animation>();
        ArrayList<Animation> south = new ArrayList<Animation>();
        for (int row = 0; row < 4; ++row) {
            Shape[] shapesNorth = new Shape[this.slices];
            Shape[] shapesSouth = new Shape[this.slices];
            for (int i = 0; i < this.slices; ++i) {
                Shape sN = ShapePreset.Cube().setBounds(0.0f, 0.0f, 0.0f, 1.0f, this.sliceHeight, 0.5f);
                sN.translate(-2 + i, 0.0f, 0.0f);
                shapesNorth[i] = sN;
                Shape sS = new Shape(sN);
                sS.translate(0.0f, 0.0f, 0.5f);
                shapesSouth[i] = sS;
            }
            north.add(new Rotation(-180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, -0.5f).forTicks(rt, 0));
            south.add(new Rotation(180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, 0.0f).forTicks(rt, 0));
            if (row > 0) {
                north.add(new Rotation(-180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, 0.0f).forTicks(rt, delay));
                south.add(new Rotation(180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, -0.5f).forTicks(rt, delay));
            }
            if (row > 1) {
                north.add(new Rotation(-180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, -0.5f).forTicks(rt, delay * 2));
                south.add(new Rotation(180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, 0.0f).forTicks(rt, delay * 2));
            }
            if (row > 2) {
                north.add(new Rotation(-180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, 0.0f).forTicks(rt, delay * 3));
                south.add(new Rotation(180.0f, 1.0f, 0.0f, 0.0f, 0.0f, y, -0.5f).forTicks(rt, delay * 3));
            }
            for (Animation anim : north) {
                this.ar.add(anim);
            }
            this.ar.animate("unrollingN" + row, shapesNorth, rp);
            for (Animation anim : south) {
                this.ar.add(anim);
            }
            this.ar.animate("unrollingS" + row, shapesSouth, rp);
            north.clear();
            south.clear();
        }
    }

    private void createArchAnimation() {
        this.ar.globalDelay(this.openTimer);
        RenderParameters rpFace = new RenderParameters();
        rpFace.calculateAOColor = false;
        rpFace.calculateBrightness = false;
        rpFace.useBlockBrightness = false;
        rpFace.brightness = 32;
        rpFace.icon = Blocks.field_150484_ah.func_149691_a(0, 0);
        Shape base = ShapePreset.Cube();
        base.setParameters(FacePreset.Bottom(), rpFace, true);
        base.translate(0.0f, 3.0f, 0.0f);
        base.shrink(FacePreset.Bottom(), 0.69f);
        base.shrink(FacePreset.Top(), 0.87f);
        int totalArch = 13;
        float angle = 10.0f;
        int at = this.archTimer / totalArch;
        RenderParameters rp = new RenderParameters();
        rp.renderAllFaces = true;
        for (int i = 0; i < totalArch; ++i) {
            float archAngle = 130.0f - (angle * (float)i + angle / 2.0f);
            int delay = (totalArch - i) * at;
            Shape sW = new Shape(base);
            sW.rotate(130.0f, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f);
            Shape sE = new Shape(base);
            sE.rotate(-130.0f, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f);
            this.ar.rotate(-archAngle, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f).forTicks(at, delay).scaleFrom(0.5f, 0.3f, 0.2f).scaleTo(0.5f, 0.5f, 0.3f).forTicks(at / 2, delay + at).animate("archW" + i, sW, rp);
            this.ar.rotate(archAngle, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f).forTicks(at, delay).scaleFrom(0.5f, 0.3f, 0.2f).scaleTo(0.5f, 0.5f, 0.3f).forTicks(at, delay + at).animate("archE" + i, sE, rp);
        }
    }

    private void createFloatingAnimation() {
        this.ar.globalDelay(this.openTimer + this.rotationTimer + this.archTimer);
        RenderParameters rp = new RenderParameters();
        rp.icon = Blocks.field_150340_R.func_149691_a(0, 0);
        rp.useBlockBrightness = false;
        rp.brightness = 0xF000F0;
        rp.alpha = 175;
        Shape s = ShapePreset.Cube();
        s.scale(0.2f);
        s.applyMatrix();
        s.translate(-1.0f, 1.5f, 0.0f);
        this.ar.rotate(360.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f).forTicks(50).loop(-1).translate(0.0f, 1.0f, 0.0f).forTicks(20).loop(-1, 0, 20).sinusoidal().translate(0.0f, -1.0f, 0.0f).forTicks(20).loop(-1, 20, 0).sinusoidal().rotate(360.0f, 1.0f, 0.0f, 0.0f).forTicks(50).loop(-1).animate("floating", s, rp);
    }

    @Override
    public void render() {
        if (this.typeRender == 4) {
            this.renderStargateTileEntity();
        } else if (this.typeRender == 1) {
            this.renderStargateBlock();
        } else if (this.typeRender == 2) {
            RenderParameters rp = RenderParameters.setDefault();
            rp.colorMultiplier = 0x6666AA;
            this.drawShape(ShapePreset.Cube());
        }
    }

    private void renderStargateTileEntity() {
        StargateTileEntity te = (StargateTileEntity)this.tileEntity;
        int alpha = 255;
        boolean drawTopFace = false;
        this.ar.setTime(te.placedTimer);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        if (this.blockMetadata == 0) {
            this.drawShape(ShapePreset.Cube().setBounds(0.0f, 0.0f, 0.0f, 1.0f, this.sliceHeight, 1.0f));
            this.ar.renderAllBut("floating");
            float comp = Math.min((this.ar.getElapsedTime() - (float)this.deployTimer + (float)this.fadeTimer) / (float)this.fadeTimer, 1.0f);
            if (comp > 0.0f) {
                alpha = (int)(255.0f * comp);
                drawTopFace = true;
            }
        }
        if (this.blockMetadata == 1 || drawTopFace) {
            if (this.blockMetadata == 1) {
                this.ar.render("floating");
            }
            this.next();
            Shape topFace = new Shape(new Face[]{FacePreset.Top()});
            topFace.translate(0.0f, -0.499f + this.sliceHeight / 2.0f, 0.0f);
            topFace.scale(5.0f, this.sliceHeight, 5.0f);
            this.func_147499_a(rlPlatform);
            RenderParameters rp = RenderParameters.setDefault();
            rp.useCustomTexture = true;
            rp.alpha = alpha;
            this.drawShape(topFace, rp);
        }
    }

    private void renderStargateBlock() {
        if (this.blockMetadata != 1) {
            return;
        }
        RenderParameters rpFace = new RenderParameters();
        rpFace.calculateAOColor = false;
        rpFace.calculateBrightness = false;
        rpFace.brightness = 0xF000F0;
        rpFace.useBlockBrightness = false;
        rpFace.icon = Blocks.field_150353_l.func_149691_a(0, 0);
        rpFace.colorFactor = Float.valueOf(1.0f);
        Shape platform = ShapePreset.Cube();
        platform.setParameters(FacePreset.Top(), rpFace, true);
        platform.translate(0.0f, -0.5f + this.sliceHeight / 2.0f, 0.0f);
        platform.scale(5.0f, this.sliceHeight, 5.0f);
        this.drawShape(platform);
        Shape base = ShapePreset.Cube();
        rpFace.icon = Blocks.field_150484_ah.func_149691_a(0, 0);
        base.setParameters(FacePreset.Bottom(), rpFace, true);
        base.translate(0.0f, 3.0f, 0.0f);
        base.shrink(FacePreset.Bottom(), 0.69f);
        base.shrink(FacePreset.Top(), 0.87f);
        int totalArch = 13;
        float angle = 10.0f;
        RenderParameters rp = new RenderParameters();
        rp.renderAllFaces = true;
        for (int i = 0; i < totalArch; ++i) {
            float archAngle = angle * (float)i + angle / 2.0f;
            Shape s1 = new Shape(base);
            s1.rotate(-archAngle, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f);
            s1.scale(0.5f, 0.5f, 0.3f);
            Shape s2 = new Shape(base);
            s2.rotate(archAngle, 0.0f, 0.0f, 1.0f, 0.0f, -2.2f, 0.0f);
            s2.scale(0.5f, 0.5f, 0.3f);
            this.drawShape(s1, rp);
            this.drawShape(s2, rp);
        }
    }

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    static {
        rlPlatform = new ResourceLocation("malisiscore", "textures/blocks/sgplatform.png");
    }
}

