/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.layout;

import java.util.IdentityHashMap;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.layout.Constraints;
import net.malisis.core.client.gui.util.shape.Point;

public abstract class LayoutManager<C extends Constraints> {
    private final IdentityHashMap<UIComponent, C> constraints = new IdentityHashMap();

    public C getConstraints(UIComponent comp) {
        Constraints constraints = (Constraints)this.constraints.get(comp);
        if (constraints == null) {
            this.setConstraints(comp, (Constraints)this.createDefaultConstraints());
            constraints = (Constraints)this.constraints.get(comp);
        }
        return (C)constraints;
    }

    public abstract C createDefaultConstraints();

    public void setConstraints(UIComponent component, Constraints constraints) {
        this.constraints.put(component, (Constraints)constraints.clone());
    }

    public void removeConstraints(UIComponent component) {
        this.constraints.remove(component);
    }

    public abstract Point getPositionForComponent(UIComponent var1);
}

