/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import java.util.LinkedList;
import java.util.List;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.layout.Constraints;
import net.malisis.core.client.gui.layout.LayoutManager;
import net.malisis.core.client.gui.proxy.GuiScreenProxy;
import net.malisis.core.client.gui.renderer.Drawable;
import net.malisis.core.client.gui.util.Size;
import net.malisis.core.client.gui.util.shape.Point;
import org.lwjgl.opengl.GL11;

public class UIContainer
extends UIComponent {
    private final List<UIComponent> components;
    private LayoutManager<? extends Constraints> layoutManager;
    private Drawable background;

    public UIContainer() {
        this(0, 0);
    }

    public UIContainer(int width, int height) {
        this.setSize(width, height);
        this.components = new LinkedList<UIComponent>();
    }

    public LayoutManager<? extends Constraints> getLayout() {
        return this.layoutManager;
    }

    public void setLayout(LayoutManager<? extends Constraints> layoutManager) {
        this.layoutManager = layoutManager;
    }

    public void add(UIComponent component) {
        this.components.add(component);
        if (this.layoutManager != null) {
            this.layoutManager.setConstraints(component, this.layoutManager.createDefaultConstraints());
        }
    }

    public void add(UIComponent component, Constraints constraints) {
        this.components.add(component);
        if (this.layoutManager != null) {
            this.layoutManager.setConstraints(component, constraints);
        }
    }

    @Override
    public void initComponent() {
        super.initComponent();
        for (UIComponent component : this.components) {
            component.initComponent();
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        if (this.background != null) {
            this.background.draw(this.getScreenX(), this.getScreenY());
        }
        for (UIComponent component : this.components) {
            if (!component.isVisible()) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.layoutManager != null) {
                component.setScreenPosition(Point.add(this.screenPosition, this.layoutManager.getPositionForComponent(component)));
            } else {
                component.setScreenPosition(Point.add(this.screenPosition, component.getPosition()));
            }
            component.drawBackground(mouseX, mouseY);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        for (UIComponent component : this.components) {
            if (!component.isVisible()) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            component.draw(mouseX, mouseY);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        for (UIComponent component : this.components) {
            if (!component.isVisible()) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            component.drawForeground(mouseX, mouseY);
        }
    }

    @Override
    public void update(int mouseX, int mouseY) {
        for (UIComponent component : this.components) {
            component.update(mouseX, mouseY);
        }
    }

    @Override
    public void setSize(Size size) {
        super.setSize(size);
        if (this.background != null) {
            this.background.setSize(size);
        }
    }

    public void setBackground(Drawable background) {
        this.background = background;
        background.setSize(this.getSize());
    }

    public Drawable getBackground() {
        return this.background;
    }

    public GuiScreenProxy createScreenProxy() {
        return new GuiScreenProxy(this);
    }
}

