/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component;

import cpw.mods.fml.client.FMLClientHandler;
import net.malisis.core.client.gui.event.GuiEvent;
import net.malisis.core.client.gui.proxy.Context;
import net.malisis.core.client.gui.proxy.GuiManager;
import net.malisis.core.client.gui.util.Size;
import net.malisis.core.client.gui.util.shape.Point;
import net.malisis.core.client.gui.util.shape.Rectangle;
import net.minecraft.client.Minecraft;

public abstract class UIComponent {
    protected Minecraft mc = FMLClientHandler.instance().getClient();
    protected Point position;
    protected Size size;
    protected boolean visible = true;
    protected boolean enabled;
    protected int zIndex = 0;
    protected Point screenPosition;
    private Context context;
    private UIComponent parent;
    private String name;
    private String tooltip;
    private Rectangle bounds;
    private Rectangle screenBounds;

    protected UIComponent() {
    }

    public void initComponent() {
    }

    public void drawBackground(int mouseX, int mouseY) {
    }

    public abstract void draw(int var1, int var2);

    public void drawForeground(int mouseX, int mouseY) {
    }

    public abstract void update(int var1, int var2);

    public UIComponent getParent() {
        return this.parent;
    }

    public void setParent(UIComponent parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public int getX() {
        return this.position.getX();
    }

    public int getY() {
        return this.position.getY();
    }

    public void setPosition(int x, int y) {
        this.setPosition(new Point(x, y));
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public void setSize(int width, int height) {
        this.setSize(new Size(width, height));
    }

    public Rectangle getBounds() {
        if (this.bounds == null || this.bounds.getWidth() != this.getWidth() || this.bounds.getHeight() != this.getHeight() || !this.bounds.getStart().equals(this.getPosition())) {
            this.bounds = new Rectangle(this.position, this.getWidth(), this.getHeight());
        }
        return this.bounds;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public int getWidth() {
        return this.size.getWidth();
    }

    public int getHeight() {
        return this.size.getHeight();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isHovered(Point mousePosition) {
        return this.getScreenBounds().contains(mousePosition);
    }

    public Rectangle getScreenBounds() {
        if (this.screenBounds == null || this.screenBounds.getWidth() != this.getWidth() || this.screenBounds.getHeight() != this.getHeight() || !this.screenBounds.getStart().equals(this.getScreenPosition())) {
            this.screenBounds = new Rectangle(this.getScreenPosition(), this.getWidth(), this.getHeight());
        }
        return this.screenBounds;
    }

    public Point getScreenPosition() {
        return this.screenPosition;
    }

    public void setScreenPosition(Point screenPosition) {
        this.screenPosition = screenPosition;
    }

    public int getScreenX() {
        return this.screenPosition.x;
    }

    public int getScreenY() {
        return this.screenPosition.y;
    }

    public boolean publish(GuiEvent event) {
        return this.getContext().publish(event);
    }

    public Context getContext() {
        if (this.context == null) {
            this.context = GuiManager.getActiveContext();
        }
        return this.context;
    }

    public void setContext(Context context) {
        if (this.context != null) {
            this.context.unregister(this);
        }
        this.context = context;
    }

    public void registerToContext(Object listener) {
        this.getContext().register(listener);
    }

    public void dispose() {
        this.context.unregister(this);
        this.context = null;
    }
}

