/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.asm;

import java.util.ArrayList;
import java.util.HashMap;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmHook;
import net.malisis.core.asm.AsmUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class MalisisClassTransformer
implements IClassTransformer {
    public HashMap<String, ArrayList<AsmHook>> listHooks = new HashMap();
    protected String logString = "malisiscore";
    protected Logger log;

    public MalisisClassTransformer() {
        this.registerHooks();
    }

    public void register(AsmHook ah) {
        ArrayList<AsmHook> hooks = this.listHooks.get(ah.getTargetClass());
        if (hooks == null) {
            hooks = new ArrayList();
        }
        hooks.add(ah);
        this.listHooks.put(ah.getTargetClass(), hooks);
        LogManager.getLogger((String)this.logString).info("Hook registered for {}", new Object[]{ah.getTargetClass()});
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ArrayList<AsmHook> hooks = this.listHooks.get(transformedName);
        if (hooks == null || hooks.size() == 0) {
            return bytes;
        }
        LogManager.getLogger((String)this.logString).info("Found hooks for {} ({})", new Object[]{transformedName, name});
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (AsmHook hook : hooks) {
            MethodNode methodNode = AsmUtils.findMethod(classNode, hook.getMethodName(), hook.getMethodDescriptor());
            if (methodNode != null) {
                if (!hook.walkSteps(methodNode)) {
                    LogManager.getLogger((String)this.logString).error("The instruction list was not found in {}:{}{}", new Object[]{hook.getTargetClass(), hook.getMethodName(), hook.getMethodDescriptor()});
                }
                if (!hook.isDebug() || MalisisCore.isObfEnv) continue;
                System.err.println(AsmUtils.getMethodNodeAsString(methodNode));
                continue;
            }
            LogManager.getLogger((String)this.logString).error("Method not found : {}:{}{}", new Object[]{hook.getTargetClass(), hook.getMethodName(), hook.getMethodDescriptor()});
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public abstract void registerHooks();
}

