/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation;

import net.malisis.core.renderer.element.Shape;

public abstract class Animation {
    public static final int LINEAR = 0;
    public static final int SINUSOIDAL = 1;
    public int movement = 0;
    protected float x;
    protected float y;
    protected float z;
    protected int duration;
    protected int delay = 0;
    protected int loops = 1;
    protected int loopStartDelay = 0;
    protected int loopResetDelay = 0;
    protected Animation prev;
    protected Animation next;

    protected Animation(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Animation movement(int movement) {
        this.movement = movement;
        return this;
    }

    public Animation delay(int delay) {
        this.delay = delay;
        return this;
    }

    public Animation forTicks(int duration, int delay) {
        if (this.duration == 0) {
            this.duration = duration;
            this.delay = delay;
        }
        return this;
    }

    public Animation loop(int loops, int startDelay, int resetDelay) {
        if (loops == 0) {
            return this;
        }
        this.loops = loops;
        this.loopStartDelay = startDelay;
        this.loopResetDelay = resetDelay;
        return this;
    }

    public void transformAll(Shape s, float elapsedTime) {
        this.animate(s, this.completion(elapsedTime));
        if (this.next != null) {
            this.next.transformAll(s, elapsedTime);
        }
    }

    protected float completion(float elapsedTime) {
        if (this.duration == 0) {
            return 0.0f;
        }
        float comp = 0.0f;
        int loopDuration = this.duration + this.loopStartDelay + this.loopResetDelay;
        float elapsed = elapsedTime - (float)this.delay;
        if (this.loops != -1 && elapsed > (float)(this.loops * loopDuration)) {
            return 1.0f;
        }
        if (this.loops != 1) {
            if ((elapsed %= (float)loopDuration) < (float)this.loopStartDelay) {
                return 0.0f;
            }
            if (elapsed - (float)this.loopResetDelay > (float)loopDuration) {
                return 1.0f;
            }
            elapsed -= (float)this.loopStartDelay;
        }
        comp = Math.min(elapsed / (float)this.duration, 1.0f);
        if (this.movement == 1) {
            comp = (float)(1.0 - Math.cos((double)comp * Math.PI)) / 2.0f;
        }
        return comp;
    }

    protected abstract void animate(Shape var1, float var2);
}

