/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BaseRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final int TYPE_WORLD = 1;
    public static final int TYPE_ISBRH_INVENTORY = 2;
    public static final int TYPE_ITEM_INVENTORY = 3;
    public static final int TYPE_TESR_WORLD = 4;
    public static final int MODE_POLYGONS = 0;
    public static final int MODE_LINES = 1;
    protected Tessellator t = Tessellator.field_78398_a;
    protected IBlockAccess world;
    protected Block block;
    protected int blockMetadata;
    protected int x;
    protected int y;
    protected int z;
    protected int typeRender;
    protected int modeRender;
    protected boolean isShifted = false;
    protected Shape shape;
    protected Face face;
    protected RenderParameters shapeParams;
    protected RenderParameters params;
    protected int baseBrightness;
    protected IIcon overrideTexture;
    protected TileEntity tileEntity;
    public float partialTick = 0.0f;

    public BaseRenderer reset() {
        this.typeRender = 0;
        this.modeRender = 0;
        this.world = null;
        this.block = null;
        this.blockMetadata = 0;
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.overrideTexture = null;
        return this;
    }

    public BaseRenderer set(IBlockAccess world, Block block, int x, int y, int z, int metadata) {
        this.world = world;
        this.block = block;
        this.blockMetadata = metadata;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public BaseRenderer set(Block block) {
        return this.set(this.world, block, this.x, this.y, this.z, this.blockMetadata);
    }

    public BaseRenderer set(int blockMetadata) {
        return this.set(this.world, this.block, this.x, this.y, this.z, blockMetadata);
    }

    public BaseRenderer set(Block block, int blockMetadata) {
        return this.set(this.world, block, this.x, this.y, this.z, blockMetadata);
    }

    public BaseRenderer set(int x, int y, int z) {
        return this.set(this.world, this.block, x, y, z, this.blockMetadata);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.renderInventoryBlock(block, metadata, modelId, renderer, null);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer, RenderParameters rp) {
        this.set(block, metadata);
        this.prepare(2, new double[0]);
        this.render();
        this.clean();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.set(world, block, x, y, z, world.func_72805_g(x, y, z));
        this.prepare(1, new double[0]);
        if (renderer.func_147744_b()) {
            this.overrideTexture = renderer.field_147840_d;
        }
        this.render();
        this.clean();
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderItem(type, item, null, data);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, RenderParameters rp, Object ... data) {
        if (item.func_77973_b() instanceof ItemBlock) {
            this.set(Block.func_149634_a((Item)item.func_77973_b()));
        }
        this.prepare(3, new double[0]);
        this.render();
        this.clean();
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        this.renderTileEntityAt(te, x, y, z, f, null);
    }

    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float f, RenderParameters rp) {
        this.set((IBlockAccess)te.func_145831_w(), te.func_145838_q(), te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145832_p());
        this.prepare(4, x, y, z);
        this.partialTick = f;
        this.tileEntity = te;
        this.render();
        this.clean();
    }

    public void prepare(int typeRender, int modeRender) {
        this.modeRender = modeRender;
        this.prepare(typeRender, new double[0]);
    }

    public void prepare(int typeRender, double ... data) {
        this.typeRender = typeRender;
        if (typeRender == 1) {
            this.tessellatorShift();
        } else if (typeRender == 2) {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            this.t.func_78382_b();
        } else if (typeRender == 3) {
            this.t.func_78382_b();
        } else if (typeRender == 4) {
            RenderHelper.func_74518_a();
            GL11.glPushMatrix();
            GL11.glTranslated((double)data[0], (double)data[1], (double)data[2]);
            GL11.glEnable((int)2903);
            GL11.glShadeModel((int)7425);
            this.func_147499_a(TextureMap.field_110575_b);
            this.t = Tessellator.field_78398_a;
            this.t.func_78382_b();
        }
    }

    public void next() {
        this.t.func_78381_a();
        this.t.func_78382_b();
    }

    public void clean() {
        if (this.typeRender == 1) {
            this.tessellatorUnshift();
        } else if (this.typeRender == 2) {
            this.t.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (this.typeRender == 3) {
            this.t.func_78381_a();
        } else if (this.typeRender == 4) {
            this.t.func_78381_a();
            GL11.glPopMatrix();
        }
        this.reset();
    }

    public void tessellatorShift() {
        if (this.isShifted) {
            return;
        }
        this.isShifted = true;
        this.t.func_78372_c((float)this.x, (float)this.y, (float)this.z);
    }

    public void tessellatorUnshift() {
        if (!this.isShifted) {
            return;
        }
        this.isShifted = false;
        this.t.func_78372_c((float)(-this.x), (float)(-this.y), (float)(-this.z));
    }

    public void renderStandard(RenderBlocks renderer) {
        if (renderer == null) {
            return;
        }
        boolean b = this.isShifted;
        if (b) {
            this.tessellatorUnshift();
        }
        renderer.func_147775_a(this.block);
        renderer.func_147784_q(this.block, this.x, this.y, this.z);
        if (b) {
            this.tessellatorShift();
        }
    }

    public void render() {
    }

    public void drawShape(Shape shape) {
        this.drawShape(shape, null);
    }

    public void drawShape(Shape s, RenderParameters rp) {
        if (s == null) {
            return;
        }
        this.shape = s;
        this.shapeParams = new RenderParameters(rp);
        s.applyMatrix();
        for (Face face : s.getFaces()) {
            if (!this.shouldRenderFace(face)) continue;
            this.drawFace(face, face.getParameters());
        }
    }

    public void drawFace(Face face) {
        this.drawFace(face, face.getParameters());
    }

    protected void drawFace(Face f, RenderParameters rp) {
        this.face = f;
        this.params = RenderParameters.merge(this.shapeParams, rp);
        IIcon icon = this.params.icon;
        if (this.params.useCustomTexture.booleanValue()) {
            icon = new BaseIcon();
        } else if (this.overrideTexture != null) {
            icon = this.overrideTexture;
        } else if (this.block != null && icon == null) {
            int side = 0;
            if (this.params.textureSide != null) {
                side = this.params.textureSide.ordinal();
            }
            icon = this.block.func_149691_a(side, this.blockMetadata);
        }
        if (this.params.interpolateUV.booleanValue() && this.params.textureSide != null) {
            this.interpolateUV(this.getRenderBounds());
        }
        if (icon != null) {
            this.face.setTexture(icon, this.params.uvFactor, this.params.flipU, this.params.flipV);
        }
        if (this.typeRender != 1 && this.typeRender != 4 || this.params.useNormals.booleanValue()) {
            this.t.func_78375_b((float)this.params.direction.offsetX, (float)this.params.direction.offsetY, (float)this.params.direction.offsetZ);
        }
        this.baseBrightness = this.getBaseBrightness();
        if (this.params.vertexPositionRelativeToRenderBounds.booleanValue()) {
            this.calcVertexesPosition(this.getRenderBounds());
        }
        this.drawVertexes(this.face.getVertexes());
    }

    protected void drawVertexes(Vertex[] vertexes) {
        for (int i = 0; i < vertexes.length; ++i) {
            this.drawVertex(vertexes[i], i);
            if (this.modeRender != 1) continue;
            this.drawVertex(vertexes[i == vertexes.length - 1 ? 0 : i + 1], i);
        }
    }

    protected void drawVertex(Vertex vertex, int count) {
        int brightness = this.baseBrightness;
        if (this.modeRender == 0 && this.typeRender == 1 && this.params.calculateBrightness.booleanValue()) {
            brightness = this.calcVertexBrightness(vertex, this.params.aoMatrix[count]);
        }
        vertex.setBrightness(brightness);
        int color = this.params.colorMultiplier;
        if (this.modeRender == 0 && this.typeRender == 1 && this.params.calculateAOColor.booleanValue()) {
            color = this.calcVertexColor(vertex, this.params.aoMatrix[count]);
        }
        vertex.setColor(color);
        if (!this.params.usePerVertexAlpha.booleanValue()) {
            vertex.setAlpha(this.params.alpha);
        }
        this.t.func_78384_a(vertex.getColor(), vertex.getAlpha());
        this.t.func_78380_c(vertex.getBrightness());
        if (this.modeRender == 0 && this.params.useTexture.booleanValue()) {
            this.t.func_78374_a(vertex.getX(), vertex.getY(), vertex.getZ(), vertex.getU(), vertex.getV());
        } else {
            this.t.func_78377_a(vertex.getX(), vertex.getY(), vertex.getZ());
        }
    }

    protected boolean shouldRenderFace(Face face) {
        if (this.typeRender != 1 || this.world == null || this.block == null) {
            return true;
        }
        if (this.shapeParams != null && this.shapeParams.renderAllFaces != null && this.shapeParams.renderAllFaces.booleanValue()) {
            return true;
        }
        RenderParameters p = face.getParameters();
        if (p == null || p.direction == null) {
            return true;
        }
        boolean b = this.block.func_149646_a(this.world, this.x + p.direction.offsetX, this.y + p.direction.offsetY, this.z + p.direction.offsetZ, p.direction.ordinal());
        return b;
    }

    protected void interpolateUV(double[][] bounds) {
        float x = (float)bounds[0][0];
        float X = (float)bounds[1][0];
        float Y = 1.0f - (float)bounds[0][1];
        float y = 1.0f - (float)bounds[1][1];
        float z = (float)bounds[0][2];
        float Z = (float)bounds[1][2];
        for (int i = 0; i < this.params.uvFactor.length; ++i) {
            float[] uv = this.params.uvFactor[i];
            switch (this.params.textureSide) {
                case NORTH: {
                    uv[0] = this.limitUV(uv[0], 1.0f - X, 1.0f - x);
                    uv[1] = this.limitUV(uv[1], y, Y);
                    break;
                }
                case SOUTH: {
                    uv[0] = this.limitUV(uv[0], x, X);
                    uv[1] = this.limitUV(uv[1], y, Y);
                    break;
                }
                case EAST: {
                    uv[0] = this.limitUV(uv[0], 1.0f - Z, 1.0f - z);
                    uv[1] = this.limitUV(uv[1], y, Y);
                    break;
                }
                case WEST: {
                    uv[0] = this.limitUV(uv[0], z, Z);
                    uv[1] = this.limitUV(uv[1], y, Y);
                    break;
                }
                case UP: 
                case DOWN: {
                    uv[0] = this.limitUV(uv[0], x, X);
                    uv[1] = this.limitUV(uv[1], z, Z);
                }
            }
            this.params.uvFactor[i] = uv;
        }
    }

    protected float limitUV(float f, float min, float max) {
        if (max - min < 1.0f) {
            return Math.max(Math.min(f, max), min);
        }
        return f;
    }

    protected int calcVertexColor(Vertex vertex, int[][] aoMatrix) {
        float factor = this.getBlockAmbientOcclusion(this.world, this.x + this.params.direction.offsetX, this.y + this.params.direction.offsetY, this.z + this.params.direction.offsetZ);
        for (int i = 0; i < aoMatrix.length; ++i) {
            factor += this.getBlockAmbientOcclusion(this.world, this.x + aoMatrix[i][0], this.y + aoMatrix[i][1], this.z + aoMatrix[i][2]);
        }
        int color = this.params.usePerVertexColor != false ? vertex.getColor() : this.params.colorMultiplier.intValue();
        int r = (int)((float)(color >> 16 & 0xFF) * (factor *= this.params.colorFactor.floatValue()) / (float)(aoMatrix.length + 1));
        int g = (int)((float)(color >> 8 & 0xFF) * factor / (float)(aoMatrix.length + 1));
        int b = (int)((float)(color & 0xFF) * factor / (float)(aoMatrix.length + 1));
        color = r << 16 | g << 8 | b;
        return color;
    }

    protected int getBaseBrightness() {
        if (this.typeRender != 1 && this.typeRender != 4 || this.world == null || !this.params.useBlockBrightness.booleanValue() || this.params.direction == null) {
            return this.params.brightness;
        }
        double[][] bounds = this.getRenderBounds();
        int ox = this.x + this.params.direction.offsetX;
        int oy = this.y + this.params.direction.offsetY;
        int oz = this.z + this.params.direction.offsetZ;
        if (this.params.direction == ForgeDirection.WEST && bounds[0][0] > 0.0) {
            ++ox;
        } else if (this.params.direction == ForgeDirection.EAST && bounds[1][0] < 1.0) {
            --ox;
        } else if (this.params.direction == ForgeDirection.NORTH && bounds[0][1] > 0.0) {
            ++oz;
        } else if (this.params.direction == ForgeDirection.SOUTH && bounds[1][1] < 1.0) {
            --oz;
        } else if (this.params.direction == ForgeDirection.DOWN && bounds[0][2] > 0.0) {
            ++oy;
        } else if (this.params.direction == ForgeDirection.UP && bounds[1][2] < 1.0) {
            --oy;
        }
        return this.getMixedBrightnessForBlock(this.world, ox, oy, oz);
    }

    protected int calcVertexBrightness(Vertex vertex, int[][] aoMatrix) {
        int[] b = new int[Math.max(3, aoMatrix.length)];
        for (int i = 0; i < aoMatrix.length; ++i) {
            int n = i;
            b[n] = b[n] + this.getMixedBrightnessForBlock(this.world, this.x + aoMatrix[i][0], this.y + aoMatrix[i][1], this.z + aoMatrix[i][2]);
        }
        int brightness = this.getAoBrightness(b[0], b[1], b[2], this.baseBrightness);
        return brightness;
    }

    protected int getAoBrightness(int b1, int b2, int b3, int base) {
        if (b1 == 0) {
            b1 = base;
        }
        if (b2 == 0) {
            b2 = base;
        }
        if (b3 == 0) {
            b3 = base;
        }
        return b1 + b2 + b3 + base >> 2 & 0xFF00FF;
    }

    protected float getBlockAmbientOcclusion(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return 1.0f;
        }
        return block.func_149685_I();
    }

    protected int getMixedBrightnessForBlock(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149677_c(world, x, y, z);
    }

    protected double[][] getRenderBounds() {
        if (this.block == null || !this.params.useBlockBounds.booleanValue()) {
            return this.params.renderBounds;
        }
        if (this.world != null) {
            this.block.func_149719_a(this.world, this.x, this.y, this.z);
        }
        return new double[][]{{this.block.func_149704_x(), this.block.func_149665_z(), this.block.func_149706_B()}, {this.block.func_149753_y(), this.block.func_149669_A(), this.block.func_149693_C()}};
    }

    protected void calcVertexesPosition(double[][] bounds) {
        for (Vertex v : this.face.getVertexes()) {
            v.interpolateCoord(bounds);
        }
    }

    public static <T extends BaseRenderer> T create(Class<T> clazz) {
        try {
            BaseRenderer r = (BaseRenderer)((Object)clazz.newInstance());
            int nextId = RenderingRegistry.getNextAvailableRenderId();
            clazz.getField("renderId").set(null, nextId);
            return (T)((Object)r);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public int getRenderId() {
        try {
            return (Integer)((Object)((Object)this)).getClass().getField("renderId").get(null);
        }
        catch (ReflectiveOperationException e) {
            return -1;
        }
    }

    private class BaseIcon
    implements IIcon {
        private BaseIcon() {
        }

        public int func_94211_a() {
            return 0;
        }

        public int func_94216_b() {
            return 0;
        }

        public float func_94209_e() {
            return 0.0f;
        }

        public float func_94212_f() {
            return 1.0f;
        }

        public float func_94214_a(double var1) {
            return (float)var1;
        }

        public float func_94206_g() {
            return 0.0f;
        }

        public float func_94210_h() {
            return 1.0f;
        }

        public float func_94207_b(double var1) {
            return (float)var1;
        }

        public String func_94215_i() {
            return null;
        }
    }
}

