/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.util.shape;

import net.malisis.core.client.gui.util.shape.Point;

public class Rectangle {
    private final Point start;
    private final Point end;

    public Rectangle(int width, int height) {
        this(new Point(), width, height);
    }

    public Rectangle(Point start, int width, int height) {
        this(start, new Point(start.x + width, start.y + height));
    }

    public Rectangle(Point start, Point end) {
        this.start = start;
        this.end = end;
    }

    public Rectangle(int x, int y, int width, int height) {
        this(new Point(x, y), width, height);
    }

    public static Rectangle add(Rectangle rect, int width, int height) {
        return new Rectangle(rect.start.x, rect.start.y, rect.getWidth() + width, rect.getHeight() + height);
    }

    public int getWidth() {
        return Math.abs(this.start.x - this.end.x);
    }

    public void setWidth(int width) {
        this.end.set(this.start.x + width, this.end.y);
    }

    public int getHeight() {
        return Math.abs(this.start.y - this.end.y);
    }

    public void setHeight(int height) {
        this.end.set(this.end.x, this.start.y + height);
    }

    public static Rectangle translate(Rectangle rect, int dx, int dy) {
        return new Rectangle(rect.start.x + dx, rect.start.y + dy, rect.getWidth(), rect.getHeight());
    }

    public Rectangle resize(int newWidth, int newHeight) {
        this.setSize(newWidth, newHeight);
        return this;
    }

    public void setSize(int width, int height) {
        this.end.set(this.start.x + width, this.start.y + height);
    }

    public Rectangle translate(int dx, int dy) {
        this.start.translate(dx, dy);
        this.end.translate(dx, dy);
        return this;
    }

    public boolean contains(Point point) {
        return this.start.x < point.x && this.start.y < point.y && this.end.x > point.x && this.end.y > point.y;
    }

    public Point getStart() {
        return this.start;
    }

    public void setStart(Point start) {
        this.start.set(start.x, start.y);
    }

    public void setStart(int x, int y) {
        this.start.set(x, y);
    }

    public Point getEnd() {
        return this.end;
    }

    public void setEnd(Point end) {
        this.end.set(end.x, end.y);
    }

    public void setEnd(int x, int y) {
        this.end.set(x, y);
    }

    public String toString() {
        return this.getClass().getName() + "[ start=" + this.start + ", end=" + this.end + ", width=" + this.getWidth() + ", height=" + this.getHeight() + " ]";
    }
}

