/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.asm;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class AsmUtils {
    public static MethodNode findMethod(ClassNode clazz, String name) {
        for (MethodNode method : clazz.methods) {
            if (!method.name.equals(name)) continue;
            return method;
        }
        return null;
    }

    public static MethodNode findMethod(ClassNode clazz, String name, String desc) {
        for (MethodNode method : clazz.methods) {
            if (!method.name.equals(name) || !method.desc.equals(desc)) continue;
            return method;
        }
        return null;
    }

    public static AbstractInsnNode findInstruction(MethodNode method, InsnList matches) {
        AbstractInsnNode match = matches.getFirst();
        for (AbstractInsnNode node = method.instructions.getFirst(); node != null; node = node.getNext()) {
            if (!AsmUtils.insnEqual(node, match)) continue;
            AbstractInsnNode m = match.getNext();
            for (AbstractInsnNode n = node.getNext(); m != null && n != null && AsmUtils.insnEqual(m, n); m = m.getNext(), n = n.getNext()) {
            }
            if (m != null) continue;
            return node;
        }
        return null;
    }

    public static boolean insnEqual(AbstractInsnNode node1, AbstractInsnNode node2) {
        if (node1 == null || node2 == null || node1.getOpcode() != node2.getOpcode()) {
            return false;
        }
        switch (node2.getType()) {
            case 2: {
                return AsmUtils.varInsnEqual((VarInsnNode)node1, (VarInsnNode)node2);
            }
            case 3: {
                return AsmUtils.typeInsnEqual((TypeInsnNode)node1, (TypeInsnNode)node2);
            }
            case 4: {
                return AsmUtils.fieldInsnEqual((FieldInsnNode)node1, (FieldInsnNode)node2);
            }
            case 5: {
                return AsmUtils.methodInsnEqual((MethodInsnNode)node1, (MethodInsnNode)node2);
            }
            case 9: {
                return AsmUtils.ldcInsnEqual((LdcInsnNode)node1, (LdcInsnNode)node2);
            }
            case 10: {
                return AsmUtils.iincInsnEqual((IincInsnNode)node1, (IincInsnNode)node2);
            }
            case 1: {
                return AsmUtils.intInsnEqual((IntInsnNode)node1, (IntInsnNode)node2);
            }
        }
        return true;
    }

    public static boolean varInsnEqual(VarInsnNode insn1, VarInsnNode insn2) {
        if (insn1.var == -1 || insn2.var == -1) {
            return true;
        }
        return insn1.var == insn2.var;
    }

    public static boolean methodInsnEqual(MethodInsnNode insn1, MethodInsnNode insn2) {
        return insn1.owner.equals(insn2.owner) && insn1.name.equals(insn2.name) && insn1.desc.equals(insn2.desc);
    }

    public static boolean fieldInsnEqual(FieldInsnNode insn1, FieldInsnNode insn2) {
        return insn1.owner.equals(insn2.owner) && insn1.name.equals(insn2.name) && insn1.desc.equals(insn2.desc);
    }

    public static boolean ldcInsnEqual(LdcInsnNode insn1, LdcInsnNode insn2) {
        if (insn1.cst.equals("~") || insn2.cst.equals("~")) {
            return true;
        }
        return insn1.cst.equals(insn2.cst);
    }

    public static boolean typeInsnEqual(TypeInsnNode insn1, TypeInsnNode insn2) {
        if (insn1.desc.equals("~") || insn2.desc.equals("~")) {
            return true;
        }
        return insn1.desc.equals(insn2.desc);
    }

    public static boolean iincInsnEqual(IincInsnNode node1, IincInsnNode node2) {
        return node1.var == node2.var && node1.incr == node2.incr;
    }

    public static boolean intInsnEqual(IntInsnNode node1, IntInsnNode node2) {
        if (node1.operand == -1 || node2.operand == -1) {
            return true;
        }
        return node1.operand == node2.operand;
    }

    public static String getMethodNodeAsString(MethodNode methodNode) {
        Textifier printer = new Textifier();
        TraceMethodVisitor methodPrinter = new TraceMethodVisitor((Printer)printer);
        methodNode.accept((MethodVisitor)methodPrinter);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }
}

