/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class VanishingTileEntity
extends TileEntity {
    public static final int maxTransitionTime = 6;
    public static final int maxVibratingTime = 15;
    public Block copiedBlock;
    public int copiedMetadata;
    public int frameType;
    public boolean powered;
    public int transitionTimer;
    public boolean inTransition;
    public boolean vibrating;
    public int vibratingTimer;
    private final Random rand = new Random();

    public VanishingTileEntity() {
        this.frameType = 0;
    }

    public VanishingTileEntity(int frameType) {
        if (frameType < 0 || frameType > 2) {
            frameType = 0;
        }
        this.frameType = frameType;
    }

    public void setBlock(Block block, int metadata) {
        this.copiedBlock = block;
        this.copiedMetadata = metadata;
    }

    public void setPowerState(boolean powered) {
        if (powered == this.powered) {
            return;
        }
        if (!this.inTransition) {
            this.transitionTimer = powered ? 0 : 6;
        }
        this.powered = powered;
        this.inTransition = true;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() | 8, 2);
    }

    public void func_145845_h() {
        if (!this.inTransition && !this.powered) {
            boolean b;
            float r = this.rand.nextFloat();
            boolean bl = b = r > 0.9995f;
            if (b) {
                this.vibrating = true;
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() | 8, 2);
            }
            if (this.vibrating && this.vibratingTimer++ >= 15) {
                this.vibrating = false;
                this.vibratingTimer = 0;
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() & 0xFFFFFFF7, 2);
            }
        } else if (this.inTransition) {
            this.vibrating = false;
            this.vibratingTimer = 0;
            if (this.powered) {
                ++this.transitionTimer;
                if (this.transitionTimer >= 6) {
                    this.inTransition = false;
                    this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), 0.0, 0.0, 0.0);
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() & 0xFFFFFFF7, 2);
                }
            } else {
                --this.transitionTimer;
                if (this.transitionTimer <= 0) {
                    this.inTransition = false;
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() & 0xFFFFFFF7, 2);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int blockID = nbt.func_74762_e("BlockID");
        if (blockID != 0) {
            this.copiedBlock = Block.func_149729_e((int)blockID);
            this.copiedMetadata = nbt.func_74762_e("BlockMetadata");
        }
        this.frameType = nbt.func_74762_e("FrameType");
        this.powered = nbt.func_74767_n("Powered");
        this.inTransition = nbt.func_74767_n("InTransition");
        this.transitionTimer = nbt.func_74762_e("TransitionTimer");
        this.vibrating = nbt.func_74767_n("Vibrating");
        this.vibratingTimer = nbt.func_74762_e("VibratingTimer");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.copiedBlock != null) {
            nbt.func_74768_a("BlockID", Block.field_149771_c.func_148757_b((Object)this.copiedBlock));
            nbt.func_74768_a("BlockMetadata", this.copiedMetadata);
        }
        nbt.func_74768_a("FrameType", this.frameType);
        nbt.func_74757_a("Powered", this.powered);
        nbt.func_74757_a("InTransition", this.inTransition);
        nbt.func_74768_a("TransitionTimer", this.transitionTimer);
        nbt.func_74757_a("Vibrating", this.vibrating);
        nbt.func_74768_a("VibratingTimer", this.vibratingTimer);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

