/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.malisis.doors.entity.VanishingTileEntity;
import net.malisis.doors.renderer.VanishingBlockRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class VanishingBlock
extends BlockContainer {
    public static final int typeWoodFrame = 0;
    public static final int typeIronFrame = 1;
    public static final int typeGoldFrame = 2;
    public static final int flagPowered = 4;
    public static final int flagInTransition = 8;
    private IIcon[] icons = new IIcon[3];

    public VanishingBlock() {
        super(Material.field_151575_d);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149711_c(0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons[0] = register.func_94245_a("malisisdoors:vanishing_block_wood");
        this.icons[1] = register.func_94245_a("malisisdoors:vanishing_block_iron");
        this.icons[2] = register.func_94245_a("malisisdoors:vanishing_block_gold");
    }

    public IIcon func_149691_a(int side, int frameType) {
        if ((frameType &= 3) == 1) {
            return this.icons[1];
        }
        if (frameType == 2) {
            return this.icons[2];
        }
        return this.icons[0];
    }

    public boolean isPowered(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this && (world.func_72805_g(x, y, z) & 4) != 0;
    }

    public void setPowerState(World world, int x, int y, int z, boolean powered) {
        if (world.func_147439_a(x, y, z) != this) {
            return;
        }
        if (this.isPowered(world, x, y, z) == powered) {
            return;
        }
        VanishingTileEntity te = (VanishingTileEntity)world.func_147438_o(x, y, z);
        te.setPowerState(powered);
        if (powered) {
            world.func_72921_c(x, y, z, te.field_145847_g | 4, 2);
        } else {
            world.func_72921_c(x, y, z, te.field_145847_g & 0xFFFFFFFB, 2);
        }
        world.func_147464_a(x, y, z, (Block)this, 1);
    }

    public boolean shouldPropagate(World world, int x, int y, int z, VanishingTileEntity source) {
        if (world.func_147439_a(x, y, z) != this) {
            return false;
        }
        if ((source.func_145832_p() & 3) == 0) {
            return true;
        }
        VanishingTileEntity dest = (VanishingTileEntity)world.func_147438_o(x, y, z);
        if (source.copiedBlock == null || dest.copiedBlock == null) {
            return true;
        }
        if ((source.func_145832_p() & 3) == 1 && source.copiedBlock == dest.copiedBlock) {
            return true;
        }
        return (source.func_145832_p() & 3) == 2 && source.copiedBlock == dest.copiedBlock && source.copiedMetadata == dest.copiedMetadata;
    }

    public void propagateState(World world, int x, int y, int z) {
        VanishingTileEntity te = (VanishingTileEntity)world.func_147438_o(x, y, z);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.shouldPropagate(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, te)) continue;
            this.setPowerState(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, te.powered);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer p, int par6, float par7, float par8, float par9) {
        ItemStack is = p.func_70694_bm();
        if (is == null) {
            return false;
        }
        Block block = Block.func_149634_a((Item)is.func_77973_b());
        if (!block.func_149721_r() || block == this) {
            return false;
        }
        VanishingTileEntity te = (VanishingTileEntity)world.func_147438_o(x, y, z);
        if (te.copiedBlock != null) {
            return false;
        }
        te.setBlock(block, is.func_77960_j());
        this.func_149711_c(block.func_149712_f(world, x, y, z));
        this.func_149672_a(block.field_149762_H);
        this.field_149765_K = block.field_149765_K;
        if (!p.field_71075_bZ.field_75098_d) {
            --is.field_77994_a;
        }
        world.func_147471_g(x, y, z);
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (world.field_72995_K) {
            return;
        }
        boolean powered = world.func_72864_z(x, y, z);
        if (powered || block.func_149744_f() && block != this) {
            if (this.isPowered(world, x, y, z) != powered) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "malisisdoors:portal", 0.3f, 0.5f);
            }
            this.setPowerState(world, x, y, z, powered);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.propagateState(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int j) {
        VanishingTileEntity te = (VanishingTileEntity)world.func_147438_o(x, y, z);
        if (te.copiedBlock != null) {
            te.copiedBlock.func_149697_b(world, x, y, z, te.copiedMetadata, 0);
        }
        world.func_147475_p(x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if ((world.func_72805_g(x, y, z) & 0xC) != 0) {
            return null;
        }
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if ((world.func_72805_g(x, y, z) & 0xC) != 0) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public boolean func_149721_r() {
        return false;
    }

    public float getAmbientOcclusionLightValue(IBlockAccess world, int x, int y, int z) {
        return (world.func_72805_g(x, y, z) & 0xC) == 0 ? 0.2f : 1.0f;
    }

    public int func_149645_b() {
        return VanishingBlockRenderer.renderId;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new VanishingTileEntity(metadata);
    }
}

