/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.malisis.doors.entity.MixedBlockTileEntity;
import net.malisis.doors.item.MixedBlockBlockItem;
import net.malisis.doors.renderer.block.MixedBlockRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MixedBlock
extends BlockContainer {
    public MixedBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(0.7f);
    }

    public void func_149651_a(IIconRegister p_149651_1_) {
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof MixedBlockBlockItem)) {
            return;
        }
        int side = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int metadata = 0;
        if (side == 0) {
            metadata = 2;
        }
        if (side == 1) {
            metadata = 5;
        }
        if (side == 2) {
            metadata = 3;
        }
        if (side == 3) {
            metadata = 4;
        }
        world.func_72921_c(x, y, z, metadata, 2);
        MixedBlockTileEntity te = (MixedBlockTileEntity)world.func_147438_o(x, y, z);
        Block block1 = Block.func_149729_e((int)itemStack.field_77990_d.func_74762_e("block1"));
        Block block2 = Block.func_149729_e((int)itemStack.field_77990_d.func_74762_e("block2"));
        int metadata1 = itemStack.field_77990_d.func_74762_e("metadata1");
        int metadata2 = itemStack.field_77990_d.func_74762_e("metadata2");
        te.setBlocks(block1, metadata1, block2, metadata2);
    }

    public int func_149645_b() {
        return MixedBlockRenderer.renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        MixedBlockRenderer.setRenderPass(pass);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        MixedBlockTileEntity te = (MixedBlockTileEntity)world.func_147438_o(x, y, z);
        if (te == null) {
            return true;
        }
        Block[] blocks = new Block[]{te.block1, te.block2};
        int[] metadata = new int[]{te.metadata1, te.metadata2};
        float f = 0.1f;
        ForgeDirection side = ForgeDirection.getOrientation((int)target.field_72310_e);
        double fxX = (double)x + world.field_73012_v.nextDouble();
        double fxY = (double)y + world.field_73012_v.nextDouble();
        double fxZ = (double)z + world.field_73012_v.nextDouble();
        switch (side) {
            case DOWN: 
            case UP: {
                fxY = (float)y + (float)side.offsetY * f;
                break;
            }
            case NORTH: 
            case SOUTH: {
                fxZ = (float)z + (float)side.offsetZ * f;
                break;
            }
            case EAST: 
            case WEST: {
                fxX = (float)x + (float)side.offsetX * f;
                break;
            }
        }
        int i = world.field_73012_v.nextBoolean() ? 0 : 1;
        EntityDiggingFX fx = new EntityDiggingFX(world, fxX, fxY, fxZ, 0.0, 0.0, 0.0, blocks[i], metadata[i]);
        fx.func_70543_e(0.2f).func_70541_f(0.6f);
        effectRenderer.func_78873_a((EntityFX)fx);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        int nb = 4;
        MixedBlockTileEntity te = (MixedBlockTileEntity)world.func_147438_o(x, y, z);
        if (te == null) {
            return true;
        }
        Block[] blocks = new Block[]{te.block1, te.block2};
        int[] metadata = new int[]{te.metadata1, te.metadata2};
        for (int i = 0; i < nb; ++i) {
            for (int j = 0; j < nb; ++j) {
                for (int k = 0; k < nb; ++k) {
                    double fxX = (double)x + ((double)i + 0.5) / (double)nb;
                    double fxY = (double)y + ((double)j + 0.5) / (double)nb;
                    double fxZ = (double)z + ((double)k + 0.5) / (double)nb;
                    int l = (i + j + k) % 2;
                    EntityDiggingFX fx = new EntityDiggingFX(world, fxX, fxY, fxZ, fxX - (double)x - 0.5, fxY - (double)y - 0.5, fxZ - (double)z - 0.5, blocks[l], metadata[l]);
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new MixedBlockTileEntity();
    }
}

