/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.inventories;

import aroma1997.core.client.inventories.GUIAromaBasic;
import aroma1997.core.client.inventories.GUIContainer;
import aroma1997.core.inventories.AromaContainer;
import aroma1997.core.inventories.ISpecialInventory;
import aroma1997.core.util.ItemUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@ChestContainer
public class ContainerBasic
extends AromaContainer {
    public final InventoryPlayer playerInv;
    public final ISpecialInventory inv;
    private boolean containerLayouted = false;

    public ContainerBasic(InventoryPlayer playerInv, ISpecialInventory inv) {
        this(playerInv, inv, true);
    }

    protected ContainerBasic(InventoryPlayer playerInv, ISpecialInventory inv, boolean shouldLayout) {
        this.playerInv = playerInv;
        this.inv = inv;
        if (shouldLayout) {
            this.layoutContainer();
        }
    }

    public void layoutContainer() {
        if (this.containerLayouted) {
            return;
        }
        this.inv.func_70295_k_();
        int c = 11 + this.getXOffset();
        int d = 9 + this.getYOffset();
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(this.getSlotForInv(this.playerInv, hotbarSlot, 8 + hotbarSlot * 18 + c, 160 + d));
        }
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.func_75146_a(this.getSlotForInv(this.playerInv, inventoryColumn + inventoryRow * 9 + 9, 8 + inventoryColumn * 18 + c, 102 + inventoryRow * 18 + d));
            }
        }
        int rows = this.getAmountRows();
        int perRow = this.getAmountPerRow();
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            this.func_75146_a(this.inv.getSlot(i, i, i % perRow * 18 + 89 - perRow * 9 + c, i / perRow * 18 + (4 - rows) * 18 + 19 + d));
        }
        this.containerLayouted = true;
    }

    protected Slot getSlotForInv(InventoryPlayer inv, int index, int x, int y) {
        return new Slot((IInventory)inv, index, x, y);
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.inv.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(par2);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (par2 < 36 ? !this.func_75135_a(itemstack1, 36, this.field_75151_b.size(), false) : !this.func_75135_a(itemstack1, 0, 36, false)) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public int getAmountRows() {
        return (int)Math.max(Math.sqrt(this.inv.func_70302_i_()) * 0.7, 1.0);
    }

    @ChestContainer.RowSizeCallback
    public int getAmountPerRow() {
        int c = this.inv.func_70302_i_() / this.getAmountRows();
        if (this.getAmountRows() * c < this.inv.func_70302_i_()) {
            ++c;
        }
        return c;
    }

    public int getYOffset() {
        int o = -(5 - this.getAmountRows()) * 18 - 7;
        if (!this.isLargeChest()) {
            o += 9;
        }
        return o;
    }

    public int getXOffset() {
        return -(11 - Math.max(this.getAmountPerRow(), 9)) * 9 + 2;
    }

    public ItemStack func_75144_a(int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        return super.func_75144_a(par1, par2, par3, par4EntityPlayer);
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        this.inv.func_70305_f();
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> func() {
        int i;
        HashMap<ContainerSection, List<Slot>> map = new HashMap<ContainerSection, List<Slot>>();
        ArrayList<Slot> inventorySlots = new ArrayList<Slot>();
        ArrayList<Slot> chest = new ArrayList<Slot>();
        for (i = 0; i < 36; ++i) {
            inventorySlots.add(this.func_75139_a(i));
        }
        for (i = 36; i < this.field_75151_b.size(); ++i) {
            chest.add(this.func_75139_a(i));
        }
        map.put(ContainerSection.INVENTORY, inventorySlots);
        map.put(ContainerSection.CHEST, chest);
        return map;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getContainer() {
        return new GUIContainer(this);
    }

    @Override
    public void drawGuiContainerForegroundLayer(GUIAromaBasic gui, int par1, int par2) {
    }

    protected boolean func_75135_a(ItemStack par1ItemStack, int par2, int par3, boolean par4) {
        ItemStack itemstack1;
        Slot slot;
        boolean flag1 = false;
        int k = par2;
        if (par4) {
            k = par3 - 1;
        }
        if (par1ItemStack.func_77985_e()) {
            while (par1ItemStack.field_77994_a > 0 && (!par4 && k < par3 || par4 && k >= par2)) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (ItemUtil.areItemsSameMatching(par1ItemStack, itemstack1, ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE, ItemUtil.ItemMatchCriteria.NBT) && slot.func_75214_a(par1ItemStack)) {
                    int l = itemstack1.field_77994_a + par1ItemStack.field_77994_a;
                    if (l <= par1ItemStack.func_77976_d()) {
                        par1ItemStack.field_77994_a = 0;
                        itemstack1.field_77994_a = l;
                        slot.func_75218_e();
                        flag1 = true;
                    } else if (itemstack1.field_77994_a < par1ItemStack.func_77976_d()) {
                        par1ItemStack.field_77994_a -= par1ItemStack.func_77976_d() - itemstack1.field_77994_a;
                        itemstack1.field_77994_a = par1ItemStack.func_77976_d();
                        slot.func_75218_e();
                        flag1 = true;
                    }
                }
                if (par4) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        if (par1ItemStack.field_77994_a > 0) {
            k = par4 ? par3 - 1 : par2;
            while (!par4 && k < par3 || par4 && k >= par2) {
                slot = (Slot)this.field_75151_b.get(k);
                itemstack1 = slot.func_75211_c();
                if (itemstack1 == null && slot.func_75214_a(par1ItemStack)) {
                    slot.func_75215_d(par1ItemStack.func_77946_l());
                    slot.func_75218_e();
                    par1ItemStack.field_77994_a = 0;
                    flag1 = true;
                    break;
                }
                if (par4) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    @ChestContainer.IsLargeCallback
    public boolean isLargeChest() {
        return this.getAmountPerRow() > 5;
    }
}

