/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import mod.lucky.Lucky;
import mod.lucky.drop.LuckyDropBase;
import mod.lucky.util.ExpressionParser;
import net.minecraft.item.Item;

public class LuckyConfiguration {
    public static String getConfigVersion() {
        File file = new File("config/lucky/LuckyBlockProperties.txt");
        if (!file.exists()) {
            return "";
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("config/lucky/LuckyBlockProperties.txt")));
            String version = br.readLine();
            br.close();
            if (version != null) {
                return version;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void readConfig() {
        try {
            String currLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("config/lucky/LuckyBlockProperties.txt")));
            String section = "";
            boolean addSeparator = false;
            ArrayList<LuckyDropBase> drops = new ArrayList<LuckyDropBase>();
            ArrayList<Item> luckyCraftingItemsList = new ArrayList<Item>();
            ArrayList<Integer> luckyCraftingItemDamageList = new ArrayList<Integer>();
            ArrayList<Integer> luckyCraftingLevelsList = new ArrayList<Integer>();
            int dropNum = 0;
            String currDropLine = "";
            ExpressionParser expresisonParser = ExpressionParser.instance;
            while ((currLine = br.readLine()) != null) {
                if (currLine.startsWith(">")) {
                    section = currLine;
                    continue;
                }
                if (currLine.startsWith("/") || currLine.equals("")) continue;
                try {
                    String value;
                    String name;
                    if (section.equals(">properties")) {
                        name = currLine.substring(0, currLine.indexOf(61));
                        value = currLine.substring(currLine.indexOf(61) + 1, currLine.length());
                        if (name.equals("recipe")) {
                            Lucky.instance.luckyCrafting.setLuckyBlockRecipe(value);
                        }
                        if (name.equals("spawnrate")) {
                            Lucky.instance.luckyGenerator.setSpawnrate(expresisonParser.getInteger(value));
                        }
                        if (name.equals("structureChance")) {
                            Lucky.instance.luckyGenerator.setStructureChance(expresisonParser.getInteger(value));
                        }
                        if (name.equals("doDropsOnCreativeMode")) {
                            Lucky.instance.doDropsOnCreativeMode = expresisonParser.getBoolean(currLine);
                        }
                    }
                    if (section.equals(">craftingitems")) {
                        name = currLine.substring(0, currLine.indexOf(61));
                        value = currLine.substring(currLine.indexOf(61) + 1, currLine.length());
                        String damageString = "";
                        if (name.indexOf(44) != -1) {
                            damageString = name.substring(name.indexOf(44) + 1, name.length());
                            name = name.substring(0, name.indexOf(44));
                        }
                        Item item = (Item)Item.field_150901_e.func_82594_a(name);
                        int luck = 0;
                        int damage = -1;
                        try {
                            luck = expresisonParser.getInteger(value);
                            damage = expresisonParser.getInteger(damageString);
                        }
                        catch (ExpressionParser.ExpressionParserException e) {
                            // empty catch block
                        }
                        luckyCraftingItemsList.add(item);
                        luckyCraftingItemDamageList.add(damage);
                        luckyCraftingLevelsList.add(luck);
                    }
                    if (!section.equals(">drops")) continue;
                    boolean dropContinues = false;
                    if (currLine.endsWith(">")) {
                        currLine = currLine.substring(0, currLine.length() - 1);
                        dropContinues = true;
                    }
                    currDropLine = currDropLine + currLine;
                    if (dropContinues) continue;
                    drops.add(dropNum, new LuckyDropBase(currDropLine));
                    currDropLine = "";
                    ++dropNum;
                }
                catch (Exception e) {
                    System.err.println("The Lucky Block encountered and error while reading properties from the config file. Error report below:");
                    e.printStackTrace();
                }
            }
            br.close();
            Lucky.instance.allDrops = drops.toArray(new LuckyDropBase[drops.size()]);
            Lucky.instance.luckyCrafting.luckyCraftingItems = luckyCraftingItemsList.toArray(new Item[luckyCraftingItemsList.size()]);
            Lucky.instance.luckyCrafting.luckyCraftingItemDamage = LuckyConfiguration.convertIntListToArray(luckyCraftingItemDamageList);
            Lucky.instance.luckyCrafting.luckyCraftingLevels = LuckyConfiguration.convertIntListToArray(luckyCraftingLevelsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createNewConfigFile() {
        try {
            String currLine;
            File destFile = new File("config/lucky/LuckyBlockProperties.txt");
            if (destFile.exists()) {
                destFile.delete();
            }
            destFile.getParentFile().mkdirs();
            destFile.createNewFile();
            BufferedReader br = new BufferedReader(new InputStreamReader(Lucky.class.getResourceAsStream("files/LuckyBlockProperties.txt")));
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("config/lucky/LuckyBlockProperties.txt")));
            boolean firstLine = true;
            while ((currLine = br.readLine()) != null) {
                if (!firstLine) {
                    bw.newLine();
                }
                firstLine = false;
                bw.write(currLine);
            }
            br.close();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fixIds(String drop) {
        int[] point = new int[10];
        String[] idWholeString = new String[10];
        String[] idWholeStringNew = new String[10];
        int amountOfIds = 0;
        for (int b = 0; b < 10; ++b) {
            point[b] = drop.indexOf("ID=", b == 0 ? 0 : point[b - 1] + 1);
            if (point[b] == -1) break;
            int endPoint = -1;
            int currEndPoint = drop.indexOf(44, point[b]);
            if (currEndPoint != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            if ((currEndPoint = drop.indexOf(59, point[b])) != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            if ((currEndPoint = drop.indexOf(41, point[b])) != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            if ((currEndPoint = drop.length()) != -1 && (currEndPoint < endPoint || endPoint == -1)) {
                endPoint = currEndPoint;
            }
            idWholeString[b] = drop.substring(point[b], endPoint);
            try {
                int idInt = Integer.valueOf(idWholeString[b].split("=")[1]);
                String idName = Item.field_150901_e.func_148750_c((Object)Item.func_150899_d((int)idInt)).split(":")[1];
                idWholeStringNew[b] = "ID=" + idName;
            }
            catch (Exception e) {
                idWholeStringNew[b] = idWholeString[b];
            }
            ++amountOfIds;
        }
        String newDrop = drop;
        for (int b = 0; b < amountOfIds; ++b) {
            newDrop = newDrop.replaceAll(idWholeString[b], idWholeStringNew[b]);
        }
        newDrop = newDrop.replaceAll("name", "ID");
        System.out.println(newDrop);
    }

    public static int[] convertIntListToArray(ArrayList<Integer> integerList) {
        int[] integers = new int[integerList.size()];
        Iterator<Integer> iterator = integerList.iterator();
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = iterator.next();
        }
        return integers;
    }
}

