/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.util.Random;
import mod.lucky.Lucky;
import mod.lucky.util.LuckyFunction;
import mod.lucky.util.StructureUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class CustomStructures {
    public static Random random = new Random();

    public static void setRandom(Random newRandom) {
        random = newRandom;
    }

    public static void makeCage(World world, EntityPlayer player, int posX, int posY, int posZ, int height) {
        StructureUtil.fill(world, posX - 1, posY - 1, posZ - 1, 3, 1, 3, Blocks.field_150417_aV);
        StructureUtil.fillPerimiter(world, posX - 1, posY, posZ - 1, 3, height, 3, Blocks.field_150411_aY);
    }

    public static void makeWaterCage(World world, EntityPlayer player, int posX, int posY, int posZ) {
        StructureUtil.fill(world, posX - 1, posY - 1, posZ - 1, 3, 1, 3, Blocks.field_150343_Z);
        StructureUtil.fillPerimiter(world, posX - 1, posY, posZ - 1, 3, 1, 3, Blocks.field_150343_Z);
        StructureUtil.fillPerimiter(world, posX - 1, posY + 1, posZ - 1, 3, 1, 3, Blocks.field_150359_w);
        StructureUtil.fill(world, posX - 1, posY + 2, posZ - 1, 3, 1, 3, Blocks.field_150343_Z);
        StructureUtil.fill(world, posX, posY, posZ, 1, 2, 1, (Block)Blocks.field_150358_i);
    }

    public static void makeFort(World world, EntityPlayer player, int posX, int posY, int posZ) {
        StructureUtil.fill(world, posX - 1, posY, posZ - 1, 3, 2, 3, Blocks.field_150350_a);
        StructureUtil.fill(world, posX - 2, posY - 1, posZ - 2, 5, 1, 5, Blocks.field_150322_A);
        StructureUtil.fillPerimiter(world, posX - 2, posY, posZ - 2, 5, 2, 5, Blocks.field_150322_A);
        StructureUtil.fillCorners(world, posX - 2, posY + 2, posZ - 2, 5, 1, 5, Blocks.field_150340_R);
        StructureUtil.setRandomLuckyBlock(world, random, posX + 1, posY, posZ + 1);
        StructureUtil.setRandomLuckyBlock(world, random, posX - 1, posY, posZ - 1);
        StructureUtil.setRandomLuckyBlock(world, random, posX + 1, posY, posZ - 1);
        StructureUtil.setRandomLuckyBlock(world, random, posX - 1, posY, posZ + 1);
    }

    public static void makePitTrap(World world, EntityPlayer player, int posX, int posY, int posZ) {
        StructureUtil.fill(world, posX - 1, posY - 60, posZ - 1, 3, 60, 3, Blocks.field_150350_a);
        StructureUtil.fill(world, posX - 1, posY - 59, posZ - 1, 3, 1, 3, (Block)Blocks.field_150356_k);
        StructureUtil.fill(world, posX - 1, posY - 58, posZ - 1, 3, 1, 3, Blocks.field_150321_G);
    }

    public static void makeTemple(World world, EntityPlayer player, int posX, int posY, int posZ) {
        StructureUtil.fill(world, posX - 3, posY - 1, posZ - 3, 7, 1, 7, Blocks.field_150322_A);
        StructureUtil.fillPerimiterStairs(world, posX - 3, posY, posZ - 3, 7, 1, 7, (BlockStairs)Blocks.field_150372_bz);
        StructureUtil.fill(world, posX - 2, posY, posZ - 2, 5, 1, 5, Blocks.field_150350_a);
        StructureUtil.fillPerimiterStairs(world, posX - 2, posY + 1, posZ - 2, 5, 1, 5, (BlockStairs)Blocks.field_150372_bz);
        StructureUtil.fill(world, posX - 1, posY + 1, posZ - 1, 3, 1, 3, Blocks.field_150350_a);
        StructureUtil.fillPerimiterStairs(world, posX - 1, posY + 2, posZ - 1, 3, 1, 3, (BlockStairs)Blocks.field_150372_bz);
        StructureUtil.setBlock(world, posX, posY + 3, posZ, Blocks.field_150340_R);
        StructureUtil.setBlock(world, posX, posY + 2, posZ, Blocks.field_150350_a);
        StructureUtil.fillCorners(world, posX - 3, posY, posZ - 3, 7, 3, 7, Blocks.field_150322_A);
        StructureUtil.fillCorners(world, posX - 3, posY + 3, posZ - 3, 7, 1, 7, Blocks.field_150340_R);
        StructureUtil.setBlock(world, posX, posY + 1, posZ - 1, Blocks.field_150478_aa, 3);
        StructureUtil.setBlock(world, posX + 1, posY + 1, posZ, Blocks.field_150478_aa, 2);
        StructureUtil.setBlock(world, posX, posY + 1, posZ + 1, Blocks.field_150478_aa, 4);
        StructureUtil.setBlock(world, posX - 1, posY + 1, posZ, Blocks.field_150478_aa, 1);
        for (int x = posX - 2; x <= posX + 2; ++x) {
            for (int z = posZ - 2; z <= posZ + 2; ++z) {
                if (!StructureUtil.isCorner(posX, posZ, x, z, 2) && !StructureUtil.isCenterEdge(posX, posZ, x, z, 2)) continue;
                StructureUtil.setRandomLuckyBlock(world, random, x, posY, z);
            }
        }
    }

    public static void makeLuckyBlockChoice(World world, EntityPlayer player, int posX, int posY, int posZ, String[] text) {
        int playerDirection = LuckyFunction.getPlayerDirection(player, 4);
        int luck1 = random.nextInt(2) == 0 ? 100 : -100;
        int luck2 = luck1 == 100 ? -100 : 100;
        switch (playerDirection) {
            case 0: {
                StructureUtil.setLuckyBlock(world, posX - 1, posY, posZ + 2, luck1);
                StructureUtil.setLuckyBlock(world, posX + 1, posY, posZ + 2, luck2);
                StructureUtil.makeSign(world, posX, posY, posZ + 2, Blocks.field_150472_an, 8, text);
                break;
            }
            case 1: {
                StructureUtil.setLuckyBlock(world, posX - 2, posY, posZ - 1, luck1);
                StructureUtil.setLuckyBlock(world, posX - 2, posY, posZ + 1, luck2);
                StructureUtil.makeSign(world, posX - 2, posY, posZ, Blocks.field_150472_an, 12, text);
                break;
            }
            case 2: {
                StructureUtil.setLuckyBlock(world, posX - 1, posY, posZ - 2, luck1);
                StructureUtil.setLuckyBlock(world, posX + 1, posY, posZ - 2, luck2);
                StructureUtil.makeSign(world, posX, posY, posZ - 2, Blocks.field_150472_an, 0, text);
                break;
            }
            case 3: {
                StructureUtil.setLuckyBlock(world, posX + 2, posY, posZ - 1, luck1);
                StructureUtil.setLuckyBlock(world, posX + 2, posY, posZ + 1, luck2);
                StructureUtil.makeSign(world, posX + 2, posY, posZ, Blocks.field_150472_an, 4, text);
            }
        }
    }

    public static void makeWishingWell(World world, EntityPlayer player, int posX, int posY, int posZ, NBTTagCompound nbtTagCompound) {
        StructureUtil.fill(world, posX, posY, posZ, 1, 256, 1, Blocks.field_150350_a);
        StructureUtil.fill(world, posX - 2, posY, posZ - 2, 5, 20, 5, Blocks.field_150350_a);
        StructureUtil.fill(world, posX - 1, posY - 2, posZ - 1, 3, 1, 3, Blocks.field_150339_S);
        StructureUtil.fillPerimiter(world, posX - 1, posY - 1, posZ - 1, 3, 2, 3, Blocks.field_150347_e);
        StructureUtil.fillCorners(world, posX - 1, posY + 1, posZ - 1, 3, 2, 3, Blocks.field_150422_aJ);
        StructureUtil.fillPerimiterStairs(world, posX - 1, posY + 3, posZ - 1, 3, 1, 3, (BlockStairs)Blocks.field_150446_ar);
        StructureUtil.setBlock(world, posX, posY + 3, posZ, Blocks.field_150359_w);
        StructureUtil.setBlock(world, posX, posY - 1, posZ, Blocks.field_150452_aw);
        StructureUtil.setBlock(world, posX, posY, posZ, Blocks.field_150355_j);
    }

    public static void makeCageSign(World world, EntityPlayer player, int posX, int posY, int posZ, String[] text) {
        int playerDirection = LuckyFunction.getPlayerDirection(player, 4);
        switch (playerDirection) {
            case 0: {
                StructureUtil.setBlock(world, posX, posY - 1, posZ + 2, Blocks.field_150417_aV);
                StructureUtil.makeSign(world, posX, posY, posZ + 2, Blocks.field_150472_an, 8, text);
                break;
            }
            case 1: {
                StructureUtil.setBlock(world, posX - 2, posY - 1, posZ, Blocks.field_150417_aV);
                StructureUtil.makeSign(world, posX - 2, posY, posZ, Blocks.field_150472_an, 12, text);
                break;
            }
            case 2: {
                StructureUtil.setBlock(world, posX, posY - 1, posZ - 2, Blocks.field_150417_aV);
                StructureUtil.makeSign(world, posX, posY, posZ - 2, Blocks.field_150472_an, 0, text);
                break;
            }
            case 3: {
                StructureUtil.setBlock(world, posX + 2, posY - 1, posZ, Blocks.field_150417_aV);
                StructureUtil.makeSign(world, posX + 2, posY, posZ, Blocks.field_150472_an, 4, text);
            }
        }
    }

    public static void makeLuckyGenStructure(World world, Random random, int posX, int posY, int posZ) {
        StructureUtil.fill(world, posX - 2, posY, posZ - 3, 5, 4, 7, Blocks.field_150350_a);
        StructureUtil.fill(world, posX - 1, posY, posZ - 2, 3, 1, 5, Blocks.field_150371_ca);
        StructureUtil.fillPerimiterStairs(world, posX - 2, posY, posZ - 3, 5, 1, 7, (BlockStairs)Blocks.field_150370_cb);
        for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int z = posZ - 2; z <= posZ + 2; ++z) {
                if (!StructureUtil.isCorner(posX, posZ - 1, x, z, 1) && !StructureUtil.isCorner(posX, posZ + 1, x, z, 1)) continue;
                StructureUtil.fill(world, x, posY + 1, z, 1, 3, 1, Blocks.field_150371_ca, 2);
            }
        }
        StructureUtil.fillPerimiter(world, posX - 2, posY + 3, posZ - 3, 5, 1, 7, (Block)Blocks.field_150333_U, 15);
        StructureUtil.fill(world, posX - 1, posY + 4, posZ - 3, 3, 1, 7, (Block)Blocks.field_150333_U, 7);
        StructureUtil.setLuckyBlock(world, posX, posY + 1, posZ, MathHelper.func_76136_a((Random)random, (int)50, (int)100));
    }

    public static void makeUnluckyGenStructure(World world, Random random, int posX, int posY, int posZ) {
        int z;
        int x;
        for (x = posX - 3; x <= posX + 3; ++x) {
            for (z = posZ - 3; z <= posZ + 3; ++z) {
                if (x == posX - 3 || x == posX + 3 || z == posZ - 3 || z == posZ + 3) {
                    if (random.nextInt(3) != 0) continue;
                    CustomStructures.setStoneBrickOrNetherrack(world, random, x, posY - 1, z);
                    continue;
                }
                CustomStructures.setStoneBrickOrNetherrack(world, random, x, posY - 1, z);
            }
        }
        for (x = posX - 2; x <= posX + 2; ++x) {
            for (z = posZ - 2; z <= posZ + 2; ++z) {
                if (random.nextInt(3) != 0) continue;
                CustomStructures.setStoneBrickOrNetherrack(world, random, x, posY, z);
            }
        }
        StructureUtil.setLuckyBlock(world, posX, posY, posZ, MathHelper.func_76136_a((Random)random, (int)-100, (int)-50));
    }

    public static void setStoneBrickOrNetherrack(World world, Random random, int posX, int posY, int posZ) {
        if (random.nextInt(3) == 0) {
            StructureUtil.setBlock(world, posX, posY, posZ, Blocks.field_150424_aL);
        } else {
            StructureUtil.setBlock(world, posX, posY, posZ, Blocks.field_150417_aV, random.nextInt(3));
        }
    }

    public static boolean makeSurfaceLuckyBlock(World world, int posX, int posY, int posZ, int minLuck, int maxLuck) {
        int newPosY = StructureUtil.getSurfacePosY(world, posX, posY, posZ);
        if (newPosY == -1) {
            return false;
        }
        if (Lucky.lucky_block.func_149718_j(world, posX, newPosY, posZ)) {
            return StructureUtil.setLuckyBlock(world, posX, newPosY, posZ, MathHelper.func_76136_a((Random)random, (int)minLuck, (int)maxLuck));
        }
        return false;
    }
}

