/*
 * Decompiled with CFR 0.152.
 */
package com.navybofus.littlehelpers.tileentities;

import com.navybofus.littlehelpers.client.NoiseHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;

public class TETreeCutter
extends TileEntity {
    public int direction;
    private int delay;

    public void func_145845_h() {
        if (this.delay <= 0) {
            if (this.needShear()) {
                if (this.hasShears()) {
                    this.doShearing();
                }
            } else if (this.needCut() && this.hasTool()) {
                this.doCutting();
            }
        } else {
            --this.delay;
        }
    }

    private void startDelay(int ticks) {
        this.delay = ticks;
    }

    public int getDirection() {
        return this.direction;
    }

    public void changeDirection() {
        this.direction = this.direction == 3 ? 0 : ++this.direction;
    }

    private boolean needShear() {
        int offsetX = 0;
        int offsetZ = 0;
        if (this.direction == 1) {
            offsetX = this.field_145851_c + 5;
            offsetZ = this.field_145849_e;
        } else if (this.direction == 2) {
            offsetX = this.field_145851_c;
            offsetZ = this.field_145849_e + 5;
        } else if (this.direction == 3) {
            offsetX = this.field_145851_c - 5;
            offsetZ = this.field_145849_e;
        } else {
            offsetX = this.field_145851_c;
            offsetZ = this.field_145849_e - 5;
        }
        for (int i = 30 + this.field_145848_d; i >= this.field_145848_d; --i) {
            for (int j = 4; j > -5; --j) {
                for (int k = -4; k < 5; ++k) {
                    if (this.field_145850_b.func_147439_a(offsetX + k, i, offsetZ + j) != Blocks.field_150362_t && this.field_145850_b.func_147439_a(offsetX + k, i, offsetZ + j) != Blocks.field_150361_u) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void doShearing() {
        int offsetX = 0;
        int offsetZ = 0;
        if (this.direction == 1) {
            offsetX = this.field_145851_c + 5;
            offsetZ = this.field_145849_e;
        } else if (this.direction == 2) {
            offsetX = this.field_145851_c;
            offsetZ = this.field_145849_e + 5;
        } else if (this.direction == 3) {
            offsetX = this.field_145851_c - 5;
            offsetZ = this.field_145849_e;
        } else {
            offsetX = this.field_145851_c;
            offsetZ = this.field_145849_e - 5;
        }
        for (int i = 30 + this.field_145848_d; i >= this.field_145848_d; --i) {
            for (int j = 4; j > -5; --j) {
                for (int k = -4; k < 5; ++k) {
                    int[] loc;
                    if (this.delay > 0 || this.field_145850_b.func_147439_a(offsetX + k, i, offsetZ + j) != Blocks.field_150362_t && this.field_145850_b.func_147439_a(offsetX + k, i, offsetZ + j) != Blocks.field_150361_u) continue;
                    this.damageShears();
                    int ver = 0;
                    ver = this.field_145850_b.func_147439_a(offsetX + k, i, offsetZ + j) == Blocks.field_150362_t ? 1 : 2;
                    int meta = this.field_145850_b.func_72805_g(offsetX + k, i, offsetZ + j);
                    ItemStack sapFromLeaves = this.getSaplingFromLeaves(ver, meta);
                    if (this.field_145850_b.field_73012_v.nextInt(20) == 0 && sapFromLeaves != null) {
                        if (this.findChestWithRoom(sapFromLeaves) != null) {
                            loc = (int[])this.findChestWithRoom(sapFromLeaves).clone();
                            this.placeItemsInChest(loc, sapFromLeaves, 2);
                        } else {
                            this.spawnItems(sapFromLeaves);
                        }
                    }
                    if ((sapFromLeaves == new ItemStack(Blocks.field_150345_g, 1, 0) || sapFromLeaves == new ItemStack(Blocks.field_150345_g, 1, 5)) && this.field_145850_b.field_73012_v.nextInt(200) > 0) {
                        if (this.findChestWithRoom(new ItemStack(Items.field_151034_e)) != null) {
                            loc = (int[])this.findChestWithRoom(new ItemStack(Items.field_151034_e)).clone();
                            this.placeItemsInChest(loc, new ItemStack(Items.field_151034_e), 3);
                        } else {
                            this.spawnItems(new ItemStack(Items.field_151034_e));
                        }
                    }
                    this.field_145850_b.func_147468_f(offsetX + k, i, offsetZ + j);
                    NoiseHelper.makeNoise("grass", this.field_145850_b, this.field_145851_c + k, i, this.field_145849_e + j, 0.5f);
                    this.startDelay(5);
                }
            }
        }
    }

    private ItemStack getSaplingFromLeaves(int version, int metadata) {
        if (version == 1) {
            if (metadata == 0 || metadata == 4 || metadata == 8 || metadata == 12) {
                return new ItemStack(Blocks.field_150345_g, 1, 0);
            }
            if (metadata == 1 || metadata == 5 || metadata == 9 || metadata == 13) {
                return new ItemStack(Blocks.field_150345_g, 1, 1);
            }
            if (metadata == 2 || metadata == 6 || metadata == 10 || metadata == 14) {
                return new ItemStack(Blocks.field_150345_g, 1, 2);
            }
            if (metadata == 3 || metadata == 7 || metadata == 11 || metadata == 15) {
                return new ItemStack(Blocks.field_150345_g, 1, 3);
            }
        } else {
            if (metadata == 0 || metadata == 4 || metadata == 8) {
                return new ItemStack(Blocks.field_150345_g, 1, 4);
            }
            if (metadata == 1 || metadata == 5 || metadata == 9) {
                return new ItemStack(Blocks.field_150345_g, 1, 5);
            }
        }
        return null;
    }

    private boolean needCut() {
        int offsetX = 0;
        int offsetZ = 0;
        if (this.direction == 1) {
            offsetX = this.field_145851_c + 5;
            offsetZ = this.field_145849_e;
        } else if (this.direction == 2) {
            offsetX = this.field_145851_c;
            offsetZ = this.field_145849_e + 5;
        } else if (this.direction == 3) {
            offsetX = this.field_145851_c - 5;
            offsetZ = this.field_145849_e;
        } else {
            offsetX = this.field_145851_c;
            offsetZ = this.field_145849_e - 5;
        }
        for (int i = 30 + this.field_145848_d; i >= this.field_145848_d; --i) {
            for (int j = 4; j > -5; --j) {
                for (int k = -4; k < 5; ++k) {
                    if (this.field_145850_b.func_147439_a(offsetX + k, i, offsetZ + j) != Blocks.field_150364_r && this.field_145850_b.func_147439_a(offsetX + k, i, offsetZ + j) != Blocks.field_150363_s) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void doCutting() {
        int offsetX = 0;
        int offsetZ = 0;
        if (this.direction == 1) {
            offsetX = this.field_145851_c + 5;
            offsetZ = this.field_145849_e;
        } else if (this.direction == 2) {
            offsetX = this.field_145851_c;
            offsetZ = this.field_145849_e + 5;
        } else if (this.direction == 3) {
            offsetX = this.field_145851_c - 5;
            offsetZ = this.field_145849_e;
        } else {
            offsetX = this.field_145851_c;
            offsetZ = this.field_145849_e - 5;
        }
        for (int i = 30 + this.field_145848_d; i >= this.field_145848_d; --i) {
            for (int j = 4; j > -5; --j) {
                for (int k = -4; k < 5; ++k) {
                    if (this.delay > 0 || !(this.field_145850_b.func_147439_a(offsetX + k, i, offsetZ + j) instanceof BlockLog)) continue;
                    this.damageTool();
                    int version = 0;
                    if (this.field_145850_b.func_147439_a(offsetX + k, i, offsetZ + j) == Blocks.field_150363_s) {
                        version = 1;
                    }
                    int meta = this.field_145850_b.func_72805_g(offsetX + k, i, offsetZ + j);
                    ItemStack logType = null;
                    logType = version == 0 ? new ItemStack(Blocks.field_150364_r, 1, meta) : new ItemStack(Blocks.field_150363_s, 1, meta);
                    if (this.findChestWithRoom(logType) != null) {
                        int[] loc = (int[])this.findChestWithRoom(logType).clone();
                        this.placeItemsInChest(loc, logType, version);
                    } else {
                        this.spawnItems(logType);
                    }
                    NoiseHelper.makeNoise("wood", this.field_145850_b, this.field_145851_c + k, i, this.field_145849_e + j, 0.5f);
                    this.field_145850_b.func_147468_f(offsetX + k, i, offsetZ + j);
                    this.startDelay(40);
                }
            }
        }
    }

    private boolean hasShears() {
        for (int i = 1; i > -2; --i) {
            for (int j = -1; j < 2; ++j) {
                if (!(this.field_145850_b.func_147439_a(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i) instanceof BlockChest)) continue;
                TileEntityChest te = (TileEntityChest)this.field_145850_b.func_147438_o(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i);
                int invSize = te.func_70302_i_();
                for (int k = 0; k < invSize; ++k) {
                    if (te.func_70301_a(k) == null || !(te.func_70301_a(k).func_77973_b() instanceof ItemShears)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean damageShears() {
        for (int i = 1; i > -2; --i) {
            for (int j = -1; j < 2; ++j) {
                if (!(this.field_145850_b.func_147439_a(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i) instanceof BlockChest)) continue;
                TileEntityChest te = (TileEntityChest)this.field_145850_b.func_147438_o(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i);
                int invSize = te.func_70302_i_();
                for (int k = 0; k < invSize; ++k) {
                    if (te.func_70301_a(k) == null || !(te.func_70301_a(k).func_77973_b() instanceof ItemShears)) continue;
                    int damage = te.func_70301_a(k).func_77960_j();
                    Item tool = te.func_70301_a(k).func_77973_b();
                    if (++damage >= te.func_70301_a(k).func_77958_k()) {
                        te.func_70299_a(k, null);
                    } else {
                        te.func_70299_a(k, new ItemStack(tool, 1, damage));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasTool() {
        for (int i = 1; i > -2; --i) {
            for (int j = -1; j < 2; ++j) {
                if (!(this.field_145850_b.func_147439_a(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i) instanceof BlockChest)) continue;
                TileEntityChest te = (TileEntityChest)this.field_145850_b.func_147438_o(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i);
                int invSize = te.func_70302_i_();
                for (int k = 0; k < invSize; ++k) {
                    if (te.func_70301_a(k) == null || !(te.func_70301_a(k).func_77973_b() instanceof ItemAxe)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean damageTool() {
        for (int i = 1; i > -2; --i) {
            for (int j = -1; j < 2; ++j) {
                if (!(this.field_145850_b.func_147439_a(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i) instanceof BlockChest)) continue;
                TileEntityChest te = (TileEntityChest)this.field_145850_b.func_147438_o(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i);
                int invSize = te.func_70302_i_();
                for (int k = 0; k < invSize; ++k) {
                    if (te.func_70301_a(k) == null || !(te.func_70301_a(k).func_77973_b() instanceof ItemAxe)) continue;
                    int damage = te.func_70301_a(k).func_77960_j();
                    Item tool = te.func_70301_a(k).func_77973_b();
                    if (++damage >= te.func_70301_a(k).func_77958_k()) {
                        te.func_70299_a(k, null);
                    } else {
                        te.func_70299_a(k, new ItemStack(tool, 1, damage));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private int[] findChestWithRoom(ItemStack stack) {
        int[] firstInv = new int[4];
        for (int i = 1; i > -2; --i) {
            for (int j = -1; j < 2; ++j) {
                int k;
                if (!(this.field_145850_b.func_147439_a(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i) instanceof BlockChest)) continue;
                TileEntityChest te = (TileEntityChest)this.field_145850_b.func_147438_o(this.field_145851_c + j, this.field_145848_d, this.field_145849_e + i);
                int invSize = te.func_70302_i_();
                for (k = 0; k < invSize; ++k) {
                    if (te.func_70301_a(k) == null || !te.func_70301_a(k).func_82833_r().equals(stack.func_82833_r()) || te.func_70301_a((int)k).field_77994_a == te.func_70297_j_()) continue;
                    firstInv[0] = this.field_145851_c + j;
                    firstInv[1] = this.field_145848_d;
                    firstInv[2] = this.field_145849_e + i;
                    firstInv[3] = k;
                    return firstInv;
                }
                for (k = 0; k < invSize; ++k) {
                    if (te.func_70301_a(k) != null) continue;
                    firstInv[0] = this.field_145851_c + j;
                    firstInv[1] = this.field_145848_d;
                    firstInv[2] = this.field_145849_e + i;
                    firstInv[3] = k;
                    return firstInv;
                }
            }
        }
        return null;
    }

    private void placeItemsInChest(int[] loc, ItemStack stack, int logSap) {
        TileEntityChest te = (TileEntityChest)this.field_145850_b.func_147438_o(loc[0], loc[1], loc[2]);
        if (te.func_70301_a(loc[3]) != null) {
            if (te.func_70301_a(loc[3]).func_82833_r().equals(stack.func_82833_r())) {
                int meta = stack.func_77960_j();
                int size = te.func_70301_a((int)loc[3]).field_77994_a;
                ++size;
                if (logSap == 3) {
                    if (size < 64) {
                        te.func_70299_a(loc[3], new ItemStack(Items.field_151034_e, size));
                    }
                } else if (logSap == 2) {
                    if (size < 64) {
                        te.func_70299_a(loc[3], new ItemStack(Blocks.field_150345_g, size, meta));
                    } else {
                        int sizeRemain = size - 64;
                        te.func_70299_a(loc[3], new ItemStack(Blocks.field_150345_g, size, meta));
                        int[] tmpLoc = (int[])this.findChestWithRoom(stack).clone();
                        te = (TileEntityChest)this.field_145850_b.func_147438_o(loc[0], loc[1], loc[2]);
                        this.placeItemsInChest(tmpLoc, new ItemStack(Blocks.field_150345_g, sizeRemain, meta), 2);
                    }
                } else if (logSap == 1) {
                    if (size < 64) {
                        te.func_70299_a(loc[3], new ItemStack(Blocks.field_150363_s, size, meta));
                    } else {
                        int sizeRemain = size - 64;
                        te.func_70299_a(loc[3], new ItemStack(Blocks.field_150363_s, size, meta));
                        int[] tmpLoc = (int[])this.findChestWithRoom(stack).clone();
                        te = (TileEntityChest)this.field_145850_b.func_147438_o(loc[0], loc[1], loc[2]);
                        this.placeItemsInChest(tmpLoc, new ItemStack(Blocks.field_150363_s, sizeRemain, meta), 1);
                    }
                } else if (size < 64) {
                    te.func_70299_a(loc[3], new ItemStack(Blocks.field_150364_r, size, meta));
                } else {
                    int sizeRemain = size - 64;
                    te.func_70299_a(loc[3], new ItemStack(Blocks.field_150364_r, size, meta));
                    int[] tmpLoc = (int[])this.findChestWithRoom(stack).clone();
                    te = (TileEntityChest)this.field_145850_b.func_147438_o(loc[0], loc[1], loc[2]);
                    this.placeItemsInChest(tmpLoc, new ItemStack(Blocks.field_150364_r, sizeRemain, meta), 0);
                }
            }
        } else {
            te.func_70299_a(loc[3], stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnItems(ItemStack stack) {
        Random rand = new Random();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, stack));
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.delay = tag.func_74762_e("delay");
        this.direction = tag.func_74762_e("direction");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("direction", this.direction);
    }
}

