/*
 * Decompiled with CFR 0.152.
 */
package goki.linkedchest.tileentities;

import goki.linkedchest.block.BlockLinkedChest;
import goki.linkedchest.block.ContainerLinkedChest;
import goki.linkedchest.block.LinkedChestBlocks;
import goki.linkedchest.lib.Helper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityLinkedChest
extends TileEntity
implements ISidedInventory {
    public static List<TileEntityLinkedChest> linkedChests = new ArrayList<TileEntityLinkedChest>();
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int dimension = 0;
    private String owner = "";
    private ItemStack[] chestContents = new ItemStack[81];
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    private int ticksSinceSync;
    private String customName = "Linked Chest";
    public int linkedSlots = 9;
    public int chestSlots = 27;

    public int[] func_94128_d(int var1) {
        int[] aSlots = new int[this.chestSlots];
        for (int i = 0; i < this.chestSlots; ++i) {
            aSlots[i] = this.linkedSlots + i;
        }
        return aSlots;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int j) {
        return slot >= this.linkedSlots;
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int j) {
        return slot >= this.linkedSlots;
    }

    public int func_70302_i_() {
        return 36;
    }

    public boolean isStackAffected(ItemStack stack) {
        for (int i = 0; i < 9; ++i) {
            if (this.chestContents[i] == null || !stack.func_77969_a(this.chestContents[i])) continue;
            return true;
        }
        return false;
    }

    public Block func_145838_q() {
        return LinkedChestBlocks.linkedChest;
    }

    public ItemStack func_70301_a(int slot) {
        return this.chestContents[slot];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.chestContents[i] != null) {
            if (this.chestContents[i].field_77994_a <= j) {
                ItemStack itemstack = this.chestContents[i];
                this.chestContents[i] = null;
                return itemstack;
            }
            ItemStack itemstack = this.chestContents[i].func_77979_a(j);
            if (this.chestContents[i].field_77994_a == 0) {
                this.chestContents[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.chestContents[i] != null) {
            ItemStack itemstack = this.chestContents[i];
            this.chestContents[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack par2ItemStack) {
        this.chestContents[slot] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean isInvNameLocalized() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void setOwner(String username) {
        this.owner = username;
    }

    public boolean isOwner(String username) {
        return username.equals(this.owner);
    }

    public void setLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String getOwner() {
        return this.owner;
    }

    public void func_145845_h() {
        float f;
        super.func_145845_h();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numUsingPlayers = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72332_a().func_72299_a((double)((float)this.field_145851_c - f), (double)((float)this.field_145848_d - f), (double)((float)this.field_145849_e - f), (double)((float)(this.field_145851_c + 1) + f), (double)((float)(this.field_145848_d + 1) + f), (double)((float)(this.field_145849_e + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerLinkedChest) || (iinventory = ((ContainerLinkedChest)entityplayer.field_71070_bA).getLowerChestInventory()) != this) continue;
                ++this.numUsingPlayers;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.field_145851_c + 0.5;
            double d0 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d0, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d0 = (double)this.field_145851_c + 0.5;
                double d2 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d0, (double)this.field_145848_d + 0.5, d2, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    public void openChest() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
    }

    public void closeChest() {
        if (this.func_145838_q() != null && this.func_145838_q() instanceof BlockLinkedChest) {
            --this.numUsingPlayers;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public static void addPlayerLinkedChest(EntityPlayer player, int x, int y, int z, int dimension) {
        NBTTagCompound nbt = Helper.getPlayerPersistentNBT(player);
        TileEntityLinkedChest.removeMissingPlayerLinkedChests(player);
        String linkedChestsString = nbt.func_74779_i("linkedChests");
        if (linkedChestsString.equals("")) {
            linkedChestsString = x + "_" + y + "_" + z + "_" + dimension;
            nbt.func_74778_a("linkedChests", linkedChestsString);
        } else {
            String[] linkedChests = nbt.func_74779_i("linkedChests").split(",");
            for (int i = 0; i < linkedChests.length; i += 4) {
                if (linkedChests[i] == "" + x && linkedChests[i + 1] == "" + y && linkedChests[i + 2] == "" + z && linkedChests[i + 3] == "" + dimension) continue;
                linkedChestsString = linkedChestsString + "," + x + "_" + y + "_" + z + "_" + dimension;
                nbt.func_74778_a("linkedChests", linkedChestsString);
            }
        }
    }

    public static void removeMissingPlayerLinkedChests(EntityPlayer player) {
        NBTTagCompound nbt = Helper.getPlayerPersistentNBT(player);
        String linkedChestsString = nbt.func_74779_i("linkedChests");
        if (!linkedChestsString.equals("")) {
            String[] linkedChests = nbt.func_74779_i("linkedChests").split(",");
            linkedChestsString = "";
            for (int i = 0; i < linkedChests.length; ++i) {
                String[] coordinates = linkedChests[i].split("_");
                try {
                    int x = Integer.parseInt(coordinates[0]);
                    int y = Integer.parseInt(coordinates[1]);
                    int z = Integer.parseInt(coordinates[2]);
                    int d = Integer.parseInt(coordinates[3]);
                    TileEntityLinkedChest te = (TileEntityLinkedChest)MinecraftServer.func_71276_C().field_71305_c[d].func_147438_o(x, y, z);
                    if (te == null) continue;
                    linkedChestsString = linkedChestsString + "," + x + "_" + y + "_" + z + "_" + d;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (linkedChestsString.length() > 0) {
                linkedChestsString.substring(1);
            }
        }
        nbt.func_74778_a("linkedChests", linkedChestsString);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 8);
        this.chestContents = new ItemStack[this.func_70302_i_()];
        if (nbt.func_74764_b("CustomName")) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.chestContents.length) continue;
            this.chestContents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.owner = nbt.func_74779_i("Owner");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.chestContents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.isInvNameLocalized()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        nbt.func_74778_a("Owner", this.owner);
    }

    public static List<TileEntityLinkedChest> getPlayerLinkedChests(EntityPlayer player) {
        ArrayList<TileEntityLinkedChest> linkedChests = new ArrayList<TileEntityLinkedChest>();
        NBTTagCompound nbt = Helper.getPlayerPersistentNBT(player);
        String linkedChestsString = nbt.func_74779_i("linkedChests");
        if (!linkedChestsString.equals("")) {
            String[] tempLinkedChests = nbt.func_74779_i("linkedChests").split(",");
            for (int i = 0; i < tempLinkedChests.length; ++i) {
                String[] coordinates = tempLinkedChests[i].split("_");
                try {
                    int x = Integer.parseInt(coordinates[0]);
                    int y = Integer.parseInt(coordinates[1]);
                    int z = Integer.parseInt(coordinates[2]);
                    int d = Integer.parseInt(coordinates[3]);
                    TileEntityLinkedChest te = (TileEntityLinkedChest)MinecraftServer.func_71276_C().field_71305_c[d].func_147438_o(x, y, z);
                    if (te == null) continue;
                    linkedChests.add(te);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return linkedChests;
    }

    public void func_70305_f() {
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }
}

