/*
 * Decompiled with CFR 0.152.
 */
package se.luppii.ladders.updater;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatMessageComponent;
import se.luppii.ladders.LLadders;
import se.luppii.ladders.updater.UpdateChecker;

public class UpdateManager
implements IScheduledTickHandler {
    private boolean _notificationDisplayed;
    private UpdateChecker _updateChecker = new UpdateChecker();

    public UpdateManager() {
        if (LLadders.checkForUpdates) {
            this._updateChecker.start();
        }
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        if (!this._notificationDisplayed && this._updateChecker.checkComplete()) {
            this._notificationDisplayed = true;
            if (this._updateChecker.isNewVersionAvailable()) {
                EntityPlayer player = (EntityPlayer)tickData[0];
                player.func_70006_a(new ChatMessageComponent().func_111079_a("[Luppii's Ladders] New version is available: " + this._updateChecker.newVersion().toString()));
                player.func_70006_a(new ChatMessageComponent().func_111079_a("[Luppii's Ladders] " + this._updateChecker.newVersion().toString() + ": " + this._updateChecker.newVersion().description()));
            }
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        if (this._notificationDisplayed) {
            return EnumSet.noneOf(TickType.class);
        }
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "LLadders.version";
    }

    public int nextTickSpacing() {
        if (!this._notificationDisplayed) {
            return 400;
        }
        return 72000;
    }
}

