/*
 * Decompiled with CFR 0.152.
 */
package se.luppii.ladders.updater;

import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import se.luppii.ladders.updater.ModVersion;

public class UpdateChecker
extends Thread {
    private String _versionUrl = "https://raw.github.com/Luppii/LLadders/master/VERSION";
    private ModVersion _newVersion;
    private boolean _checkComplete;
    private boolean _newVersionAvailable;

    @Override
    public void run() {
        try {
            URL versionFile = new URL(this._versionUrl);
            BufferedReader reader = new BufferedReader(new InputStreamReader(versionFile.openStream()));
            ModVersion newVersion = ModVersion.parse(reader.readLine());
            ModVersion thisVersion = ModVersion.parse("0.1.0");
            reader.close();
            this._newVersion = newVersion;
            boolean bl = this._newVersionAvailable = thisVersion.compareTo(newVersion) < 0;
            if (this._newVersionAvailable) {
                FMLLog.info((String)("[Luppii's Ladders] A new version of Luppii's Ladders is available: " + newVersion.toString() + "."), (Object[])new Object[0]);
            }
            this._checkComplete = true;
        }
        catch (Exception err) {
            FMLLog.warning((String)("[Luppii's Ladders] Update check failed: " + err.getMessage()), (Object[])new Object[0]);
            err.printStackTrace();
        }
    }

    public boolean checkComplete() {
        return this._checkComplete;
    }

    public boolean isNewVersionAvailable() {
        return this._newVersionAvailable;
    }

    public ModVersion newVersion() {
        return this._newVersion;
    }
}

