/*
 * Decompiled with CFR 0.152.
 */
package se.luppii.ladders.block;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import se.luppii.ladders.LLadders;
import se.luppii.ladders.tile.TileEntityLadderDispenser;

public class BlockLadderDispenser
extends BlockContainer {
    private static String[] names = new String[]{"bottom_2", "bottom_3", "bottom_4", "bottom_5", "side", "front"};
    private Icon[] icons;

    public BlockLadderDispenser(int par1) {
        super(par1, Material.field_76245_d);
        this.func_71848_c(2.0f);
        this.func_71894_b(5.0f);
        this.func_71884_a(field_71967_e);
        this.func_71864_b("lladders.block.ladderdispenser");
        this.icons = new Icon[names.length];
        this.func_71849_a(CreativeTabs.field_78028_d);
    }

    public int func_71899_b(int par1) {
        return par1;
    }

    public int getLightValue(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int meta = par1IBlockAccess.func_72805_g(par2, par3, par4);
        return 0;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 1; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = par1IconRegister.func_94245_a("lladders:" + this.func_71917_a() + "_" + names[i]);
        }
    }

    public Icon func_71895_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        TileEntity te = par1IBlockAccess.func_72796_p(par2, par3, par4);
        int meta = par1IBlockAccess.func_72805_g(par2, par3, par4);
        if (te instanceof TileEntityLadderDispenser) {
            par5 = ((TileEntityLadderDispenser)te).getRotatedSide(par5);
            int ordinal = ((TileEntityLadderDispenser)te).getFacingDirection().ordinal();
            return this.getIcon(par5, meta, ordinal);
        }
        return this.func_71858_a(par5, meta);
    }

    public boolean func_71903_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        TileEntityLadderDispenser te = (TileEntityLadderDispenser)par1World.func_72796_p(par2, par3, par4);
        par5EntityPlayer.openGui((Object)LLadders.instance, 0, par1World, par2, par3, par4);
        return true;
    }

    public void func_71861_g(World par1World, int par2, int par3, int par4) {
        par1World.func_72836_a(par2, par3, par4, this.field_71990_ca, 10);
    }

    public void func_71860_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        if (par5EntityLivingBase == null) {
            return;
        }
        TileEntity te = par1World.func_72796_p(par2, par3, par4);
        if (par6ItemStack.func_77978_p() != null) {
            par6ItemStack.func_77978_p().func_74768_a("x", par2);
            par6ItemStack.func_77978_p().func_74768_a("y", par3);
            par6ItemStack.func_77978_p().func_74768_a("z", par4);
            te.func_70307_a(par6ItemStack.func_77978_p());
        }
        if (te instanceof TileEntityLadderDispenser) {
            int direction = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (direction) {
                case 0: {
                    ((TileEntityLadderDispenser)te).setFacingDirection(5);
                    break;
                }
                case 1: {
                    ((TileEntityLadderDispenser)te).setFacingDirection(3);
                    break;
                }
                case 2: {
                    ((TileEntityLadderDispenser)te).setFacingDirection(4);
                    break;
                }
                case 3: {
                    ((TileEntityLadderDispenser)te).setFacingDirection(2);
                }
            }
        }
    }

    public void func_71863_a(World par1World, int par2, int par3, int par4, int par5) {
        par1World.func_72836_a(par2, par3, par4, this.field_71990_ca, 10);
    }

    public TileEntity getBlockEntity(int par1) {
        switch (par1) {
            case 0: {
                return new TileEntityLadderDispenser();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        switch (par2) {
            case 0: {
                if (par1 > 0) {
                    if ((par1 += 3) == 7) {
                        par1 = 5;
                    } else if (par1 > 4) {
                        par1 = 4;
                    }
                }
                return this.icons[par1];
            }
        }
        FMLLog.warning((String)("[Luppii's Ladders] Invalid metadata for " + this.func_71917_a() + ". Metadata received was " + par2 + "."), (Object[])new Object[0]);
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int par1, int par2, int par3) {
        switch (par2) {
            case 0: {
                if (par3 > 1) {
                    if (par1 == 0) {
                        par1 = par3 - 2;
                    } else if ((par1 += 3) == 7) {
                        par1 = 5;
                    } else if (par1 > 4) {
                        par1 = 4;
                    }
                    return this.icons[par1];
                }
                return this.func_71858_a(par1, par2);
            }
        }
        FMLLog.warning((String)("[Luppii's Ladders] Invalid metadata for " + this.func_71917_a() + ". Metadata received was " + par2 + "."), (Object[])new Object[0]);
        return this.icons[0];
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        TileEntity te = par1World.func_72796_p(par2, par3, par4);
        this.dropItems(te);
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
    }

    private void dropItems(TileEntity te) {
        if (te instanceof IInventory) {
            World world = te.field_70331_k;
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack == null) continue;
                while (itemstack.field_77994_a > 0) {
                    int j = world.field_73012_v.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    float xOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float yOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float zOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    EntityItem ei = new EntityItem(world, (double)((float)te.field_70329_l + xOffset), (double)((float)te.field_70330_m + yOffset), (double)((float)te.field_70327_n + zOffset), new ItemStack(itemstack.field_77993_c, j, itemstack.func_77960_j()));
                    float factor = 0.05f;
                    ei.field_70159_w = (float)world.field_73012_v.nextGaussian() * factor;
                    ei.field_70181_x = (float)world.field_73012_v.nextGaussian() * factor + 0.2f;
                    ei.field_70179_y = (float)world.field_73012_v.nextGaussian() * factor;
                    if (itemstack.func_77942_o()) {
                        ei.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)ei);
                }
            }
        }
    }

    public void func_71847_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        super.func_71847_b(par1World, par2, par3, par4, par5Random);
        this.operate(par1World, par2, par3, par4);
    }

    private void operate(World world, int x, int y, int z) {
        boolean done = false;
        TileEntityLadderDispenser te = (TileEntityLadderDispenser)world.func_72796_p(x, y, z);
        int direction = this.getForgeDirectionToInt(te.getFacingDirection());
        if (world.func_72864_z(x, y, z)) {
            te.setActiveState(true);
            te.setMode(1);
        }
        if (!te.getActiveState()) {
            return;
        }
        if (te.getMode() == 1) {
            if (this.canSetLadder(world, x, y - 1, z, direction)) {
                ItemStack stack = this.extractLadderFromDispenser(te);
                if (stack != null) {
                    if (this.setLadder(world, stack, x, y - 1, z, direction)) {
                        done = true;
                    } else {
                        te.setMode(2);
                        done = true;
                    }
                } else {
                    te.setMode(2);
                    done = true;
                }
            } else {
                te.setMode(2);
                done = true;
            }
        } else if (te.getMode() == 2) {
            if (this.canRemoveLadder(world, x, y - 1, z, direction)) {
                this.removeLadder(world, te, x, y - 1, z, direction);
                done = true;
            } else {
                te.setMode(0);
            }
        } else {
            te.setActiveState(false);
        }
        if (done) {
            world.func_72836_a(x, y, z, this.field_71990_ca, te.getMode() == 1 ? 6 : 10);
        }
    }

    private boolean canRemoveLadder(World world, int x, int y, int z, int meta) {
        return world.func_72798_a(x, y, z) == LLadders.blockRopeLadder.field_71990_ca;
    }

    private boolean canSetLadder(World world, int x, int y, int z, int meta) {
        if (world.func_72798_a(x, y, z) == LLadders.blockRopeLadder.field_71990_ca) {
            return this.canSetLadder(world, x, y - 1, z, meta);
        }
        return world.func_72799_c(x, y, z);
    }

    private int getForgeDirectionToInt(ForgeDirection dir) {
        ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
        for (int i = 0; i < directions.length; ++i) {
            if (directions[i] != dir) continue;
            switch (i) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 0;
                }
            }
        }
        return 0;
    }

    private boolean insertLadderToDispenser(TileEntityLadderDispenser te, ItemStack itemstack) {
        for (int i = 0; i < te.func_70302_i_(); ++i) {
            if (te.func_70301_a(i) == null) {
                te.func_70299_a(i, itemstack);
                return true;
            }
            if (!te.func_94041_b(i, itemstack) || te.func_70301_a((int)i).field_77994_a >= te.func_70297_j_()) continue;
            ItemStack stack = new ItemStack(itemstack.field_77993_c, te.func_70301_a((int)i).field_77994_a + 1, itemstack.func_77960_j());
            te.func_70299_a(i, stack);
            return true;
        }
        return false;
    }

    private ItemStack extractLadderFromDispenser(TileEntityLadderDispenser te) {
        for (int i = te.func_70302_i_() - 1; i >= 0; --i) {
            if (te.func_70301_a(i) == null || te.func_70301_a((int)i).field_77993_c != LLadders.blockRopeLadder.field_71990_ca) continue;
            return te.func_70298_a(i, 1);
        }
        return null;
    }

    private void removeLadder(World world, TileEntityLadderDispenser te, int x, int y, int z, int meta) {
        int id = world.func_72798_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (id != LLadders.blockRopeLadder.field_71990_ca) {
            return;
        }
        if (world.func_72798_a(x, y - 1, z) == LLadders.blockRopeLadder.field_71990_ca) {
            this.removeLadder(world, te, x, y - 1, z, meta);
        } else {
            world.func_94571_i(x, y, z);
            world.func_72932_q(x, y, z);
            ItemStack itemstack = new ItemStack(id, 1, metadata & 0xC);
            if (!this.insertLadderToDispenser(te, itemstack)) {
                this.func_71929_a(world, x, y, z, itemstack);
            }
        }
    }

    private boolean setLadder(World world, ItemStack stack, int x, int y, int z, int meta) {
        int id = world.func_72798_a(x, y, z);
        if (world.func_72799_c(x, y, z) && stack != null) {
            world.func_72832_d(x, y, z, stack.field_77993_c, meta, 2);
            return true;
        }
        if (id == LLadders.blockRopeLadder.field_71990_ca) {
            return this.setLadder(world, stack, x, y - 1, z, meta);
        }
        return false;
    }

    private boolean isIndirectlyPowered(World par1World, int par2, int par3, int par4, int par5) {
        return par5 != 0 && par1World.func_94574_k(par2, par3 - 1, par4, 0) ? true : (par5 != 1 && par1World.func_94574_k(par2, par3 + 1, par4, 1) ? true : (par5 != 2 && par1World.func_94574_k(par2, par3, par4 - 1, 2) ? true : (par5 != 3 && par1World.func_94574_k(par2, par3, par4 + 1, 3) ? true : (par5 != 5 && par1World.func_94574_k(par2 + 1, par3, par4, 5) ? true : (par5 != 4 && par1World.func_94574_k(par2 - 1, par3, par4, 4) ? true : (par1World.func_94574_k(par2, par3, par4, 0) ? true : (par1World.func_94574_k(par2, par3 + 2, par4, 1) ? true : (par1World.func_94574_k(par2, par3 + 1, par4 - 1, 2) ? true : (par1World.func_94574_k(par2, par3 + 1, par4 + 1, 3) ? true : (par1World.func_94574_k(par2 - 1, par3 + 1, par4, 4) ? true : par1World.func_94574_k(par2 + 1, par3 + 1, par4, 5)))))))))));
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        try {
            TileEntityLadderDispenser te = (TileEntityLadderDispenser)((Object)TileEntityLadderDispenser.class.newInstance());
            return te;
        }
        catch (IllegalAccessException ex) {
            FMLLog.severe((String)"Luppii's Ladders", (Object[])new Object[]{"Unable to create TileEntity instance from Transmorpher."});
            return null;
        }
        catch (InstantiationException ex) {
            FMLLog.severe((String)"Luppii's Ladders", (Object[])new Object[]{"Unable to create TileEntity instance from Transmorpher."});
            return null;
        }
    }
}

