/*
 * Decompiled with CFR 0.152.
 */
package keyandcodelock;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import keyandcodelock.BlockDoorLockedKey;
import keyandcodelock.BlockRedstoneLockKey;
import keyandcodelock.GuiCodeLock;
import keyandcodelock.GuiNameKey;
import keyandcodelock.KeyAndCodeLock;
import keyandcodelock.TileEntityCodeLocked;
import keyandcodelock.TileEntityKeyLocked;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;

public class KeyAndCodeLockPacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        if (packet.field_73630_a.equals("CodeLockChange")) {
            this.handleCodeChange(packet, player);
        } else if (packet.field_73630_a.equals("DoorOpen")) {
            this.handleDoorOpen(packet, player);
        } else if (packet.field_73630_a.equals("KeyNameChange")) {
            this.handleKeyNameChange(packet, player);
        } else if (packet.field_73630_a.equals("CodeCheck")) {
            this.handleCodeCheck(packet, player);
        } else if (packet.field_73630_a.equals("CodeCheckAnswer")) {
            this.handleCodeCheckAnswer(packet, player);
        } else if (packet.field_73630_a.equals("KeyNameAnswer")) {
            this.handleKeyNameAnswer(packet, player);
        }
    }

    private void handleCodeCheck(Packet250CustomPayload packet, Player player2) {
        int z;
        int y;
        int x;
        boolean open;
        int code;
        KeyAndCodeLock.log("Recieved CodeCheckPacket!");
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            code = inputStream.readInt();
            open = inputStream.readBoolean();
            x = inputStream.readInt();
            y = inputStream.readInt();
            z = inputStream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            KeyAndCodeLock.logger.warning("Recieved a misstructured CodeCheckPacket!");
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)player2;
        TileEntity t = player.field_70170_p.func_72796_p(x, y, z);
        if (t != null && t instanceof TileEntityCodeLocked) {
            TileEntityCodeLocked tile = (TileEntityCodeLocked)t;
            if (tile.code == code) {
                this.sendCodeCheckAnswer(x, y, z, true, player2);
                if (open) {
                    if (player.field_70170_p.func_72798_a(x, y, z) == KeyAndCodeLock.codelockeddoorID) {
                        ((BlockDoorLockedKey)KeyAndCodeLock.keylockeddoor).flipDoor(player.field_70170_p, x, y, z, (EntityPlayer)player);
                    } else if (player.field_70170_p.func_72798_a(x, y, z) == KeyAndCodeLock.coderedstonelockID) {
                        ((BlockRedstoneLockKey)KeyAndCodeLock.keyredstonelock).changePowerState(player.field_70170_p, x, y, z);
                    }
                }
                PacketDispatcher.sendPacketToPlayer((Packet)tile.func_70319_e(), (Player)player2);
                KeyAndCodeLock.log("Code accepted!");
            } else {
                this.sendCodeCheckAnswer(x, y, z, false, player2);
                KeyAndCodeLock.log("Code denied!");
            }
        }
    }

    private void sendCodeCheckAnswer(int x, int y, int z, boolean answer, Player player) {
        KeyAndCodeLock.log("Sending CodeCheckAnswer...");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeBoolean(answer);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "CodeCheckAnswer";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)player);
        KeyAndCodeLock.log("CodeCheckAnswer sent!");
    }

    private void sendKeyNameAnswer(int x, int y, int z, String name, int hash, boolean answer, Player player) {
        KeyAndCodeLock.log("Sending KeyNameAnswer...");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeBoolean(answer);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
            outputStream.writeInt(hash);
            outputStream.writeUTF(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "KeyNameAnswer";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)player);
        KeyAndCodeLock.log("KeyNameAnswer sent!");
    }

    private void handleCodeCheckAnswer(Packet250CustomPayload packet, Player player2) {
        int z;
        int y;
        int x;
        boolean answer;
        KeyAndCodeLock.log("Recieved CodeCheckAnswer!");
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            answer = inputStream.readBoolean();
            x = inputStream.readInt();
            y = inputStream.readInt();
            z = inputStream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            KeyAndCodeLock.logger.warning("Recieved a misstructured CodeCheckAnswer packet!");
            return;
        }
        EntityClientPlayerMP player = (EntityClientPlayerMP)player2;
        TileEntity t = player.field_70170_p.func_72796_p(x, y, z);
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui != null && gui instanceof GuiCodeLock) {
            GuiCodeLock guicode = (GuiCodeLock)gui;
            guicode.handleCodeCheckAnswer(answer);
        } else {
            KeyAndCodeLock.log("no gui?!");
        }
        if (answer) {
            KeyAndCodeLock.log("Code was accepted by the Server!");
        } else {
            KeyAndCodeLock.log("Code was denied by the Server!");
        }
    }

    private void handleKeyNameAnswer(Packet250CustomPayload packet, Player player2) {
        String name;
        int hash;
        int z;
        int y;
        int x;
        boolean answer;
        KeyAndCodeLock.log("Recieved KeyNameAnswer!");
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            answer = inputStream.readBoolean();
            x = inputStream.readInt();
            y = inputStream.readInt();
            z = inputStream.readInt();
            hash = inputStream.readInt();
            name = inputStream.readUTF();
        }
        catch (IOException e) {
            e.printStackTrace();
            KeyAndCodeLock.logger.warning("Recieved a misstructured KeyNameAnswer packet!");
            return;
        }
        if (name == null || name.length() == 0 || hash <= 0) {
            KeyAndCodeLock.logger.warning("Recieved KeyNameAnswer with wrong data!");
            return;
        }
        EntityClientPlayerMP player = (EntityClientPlayerMP)player2;
        TileEntity t = player.field_70170_p.func_72796_p(x, y, z);
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui != null && gui instanceof GuiNameKey) {
            GuiNameKey guikey = (GuiNameKey)gui;
            guikey.onPacketAnswer(name, hash, answer);
        } else {
            KeyAndCodeLock.log("no gui?!");
        }
        if (answer) {
            KeyAndCodeLock.log("KeyNameChange was accepted by the Server!");
        } else {
            KeyAndCodeLock.log("KeyNameChange was denied by the Server!");
        }
    }

    private void handleKeyNameChange(Packet250CustomPayload packet, Player player) {
        try {
            TileEntity tile;
            String name;
            int hash;
            int z;
            int y;
            int x;
            KeyAndCodeLock.log("KeyNameChange Packet recieved!");
            DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
            try {
                x = datainputstream.readInt();
                y = datainputstream.readInt();
                z = datainputstream.readInt();
                hash = datainputstream.readInt();
                name = datainputstream.readUTF();
            }
            catch (Exception e) {
                e.printStackTrace();
                KeyAndCodeLock.logger.warning("Recieved a misstructured KeyNameChange Packet!");
                return;
            }
            if (name == null || name.length() == 0 || hash <= 0) {
                KeyAndCodeLock.logger.warning("Recieved KeyNameChange with wrong data!");
                this.sendKeyNameAnswer(x, y, z, name, hash, false, player);
                return;
            }
            ItemStack itemstack = ((EntityPlayerMP)player).field_71071_by.func_70448_g();
            if (itemstack != null && itemstack.field_77993_c == KeyAndCodeLock.key.field_77779_bT) {
                tile = ((EntityPlayerMP)player).field_70170_p.func_72796_p(x, y, z);
                if (tile == null || !(tile instanceof TileEntityKeyLocked)) {
                    throw new Exception("Not a keylockeddoor");
                }
                if (((TileEntityKeyLocked)tile).name != null || ((TileEntityKeyLocked)tile).hash > 0) {
                    this.sendKeyNameAnswer(x, y, z, name, hash, false, player);
                    PacketDispatcher.sendPacketToPlayer((Packet)tile.func_70319_e(), (Player)player);
                    KeyAndCodeLock.logger.warning("Client tried setting a key to an already set door...");
                }
                if (itemstack.field_77990_d == null) {
                    itemstack.func_77982_d(new NBTTagCompound());
                }
                itemstack.field_77990_d.func_74768_a("hash", hash);
                itemstack.field_77990_d.func_74778_a("name", name);
                ((TileEntityKeyLocked)tile).name = name;
                ((TileEntityKeyLocked)tile).hash = hash;
                EntityPlayerMP player2 = (EntityPlayerMP)player;
                if (player2.field_70170_p.func_72798_a(x, y, z) == KeyAndCodeLock.codelockeddoorID) {
                    ((BlockDoorLockedKey)KeyAndCodeLock.keylockeddoor).flipDoor(player2.field_70170_p, x, y, z, (EntityPlayer)player2);
                } else if (player2.field_70170_p.func_72798_a(x, y, z) == KeyAndCodeLock.coderedstonelockID) {
                    ((BlockRedstoneLockKey)KeyAndCodeLock.keyredstonelock).changePowerState(player2.field_70170_p, x, y, z);
                }
            } else {
                KeyAndCodeLock.logger.warning("Recieved KeyNameChange but Player has no key?!");
                this.sendKeyNameAnswer(x, y, z, name, hash, false, player);
                return;
            }
            this.sendKeyNameAnswer(x, y, z, name, hash, true, player);
            PacketDispatcher.sendPacketToPlayer((Packet)tile.func_70319_e(), (Player)player);
            KeyAndCodeLock.log("KeyName updated! name=" + name);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void handleDoorOpen(Packet250CustomPayload packet, Player player2) {
        int z;
        int y;
        int x;
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            x = inputStream.readInt();
            y = inputStream.readInt();
            z = inputStream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            KeyAndCodeLock.logger.warning("Recieved a misstructured DoorOpenPacket!");
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)player2;
        if (player.field_70170_p.func_72798_a(x, y, z) == KeyAndCodeLock.codelockeddoorID) {
            ((BlockDoorLockedKey)KeyAndCodeLock.keylockeddoor).flipDoor(player.field_70170_p, x, y, z, (EntityPlayer)player);
        } else if (player.field_70170_p.func_72798_a(x, y, z) == KeyAndCodeLock.coderedstonelockID) {
            ((BlockRedstoneLockKey)KeyAndCodeLock.keyredstonelock).changePowerState(player.field_70170_p, x, y, z);
        }
    }

    private void handleCodeChange(Packet250CustomPayload packet, Player player2) {
        int z;
        int y;
        int x;
        int newcode;
        int oldcode;
        KeyAndCodeLock.log("Recieved CodeChangePacket!");
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            oldcode = inputStream.readInt();
            newcode = inputStream.readInt();
            x = inputStream.readInt();
            y = inputStream.readInt();
            z = inputStream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            KeyAndCodeLock.logger.warning("Recieved a misstructured CodeChangePacket!");
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)player2;
        TileEntity t = player.field_70170_p.func_72796_p(x, y, z);
        if (t != null && t instanceof TileEntityCodeLocked) {
            TileEntityCodeLocked tile = (TileEntityCodeLocked)t;
            if (tile.code != oldcode && tile.code >= 0) {
                KeyAndCodeLock.log("No Change! old code was wrong!");
                return;
            }
            tile.code = newcode;
            if (player.field_70170_p.func_72798_a(x, y, z) == KeyAndCodeLock.codelockeddoorID) {
                ((BlockDoorLockedKey)KeyAndCodeLock.keylockeddoor).flipDoor(player.field_70170_p, x, y, z, (EntityPlayer)player);
            } else if (player.field_70170_p.func_72798_a(x, y, z) == KeyAndCodeLock.coderedstonelockID) {
                ((BlockRedstoneLockKey)KeyAndCodeLock.keyredstonelock).changePowerState(player.field_70170_p, x, y, z);
            }
            KeyAndCodeLock.log("CodeChange accepted!");
        }
    }
}

