/*
 * Decompiled with CFR 0.152.
 */
package to.uk.ilexiconn.jurassicraft.data.entity.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import to.uk.ilexiconn.jurassicraft.JurassiCraft;
import to.uk.ilexiconn.jurassicraft.Util;
import to.uk.ilexiconn.jurassicraft.data.entity.Dinosaur;

public class EntityDinoEgg
extends Entity
implements IEntityAdditionalSpawnData {
    public String dino;
    public int spawnTime;
    public int currentSpawnTime;
    public boolean froze;
    public boolean dried;
    public int rockAmount;

    public EntityDinoEgg(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityDinoEgg(World world, String dino, int spawnTime) {
        this(world);
        this.dino = dino;
        this.spawnTime = spawnTime;
    }

    public EntityDinoEgg(World world, String dino, int spawnTime, double x, double y, double z) {
        this(world, dino, spawnTime);
        this.func_70107_b(x + 0.5, y, z + 0.5);
    }

    public boolean func_70097_a(DamageSource damage, float amount) {
        if (!this.func_85032_ar()) {
            if (this.field_70170_p.field_72995_K && amount > 0.0f) {
                Minecraft mc = Minecraft.func_71410_x();
                Random random = new Random();
                for (int currentParticle = 0; currentParticle < 50; ++currentParticle) {
                    float f3 = MathHelper.func_151240_a((Random)random, (float)0.0f, (float)((float)Math.PI * 2));
                    double d5 = MathHelper.func_151240_a((Random)random, (float)0.75f, (float)1.0f);
                    double velY = 0.21000000298023225;
                    double velX = (double)(MathHelper.func_76134_b((float)f3) * 0.2f) * d5 * d5 * 1.2;
                    double velZ = (double)(MathHelper.func_76126_a((float)f3) * 0.2f) * d5 * d5 * 1.2;
                    mc.field_71441_e.func_72869_a("blockdust_" + Block.func_149682_b((Block)Blocks.field_150322_A) + "_0", (double)((float)this.field_70165_t), (double)((float)this.field_70163_u), (double)((float)this.field_70161_v), velX, velY, velZ);
                }
            }
            this.func_70106_y();
        }
        return super.func_70097_a(damage, amount);
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.froze = this.field_70180_af.func_75679_c(25) != 0;
            this.dried = this.field_70180_af.func_75679_c(26) != 0;
            this.currentSpawnTime = this.field_70180_af.func_75679_c(27);
        }
        if (!this.field_70122_E) {
            this.field_70181_x -= (double)0.05f;
        }
        if (this.field_70181_x < (double)-0.8f) {
            this.field_70181_x = -0.8f;
        }
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
        }
        if (!this.field_70170_p.field_72995_K) {
            int amountToIncrease = 0;
            boolean warm = this.field_70170_p.func_72957_l((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) > 6;
            boolean overheat = this.field_70170_p.func_72957_l((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) > 10;
            Dinosaur dinosaur = Util.getDinoByID(Util.getDinoIDByName(this.dino));
            if (dinosaur.isWaterCreature) {
                if (!this.func_70026_G()) {
                    amountToIncrease = overheat ? -2 : -1;
                }
            } else {
                amountToIncrease = warm && !this.func_70026_G() ? 1 : (!warm && this.func_70026_G() ? -2 : -1);
            }
            this.currentSpawnTime += amountToIncrease;
            if (this.currentSpawnTime < -500) {
                if (dinosaur.isWaterCreature) {
                    this.dried = true;
                } else {
                    this.froze = true;
                }
            }
            if (this.currentSpawnTime >= this.spawnTime) {
                Class<?> dinoToSpawnClass = Util.getDinoClass(this.dino);
                try {
                    Entity dinoToSpawn = (Entity)dinoToSpawnClass.getConstructor(World.class).newInstance(this.field_70170_p);
                    dinoToSpawn.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d(dinoToSpawn);
                    this.func_70097_a(DamageSource.field_76377_j, 0.0f);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.currentSpawnTime < this.spawnTime - 100 && !this.dried && !this.froze) {
            if (this.field_70125_A >= 5.0f) {
                this.rockAmount = -1;
            } else if (this.field_70125_A <= -5.0f) {
                this.rockAmount = 1;
            }
            this.field_70125_A += (float)this.rockAmount / 2.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(25, (Object)(this.froze ? 1 : 0));
            this.field_70180_af.func_75692_b(26, (Object)(this.dried ? 1 : 0));
            this.field_70180_af.func_75692_b(27, (Object)this.currentSpawnTime);
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void func_70069_a(float fallDistance) {
        super.func_70069_a(fallDistance);
        if (fallDistance > 10.0f && this.field_70122_E) {
            this.func_70097_a(DamageSource.field_76379_h, 1.0f);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)this.rockAmount);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.spawnTime = nbt.func_74762_e("SpawnTime");
        this.currentSpawnTime = nbt.func_74762_e("CurrentSpawnTime");
        this.dino = nbt.func_74779_i("Dino");
        this.froze = nbt.func_74767_n("Froze");
        this.dried = nbt.func_74767_n("Dried");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("SpawnTime", this.spawnTime);
        nbt.func_74768_a("CurrentSpawnTime", this.currentSpawnTime);
        nbt.func_74778_a("Dino", this.dino);
        nbt.func_74757_a("Froze", this.froze);
        nbt.func_74757_a("Dried", this.dried);
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation(JurassiCraft.getModId() + "textures\\eggs\\egg" + this.dino + ".png");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(Util.getDinoIDByName(this.dino));
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.dino = Util.getDinoByID((int)additionalData.readInt()).dinoName;
    }
}

