/*
 * Decompiled with CFR 0.152.
 */
package to.uk.ilexiconn.jurassicraft.data.entity;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import to.uk.ilexiconn.jurassicraft.Util;
import to.uk.ilexiconn.jurassicraft.data.entity.Dinosaur;

public class JsonEntityParser
extends Util {
    private Collection<Dinosaur> dinos;
    private boolean configLoaded;

    public void parseServerEntities() {
        this.loadConfig(this.getConfigFile());
        this.configLoaded = true;
        for (Dinosaur dino : this.dinos) {
            this.addMeat(dino.dinoName);
            this.addDNA(dino.dinoName);
            this.addEntity(dino);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void parseClientEntities() {
        while (!this.configLoaded) {
        }
        for (Dinosaur dino : this.dinos) {
            this.addEntityRenderer(dino);
        }
    }

    private void loadConfig(File config) {
        try {
            Type collectionType = new TypeToken<Collection<Dinosaur>>(){}.getType();
            this.dinos = (Collection)new Gson().fromJson((Reader)new FileReader(config), collectionType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getConfigFile() {
        try {
            File tempFile = File.createTempFile("dinos", ".json");
            tempFile.deleteOnExit();
            InputStream in = JsonEntityParser.class.getResourceAsStream("dinos.json");
            FileOutputStream out = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            return tempFile;
        }
        catch (Exception e) {
            return null;
        }
    }
}

