/*
 * Decompiled with CFR 0.152.
 */
package to.uk.ilexiconn.jurassicraft.data.tile;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import to.uk.ilexiconn.jurassicraft.Util;
import to.uk.ilexiconn.jurassicraft.data.block.BlockAnalyzer;
import to.uk.ilexiconn.jurassicraft.data.item.ItemDNA;

public class TileAnalyzer
extends TileEntity
implements ISidedInventory {
    private static final int[] slots_top = new int[0];
    private static final int[] slots_bottom = new int[]{10, 11, 12};
    private static final int[] slots_sides = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static ArrayList<ItemDNA> dnas = new ArrayList();
    public int analyzerBurnTime = 0;
    public int currentItemBurnTime = 100;
    public int analyzerCookTime = 0;
    private ItemStack[] analyzerItemStacks = new ItemStack[13];
    private int RawIndex = -1;
    private int SpaceIndex = -1;

    public TileAnalyzer() {
        dnas = Util.getDNAArray();
    }

    private static int getItemBurnTime() {
        return 100;
    }

    public static boolean isItemFuel() {
        return TileAnalyzer.getItemBurnTime() > 0;
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slots_bottom : (par1 == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return this.func_94041_b(var1, var2);
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return var3 != 0 || var1 != 1 || var2.func_77973_b() == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return this.analyzerItemStacks.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.analyzerItemStacks[var1];
    }

    public ItemStack func_70298_a(int slot, int decrAmount) {
        if (this.analyzerItemStacks[slot] != null) {
            if (this.analyzerItemStacks[slot].field_77994_a <= decrAmount) {
                ItemStack var3 = this.analyzerItemStacks[slot];
                this.analyzerItemStacks[slot] = null;
                return var3;
            }
            ItemStack var3 = this.analyzerItemStacks[slot].func_77979_a(decrAmount);
            if (this.analyzerItemStacks[slot].field_77994_a == 0) {
                this.analyzerItemStacks[slot] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.analyzerItemStacks[var1] != null) {
            ItemStack itemstack = this.analyzerItemStacks[var1];
            this.analyzerItemStacks[var1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.analyzerItemStacks[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Analyzer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return var1 != 2 && (var1 != 1 || TileAnalyzer.isItemFuel());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.analyzerItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound var4 = nbttaglist.func_150305_b(i);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.analyzerItemStacks.length) continue;
            this.analyzerItemStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.analyzerBurnTime = compound.func_74765_d("BurnTime");
        this.analyzerCookTime = compound.func_74765_d("CookTime");
        this.currentItemBurnTime = 100;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74777_a("BurnTime", (short)this.analyzerBurnTime);
        compound.func_74777_a("CookTime", (short)this.analyzerCookTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.analyzerItemStacks.length; ++i) {
            if (this.analyzerItemStacks[i] == null) continue;
            NBTTagCompound slotCompound = new NBTTagCompound();
            slotCompound.func_74774_a("Slot", (byte)i);
            this.analyzerItemStacks[i].func_77955_b(slotCompound);
            tagList.func_74742_a((NBTBase)slotCompound);
        }
        compound.func_74782_a("Items", (NBTBase)tagList);
    }

    public int getCookPrograssScaled(int par1) {
        return this.analyzerCookTime * par1 / 200;
    }

    public boolean isBurning() {
        return this.analyzerBurnTime > 0;
    }

    public void func_145845_h() {
        boolean var1 = this.analyzerBurnTime > 0;
        boolean var2 = false;
        if (this.analyzerBurnTime > 0) {
            --this.analyzerBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.analyzerBurnTime == 0 && this.canSmelt()) {
                this.analyzerBurnTime = 100;
                this.currentItemBurnTime = 100;
                if (this.analyzerBurnTime > 0) {
                    var2 = true;
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.analyzerCookTime;
                if (this.analyzerCookTime == 200) {
                    this.analyzerCookTime = 0;
                    this.smeltItem();
                    var2 = true;
                }
            } else {
                this.analyzerCookTime = 0;
            }
            if (var1 != this.analyzerBurnTime > 0) {
                var2 = true;
                BlockAnalyzer.updateAnalyzerBlockState(this.analyzerBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (var2) {
            this.func_145845_h();
        }
    }

    private boolean canSmelt() {
        int var1;
        this.SpaceIndex = -1;
        this.RawIndex = -1;
        for (var1 = 0; var1 < 9; ++var1) {
            Item var2;
            if (this.analyzerItemStacks[var1] == null || (var2 = this.analyzerItemStacks[var1].func_77973_b()) != Util.getItem(2) && var2 != Util.getItem(1)) continue;
            this.RawIndex = var1;
            break;
        }
        if (this.RawIndex == -1) {
            return false;
        }
        for (var1 = 12; var1 > 8; --var1) {
            if (this.analyzerItemStacks[var1] != null) continue;
            this.SpaceIndex = var1;
            break;
        }
        return this.SpaceIndex != -1 && this.RawIndex != -1;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack var1 = null;
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Util.getItem(2)) {
                int dnaResult = new Random().nextInt(99);
                if (dnaResult > 74) {
                    var1 = new ItemStack(this.getRandomDNA(new Random()));
                } else {
                    int output = new Random().nextInt(3);
                    if (output == 0) {
                        var1 = new ItemStack((Block)Blocks.field_150354_m, 3);
                    } else if (output == 1) {
                        var1 = new ItemStack(Blocks.field_150348_b, 1);
                    } else if (output == 2) {
                        var1 = new ItemStack(Items.field_151103_aS, 2);
                    }
                }
            }
            if (this.analyzerItemStacks[this.RawIndex].func_77973_b() == Util.getItem(1)) {
                var1 = new ItemStack(this.getRandomDNA(new Random()));
            }
            if (var1 != null) {
                if (var1.field_77994_a != 0 && this.analyzerItemStacks[this.SpaceIndex] == null) {
                    this.analyzerItemStacks[this.SpaceIndex] = var1.func_77946_l();
                }
                --this.analyzerItemStacks[this.RawIndex].field_77994_a;
                if (this.analyzerItemStacks[this.RawIndex].field_77994_a == 0) {
                    this.analyzerItemStacks[this.RawIndex] = null;
                }
            }
        }
    }

    private Item getRandomDNA(Random rand) {
        int dna = rand.nextInt(dnas.size());
        return dnas.get(dna);
    }
}

