/*
 * Decompiled with CFR 0.152.
 */
package to.uk.ilexiconn.jurassicraft.data.entity;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.item.Item;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import to.uk.ilexiconn.jurassicraft.Util;
import to.uk.ilexiconn.jurassicraft.data.entity.Dinosaur;

public abstract class EntityDinosaurWaterCreature
extends EntityWaterMob {
    private float factor1 = 0.0f;
    private float factor2 = 0.0f;
    private float randomSpeed = 0.0f;
    private float randomVecX = 0.0f;
    private float randomVecY = 0.0f;
    private float randomVecZ = 0.0f;
    protected int mobInterval = 30;
    protected float mobSpeed = 0.2f;
    public int animID;
    public int animTick;
    public int dinoID;

    public EntityDinosaurWaterCreature(World world, int id) {
        super(world);
        this.dinoID = id;
        Dinosaur dinoByID = Util.getDinoByID(this.dinoID);
        this.func_70105_a(dinoByID.hitboxSizeXZ, dinoByID.hitboxSizeY);
        this.factor2 = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        Dinosaur dinoByID = Util.getDinoByID(this.dinoID);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(dinoByID.dinoHealth * 2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(dinoByID.dinoSpeed);
    }

    public boolean func_70692_ba() {
        return false;
    }

    public int getAnimTick() {
        return this.animTick;
    }

    public int getAnimID() {
        return this.animID;
    }

    public void setAnimID(int id) {
        this.animID = id;
    }

    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    public Item func_146068_u() {
        return Util.getMeat(this.dinoID);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.animID != 0) {
            ++this.animTick;
        }
    }

    public String func_70639_aQ() {
        int I = this.field_70146_Z.nextInt(1) + 1;
        Dinosaur dinoByID = Util.getDinoByID(this.dinoID);
        if (I == 1) {
            return dinoByID.livingSound1;
        }
        return dinoByID.livingSound2;
    }

    public String func_70621_aR() {
        Dinosaur dinoByID = Util.getDinoByID(this.dinoID);
        return dinoByID.hurtSound;
    }

    public String func_70673_aS() {
        Dinosaur dinoByID = Util.getDinoByID(this.dinoID);
        return dinoByID.deathSound;
    }

    protected int getAttackStrength() {
        Dinosaur dinoByID = Util.getDinoByID(this.dinoID);
        return (int)dinoByID.dinoStrength;
    }

    protected boolean canAttackEntity(Entity var1) {
        return var1 instanceof EntityLiving && this.field_70130_N > var1.field_70130_N && this.field_70131_O >= var1.field_70131_O;
    }

    protected Entity findEntityToAttack() {
        Entity entity;
        List var1 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(10.0, 6.0, 10.0));
        Collections.sort(var1, new EntityAINearestAttackableTarget.Sorter((Entity)this));
        Iterator var2 = var1.iterator();
        do {
            if (var2.hasNext()) continue;
            return null;
        } while (!(entity = (Entity)var2.next()).func_70090_H() || !this.canAttackEntity(entity));
        return entity;
    }

    public void func_82167_n(Entity entity) {
        super.func_82167_n(entity);
        if (this.field_70789_a == entity && this.getAttackStrength() != 0) {
            this.field_70724_aR = 30;
            this.field_70789_a.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength());
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.factor1 += this.factor2;
        if (this.factor1 > (float)Math.PI * 2) {
            this.factor1 -= (float)Math.PI * 2;
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.factor2 = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.func_70090_H()) {
            float var1;
            if (this.factor1 < (float)Math.PI) {
                var1 = this.factor1 / (float)Math.PI;
                if ((double)var1 > 0.75) {
                    this.randomSpeed = 1.0f;
                }
            } else {
                this.randomSpeed *= 0.95f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = this.randomVecX * this.randomSpeed;
                this.field_70181_x = this.randomVecY * this.randomSpeed;
                this.field_70179_y = this.randomVecZ * this.randomSpeed;
            }
            this.field_70761_aq += (-((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            if (var1 > 0.07f) {
                this.field_70125_A = (float)Math.atan2(this.field_70181_x, var1) * 180.0f / (float)Math.PI;
            }
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x -= 0.08;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y = 0.0;
            if (!this.func_70090_H()) {
                this.field_70125_A = 0.0f;
                if (this.field_70122_E && this.field_70146_Z.nextInt(30) == 0) {
                    this.field_70181_x = 0.3f;
                    this.field_70159_w = -0.4f + this.field_70146_Z.nextFloat() * 0.8f;
                    this.field_70179_y = -0.4f + this.field_70146_Z.nextFloat() * 0.8f;
                }
            }
        }
    }

    protected void func_70626_be() {
        ++this.field_70708_bq;
        if (this.field_70708_bq > 100) {
            this.randomVecZ = 0.0f;
            this.randomVecY = 0.0f;
            this.randomVecX = 0.0f;
        } else if (this.field_70146_Z.nextInt(this.mobInterval) == 0 || !this.field_70171_ac || this.field_70132_H || this.randomVecX == 0.0f && this.randomVecY == 0.0f && this.randomVecZ == 0.0f) {
            if (this.field_70789_a != null && this.field_70724_aR <= 0) {
                if (this.field_70789_a != null) {
                    if (!this.field_70789_a.field_70128_L && this.field_70789_a.func_70090_H() && this.func_70032_d(this.field_70789_a) <= 10.0f && this.field_70724_aR <= 0) {
                        this.randomVecX = (float)Math.signum(this.field_70789_a.field_70165_t - this.field_70165_t) * this.mobSpeed;
                        this.randomVecY = (float)Math.signum(this.field_70789_a.field_70163_u - this.field_70163_u) * 0.1f;
                        this.randomVecZ = (float)Math.signum(this.field_70789_a.field_70161_v - this.field_70161_v) * this.mobSpeed;
                        if (!(this.field_70789_a instanceof EntityLiving)) {
                            this.randomVecY -= 0.12f;
                            if (this.field_70789_a instanceof EntityFishHook && this.func_70032_d(this.field_70789_a) < 1.0f) {
                                EntityFishHook var2 = (EntityFishHook)this.field_70789_a;
                                this.field_70789_a = null;
                                if (var2.field_146043_c == null) {
                                    this.func_70097_a(DamageSource.func_76356_a((Entity)var2, (Entity)var2.field_146042_b), 0.0f);
                                    var2.field_146043_c = this;
                                    var2.field_146042_b.func_71064_a(StatList.field_151183_A, 1);
                                }
                            }
                        }
                    } else {
                        this.field_70789_a = null;
                    }
                }
            } else {
                float var1 = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                this.randomVecX = MathHelper.func_76134_b((float)var1) * this.mobSpeed;
                this.randomVecY = -0.1f + this.field_70146_Z.nextFloat() * 0.2f;
                this.randomVecZ = MathHelper.func_76126_a((float)var1) * this.mobSpeed;
                if (this.getAttackStrength() > 0) {
                    this.field_70789_a = this.findEntityToAttack();
                }
            }
        }
        this.func_70623_bb();
    }
}

