/*
 * Decompiled with CFR 0.152.
 */
package to.uk.ilexiconn.jurassicraft.data.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import to.uk.ilexiconn.jurassicraft.JurassiCraft;
import to.uk.ilexiconn.jurassicraft.Util;
import to.uk.ilexiconn.jurassicraft.data.tile.TileAnalyzer;

public class BlockAnalyzer
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    public IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon frontIconIdle;
    @SideOnly(value=Side.CLIENT)
    public IIcon frontIconActive;
    @SideOnly(value=Side.CLIENT)
    public IIcon sideIcon;
    public boolean active;

    public BlockAnalyzer(boolean active) {
        super(Material.field_151573_f);
        this.active = active;
        this.func_149663_c("analyzer_" + (active ? "active" : "idle"));
        this.func_149658_d(Util.getModId() + "analyzer");
        this.func_149647_a(active ? null : Util.getCreativeTab(0));
        this.func_149711_c(3.0f);
    }

    public static void updateAnalyzerBlockState(boolean isActive, World worldObj, int xCoord, int yCoord, int zCoord) {
        int metadata = worldObj.func_72805_g(xCoord, yCoord, zCoord);
        TileEntity analyzerTileEntity = worldObj.func_147438_o(xCoord, yCoord, zCoord);
        if (analyzerTileEntity != null) {
            if (isActive) {
                worldObj.func_147449_b(xCoord, yCoord, zCoord, Util.getBlock(2));
            } else {
                worldObj.func_147449_b(xCoord, yCoord, zCoord, Util.getBlock(3));
            }
            worldObj.func_72921_c(xCoord, yCoord, zCoord, metadata, 2);
            analyzerTileEntity.func_145829_t();
            worldObj.func_147455_a(xCoord, yCoord, zCoord, analyzerTileEntity);
        }
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileAnalyzer();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (metadata == 0 && side == 3) {
            return this.frontIconIdle;
        }
        return side == 1 ? this.topIcon : (side == 0 ? this.topIcon : (side != metadata ? this.sideIcon : (this.active ? this.frontIconActive : this.frontIconIdle)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcon = iconRegister.func_94245_a(Util.getModId() + "analyzer_top");
        this.sideIcon = iconRegister.func_94245_a(Util.getModId() + "analyzer_side");
        this.frontIconIdle = iconRegister.func_94245_a(Util.getModId() + "analyzer_front_idle");
        this.frontIconActive = iconRegister.func_94245_a(Util.getModId() + "analyzer_front_active");
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        } else if (l == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        } else if (l == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        } else if (l == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float i, float d, float k) {
        player.openGui((Object)JurassiCraft.instance, 1, world, x, y, z);
        return true;
    }
}

