/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.inputevent;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import org.lwjgl.input.Controllers;

public abstract class ControllerInputEvent {
    protected final EventType type;
    protected final int controllerNumber;
    protected final int buttonNumber;
    protected float threshold;
    protected float deadzone;
    protected boolean isActive;
    protected boolean wasReleased;
    protected boolean pressedOnce;

    public ControllerInputEvent(EventType type, int controllerNumber, int buttonNumber, float threshold, float deadzone) {
        LogHelper.Info("ControllerInputEvent constructor params:( type: " + (Object)((Object)type) + ", controllerNumber: " + controllerNumber + ", buttonNumber: " + buttonNumber + ", threshhold: " + threshold + ", deadzone: " + deadzone + ")");
        this.type = type;
        this.controllerNumber = controllerNumber;
        this.buttonNumber = buttonNumber;
        this.threshold = threshold;
        this.deadzone = deadzone;
        this.isActive = false;
        this.wasReleased = false;
        this.pressedOnce = false;
    }

    protected abstract boolean isTargetEvent();

    public abstract boolean isValid();

    public abstract float getAnalogReading();

    public abstract String getName();

    public abstract String getDescription();

    public EventType getEventType() {
        return this.type;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean pressedOnce() {
        return this.pressedOnce;
    }

    public boolean isPressed() {
        if (!this.isActive || !this.isValid()) {
            return false;
        }
        boolean ret = this.meetsThreshold();
        if (!ret) {
            this.wasReleased = true;
            this.isActive = false;
        }
        return ret;
    }

    public boolean wasPressed() {
        boolean bRet;
        if (!this.isValid()) {
            return false;
        }
        boolean bl = bRet = this.wasPressedRaw() && this.meetsThreshold();
        if (bRet) {
            this.isActive = true;
        }
        if (this.isActive && this.wasReleased) {
            LogHelper.Warn("wasPressed returning true prior to the wasReleased being consumed");
            this.wasReleased = false;
        }
        return bRet;
    }

    public boolean wasPressedRaw() {
        if (!this.isValid()) {
            return false;
        }
        if (Controllers.getEventSource().getIndex() == this.controllerNumber && this.isTargetEvent()) {
            this.pressedOnce = true;
            return true;
        }
        return false;
    }

    public boolean wasReleased() {
        boolean bRet = false;
        if (this.wasReleased) {
            if (ControllerSettings.loggingLevel > 1) {
                LogHelper.Debug("wasReleased returning true for " + this.getName());
            }
            bRet = true;
            this.wasReleased = false;
        }
        return bRet;
    }

    protected boolean meetsThreshold() {
        return this.threshold > 0.0f ? this.getAnalogReading() >= this.threshold : this.getAnalogReading() <= this.threshold;
    }

    public int getControllerIndex() {
        return this.controllerNumber;
    }

    public int getEventIndex() {
        return this.buttonNumber;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float f) {
        this.threshold = f;
    }

    public float getDeadZone() {
        return this.deadzone;
    }

    public void setDeadZone(float f) {
    }

    public String toConfigFileString() {
        String s = this.getEventType().toString() + "," + this.getEventIndex() + "," + this.getThreshold() + "," + this.getDeadZone();
        return s;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ControllerInputEvent inputEvent = (ControllerInputEvent)obj;
        return inputEvent.type == this.type && inputEvent.buttonNumber == this.buttonNumber && inputEvent.threshold == this.threshold;
    }

    public static enum EventType {
        BUTTON,
        AXIS,
        POV;

    }
}

