/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.inputevent;

import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.inputevent.AxisInputEvent;
import com.shiny.joypadmod.inputevent.ButtonInputEvent;
import com.shiny.joypadmod.inputevent.ControllerInputEvent;
import com.shiny.joypadmod.inputevent.PovInputEvent;
import com.shiny.joypadmod.lwjglVirtualInput.VirtualKeyboard;
import com.shiny.joypadmod.lwjglVirtualInput.VirtualMouse;
import com.shiny.joypadmod.minecraftExtensions.JoypadCalibrationMenu;
import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class ControllerBinding {
    public static String[] BindingOptionsComment = new String[]{"Will trigger in menu screens", "Will trigger during game play", "Pressing button once will toggle on / off", "Continues to trigger if held down", "Send the trigger during client tick", "Send the trigger during render tick", "Shows up in Movement category in menu", "Shows up in UI category in menu", "Inventory category in menu", "Gameplay category in menu", "Multiplayer category in menu", "Misc category in menu"};
    public String inputString;
    public String menuString;
    public int[] keyCodes;
    public boolean toggleState = false;
    public long delay;
    public long lastTick = 0L;
    public EnumSet<BindingOptions> bindingOptions;
    public ControllerInputEvent inputEvent;

    public ControllerBinding(String inputString, String menuString, ControllerInputEvent inputEvent, int[] keyCodes, long delayBetweenPresses, EnumSet<BindingOptions> options) {
        this.inputString = inputString;
        this.menuString = menuString;
        this.inputEvent = inputEvent;
        this.keyCodes = keyCodes;
        this.delay = delayBetweenPresses;
        this.bindingOptions = options;
    }

    public ControllerBinding(String bindingString, int joyNo, double lastConfigFileVersion) {
        this.setToConfigFileString(bindingString, joyNo, lastConfigFileVersion);
    }

    public void setKeybinding(int[] keyCodes) {
        this.keyCodes = keyCodes;
    }

    public boolean hasCategory() {
        return this.bindingOptions.contains((Object)BindingOptions.CATEGORY_GAMEPLAY) || this.bindingOptions.contains((Object)BindingOptions.CATEGORY_UI) || this.bindingOptions.contains((Object)BindingOptions.CATEGORY_INVENTORY) || this.bindingOptions.contains((Object)BindingOptions.CATEGORY_MOVEMENT) || this.bindingOptions.contains((Object)BindingOptions.CATEGORY_MULTIPLAYER) || this.bindingOptions.contains((Object)BindingOptions.CATEGORY_MISC);
    }

    public BindingOptions getCategory() {
        for (BindingOptions option : this.bindingOptions) {
            if (!option.toString().contains("CATEGORY_")) continue;
            return option;
        }
        return BindingOptions.CATEGORY_MISC;
    }

    public String getCategoryString() {
        BindingOptions category = this.getCategory();
        String target = category.toString().split("_")[1].toLowerCase(Locale.ENGLISH);
        return "joy.categories." + target;
    }

    public static BindingOptions mapMinecraftCategory(String category) {
        if (category.contains(".gameplay")) {
            return BindingOptions.CATEGORY_GAMEPLAY;
        }
        if (category.contains(".ui")) {
            return BindingOptions.CATEGORY_UI;
        }
        if (category.contains(".inventory")) {
            return BindingOptions.CATEGORY_INVENTORY;
        }
        if (category.contains(".movement")) {
            return BindingOptions.CATEGORY_MOVEMENT;
        }
        if (category.contains(".multiplayer")) {
            return BindingOptions.CATEGORY_MULTIPLAYER;
        }
        return BindingOptions.CATEGORY_MISC;
    }

    private void handleMouse(boolean pressed, int code, boolean firstPress) {
        if (code >= 0) {
            LogHelper.Warn("Someone is calling handle mouse for a non-mouse code!");
            return;
        }
        boolean isWheel = false;
        if (code <= -199) {
            isWheel = true;
            code += 200;
        } else {
            code += 100;
        }
        if (pressed) {
            if (isWheel) {
                if (firstPress || this.bindingOptions.contains((Object)BindingOptions.REPEAT_IF_HELD)) {
                    VirtualMouse.scrollWheel(code);
                }
            } else if (firstPress) {
                VirtualMouse.holdMouseButton(code, true);
            } else if (this.bindingOptions.contains((Object)BindingOptions.REPEAT_IF_HELD)) {
                VirtualMouse.setMouseButton(code, true);
            }
        } else if (!isWheel) {
            VirtualMouse.releaseMouseButton(code, true);
        }
    }

    public boolean isPressed() {
        return this.isPressed(this.keyCodes != null);
    }

    public boolean isPressed(boolean autoHandle) {
        boolean wasReleased;
        boolean bRet = this.inputEvent.isPressed();
        boolean bl = wasReleased = !bRet ? this.inputEvent.wasReleased() : false;
        if (this.bindingOptions.contains((Object)BindingOptions.IS_TOGGLE) && this.toggleState) {
            bRet = true;
        }
        if (autoHandle && bRet && Minecraft.func_71386_F() - this.lastTick >= this.delay || wasReleased && this.keyCodes != null) {
            for (int i : this.keyCodes) {
                if (i < 0) {
                    this.handleMouse(bRet, i, false);
                    continue;
                }
                if (!bRet) {
                    VirtualKeyboard.releaseKey(i, true);
                    continue;
                }
                if (!this.bindingOptions.contains((Object)BindingOptions.REPEAT_IF_HELD)) continue;
                VirtualKeyboard.holdKey(i, true);
            }
            if (bRet) {
                this.lastTick = Minecraft.func_71386_F();
            }
        }
        return bRet;
    }

    public boolean wasPressed() {
        return this.wasPressed(this.keyCodes != null && this.keyCodes.length != 0);
    }

    public boolean wasPressed(boolean autoHandle) {
        return this.wasPressed(autoHandle, false);
    }

    public boolean wasPressed(boolean autoHandle, boolean forceHandle) {
        boolean bRet;
        boolean bl = bRet = forceHandle ? true : this.inputEvent.wasPressed();
        if (bRet) {
            boolean sendPressKey = true;
            if (this.bindingOptions.contains((Object)BindingOptions.IS_TOGGLE)) {
                sendPressKey = this.toggleState = !this.toggleState;
            }
            if (autoHandle && Minecraft.func_71386_F() - this.lastTick >= this.delay) {
                for (int i : this.keyCodes) {
                    if (i < 0) {
                        this.handleMouse(bRet, i, true);
                        continue;
                    }
                    if (i == 1 && Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof JoypadCalibrationMenu) continue;
                    if (sendPressKey) {
                        VirtualKeyboard.pressKey(i);
                        continue;
                    }
                    VirtualKeyboard.releaseKey(i, true);
                }
                this.lastTick = Minecraft.func_71386_F();
            }
        }
        return bRet;
    }

    public float getAnalogReading() {
        if (this.inputEvent.isValid()) {
            return this.inputEvent.getAnalogReading();
        }
        return 0.0f;
    }

    public String toConfigFileString() {
        String s = this.menuString + ",";
        if (this.keyCodes != null) {
            s = s + "{";
            for (int i = 0; i < this.keyCodes.length; ++i) {
                s = s + this.keyCodes[i];
                if (i + 1 >= this.keyCodes.length) continue;
                s = s + " ";
            }
            s = s + "},";
        }
        if (this.inputEvent != null) {
            s = s + this.inputEvent.toConfigFileString();
        }
        if (this.bindingOptions != null) {
            Object[] options;
            for (Object bo : options = this.bindingOptions.toArray()) {
                s = s + "," + bo.toString();
            }
        }
        return s;
    }

    public boolean setToConfigFileString(String s, int joyNo, double lastConfigFileVersion) {
        if (s == null) {
            return false;
        }
        LogHelper.Info("setToConfigFileString called with following values: " + s);
        String[] settings = s.split(",");
        int minToProcess = 6;
        if (settings.length < minToProcess) {
            LogHelper.Error("Expected " + minToProcess + " arguments when parsing config setting: \"" + s + "\" Received " + settings.length);
            return false;
        }
        try {
            int i = 0;
            this.inputString = settings[i++];
            if (lastConfigFileVersion < 0.0953) {
                if (this.inputString.contains("run")) {
                    this.inputString = "joy.sprint";
                } else if (this.inputString.contains("movement")) {
                    if (this.inputString.contains("Y-")) {
                        this.inputString = "joy.forward";
                    } else if (this.inputString.contains("Y+")) {
                        this.inputString = "joy.back";
                    } else if (this.inputString.contains("X-")) {
                        this.inputString = "joy.left";
                    } else if (this.inputString.contains("X+")) {
                        this.inputString = "joy.right";
                    }
                }
            }
            this.menuString = settings[i++];
            if (settings[i].contains("{") && settings[i].contains("}")) {
                String[] keyCodesS = settings[i].replaceAll("\\{", "").replaceAll("\\}", "").split(" ");
                this.keyCodes = new int[keyCodesS.length];
                for (int j = 0; j < keyCodesS.length; ++j) {
                    try {
                        this.keyCodes[j] = Integer.parseInt(keyCodesS[j]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        this.keyCodes[j] = Keyboard.getKeyIndex((String)keyCodesS[j]);
                    }
                }
            }
            int n = ++i;
            ControllerInputEvent.EventType event = ControllerInputEvent.EventType.valueOf(settings[n]);
            int n2 = ++i;
            int eventIndex = Integer.parseInt(settings[n2]);
            int n3 = ++i;
            float threshold = Float.parseFloat(settings[n3]);
            int n4 = ++i;
            ++i;
            float deadzone = Float.parseFloat(settings[n4]);
            if (this.bindingOptions == null) {
                this.bindingOptions = EnumSet.noneOf(BindingOptions.class);
            } else {
                this.bindingOptions.clear();
            }
            while (i < settings.length) {
                try {
                    this.bindingOptions.add(BindingOptions.valueOf(settings[i]));
                }
                catch (Exception ex) {
                    LogHelper.Error("Failed trying to parse " + settings[i] + " to a binding option. " + ex.toString());
                }
                ++i;
            }
            if (event == ControllerInputEvent.EventType.BUTTON) {
                if (lastConfigFileVersion < 0.08) {
                    threshold = 1.0f;
                }
                this.inputEvent = new ButtonInputEvent(joyNo, eventIndex, threshold);
            } else if (event == ControllerInputEvent.EventType.POV) {
                this.inputEvent = new PovInputEvent(joyNo, eventIndex, threshold);
            } else if (event == ControllerInputEvent.EventType.AXIS) {
                this.inputEvent = new AxisInputEvent(joyNo, eventIndex, threshold, deadzone);
            }
        }
        catch (Exception ex) {
            LogHelper.Error("Failed setting bindings using config string: " + s + ". Exception: " + ex.toString());
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ControllerBinding bind = (ControllerBinding)obj;
        return this.inputString == bind.inputString && this.inputEvent.getControllerIndex() == bind.inputEvent.getControllerIndex() && this.toConfigFileString().equals(bind.toConfigFileString());
    }

    public static enum BindingOptions {
        MENU_BINDING,
        GAME_BINDING,
        IS_TOGGLE,
        REPEAT_IF_HELD,
        CLIENT_TICK,
        RENDER_TICK,
        CATEGORY_MOVEMENT,
        CATEGORY_UI,
        CATEGORY_INVENTORY,
        CATEGORY_GAMEPLAY,
        CATEGORY_MULTIPLAYER,
        CATEGORY_MISC;

    }
}

