/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.inputevent.ControllerInputEvent;
import com.shiny.joypadmod.lwjglVirtualInput.VirtualMouse;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;

public class JoypadMouse {
    public static int getX() {
        return AxisReader.x;
    }

    public static int getY() {
        return AxisReader.y;
    }

    public static int getmcX() {
        return AxisReader.mcX;
    }

    public static int getmcY() {
        return AxisReader.mcY;
    }

    public static void pollAxis() {
        AxisReader.pollAxis();
    }

    public static boolean pollAxis(boolean inGui) {
        AxisReader.pollAxis(inGui);
        return AxisReader.deltaX != 0.0f || AxisReader.deltaY != 0.0f;
    }

    public static void updateXY() {
        AxisReader.updateXY();
    }

    public static void leftButtonDown() {
        if (!VirtualMouse.isButtonDown(0)) {
            VirtualMouse.setXY(AxisReader.mcX, AxisReader.mcY);
            VirtualMouse.holdMouseButton(0, true);
        }
    }

    public static void leftButtonUp() {
        if (VirtualMouse.isButtonDown(0)) {
            VirtualMouse.releaseMouseButton(0, true);
        }
    }

    public static boolean isLeftButtonDown() {
        return VirtualMouse.isButtonDown(0);
    }

    public static void rightButtonDown() {
        if (!VirtualMouse.isButtonDown(1)) {
            VirtualMouse.setXY(AxisReader.mcX, AxisReader.mcY);
            VirtualMouse.holdMouseButton(1, true);
        }
    }

    public static void rightButtonUp() {
        if (VirtualMouse.isButtonDown(1)) {
            VirtualMouse.releaseMouseButton(1, true);
        }
    }

    public static boolean isRightButtonDown() {
        return VirtualMouse.isButtonDown(1);
    }

    public static void UnpressButtons() {
        for (int i = 0; i < 2; ++i) {
            if (!VirtualMouse.isButtonDown(i)) continue;
            VirtualMouse.releaseMouseButton(i, true);
        }
    }

    public static class AxisReader {
        private static Minecraft mc = Minecraft.func_71410_x();
        public static float deltaX;
        public static float deltaY;
        public static int x;
        public static int y;
        public static int mcX;
        public static int mcY;
        private static long lastAxisReading;
        private static long guiPollTimeout;
        private static long gamePollTimeout;
        public static long last0Reading;
        public static long lastNon0Reading;

        public static void pollAxis() {
            AxisReader.pollAxis(AxisReader.mc.field_71462_r != null);
        }

        public static void pollAxis(boolean inGui) {
            float verticalThreshold;
            float verticalMovement;
            float horizontalThreshold;
            float horizontalMovement;
            if (!AxisReader.pollNeeded(inGui)) {
                return;
            }
            float xPlus = AxisReader.getReading(inGui ? "joy.guiX+" : "joy.cameraX+");
            float xMinus = AxisReader.getReading(inGui ? "joy.guiX-" : "joy.cameraX-");
            if (Math.abs(xPlus) > Math.abs(xMinus)) {
                horizontalMovement = xPlus;
                horizontalThreshold = ControllerSettings.get((String)(inGui ? "joy.guiX+" : "joy.cameraX+")).inputEvent.getThreshold();
            } else {
                horizontalMovement = xMinus;
                horizontalThreshold = ControllerSettings.get((String)(inGui ? "joy.guiX-" : "joy.cameraX-")).inputEvent.getThreshold();
            }
            float yPlus = AxisReader.getReading(inGui ? "joy.guiY+" : "joy.cameraY+");
            float yMinus = AxisReader.getReading(inGui ? "joy.guiY-" : "joy.cameraY-");
            if (Math.abs(yPlus) > Math.abs(yMinus)) {
                verticalMovement = yPlus;
                verticalThreshold = ControllerSettings.get((String)(inGui ? "joy.guiY+" : "joy.cameraY+")).inputEvent.getThreshold();
            } else {
                verticalMovement = yMinus;
                verticalThreshold = ControllerSettings.get((String)(inGui ? "joy.guiY-" : "joy.cameraY-")).inputEvent.getThreshold();
            }
            deltaX = horizontalMovement;
            deltaY = verticalMovement;
            if (deltaX == 0.0f && deltaY == 0.0f) {
                last0Reading = Minecraft.func_71386_F();
                return;
            }
            lastNon0Reading = Minecraft.func_71386_F();
            deltaX = AxisReader.calculateFinalDelta(inGui, deltaX, horizontalThreshold);
            deltaY = AxisReader.calculateFinalDelta(inGui, deltaY, verticalThreshold);
            if (ControllerSettings.loggingLevel > 2) {
                LogHelper.Info("Camera deltaX: " + deltaX + " Camera deltaY: " + deltaY);
            }
            lastAxisReading = Minecraft.func_71386_F();
        }

        public static void updateXY() {
            if (!AxisReader.pollNeeded(AxisReader.mc.field_71462_r != null)) {
                return;
            }
            ScaledResolution scaledResolution = new ScaledResolution(mc, AxisReader.mc.field_71443_c, AxisReader.mc.field_71440_d);
            AxisReader.pollAxis();
            if (AxisReader.mc.field_71462_r != null) {
                y += (int)deltaY;
                if ((x += (int)deltaX) < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                if (x > scaledResolution.func_78326_a()) {
                    x = scaledResolution.func_78326_a() - 5;
                }
                if (y > scaledResolution.func_78328_b()) {
                    y = scaledResolution.func_78328_b() - 5;
                }
                if (ControllerSettings.loggingLevel > 2) {
                    LogHelper.Debug("Virtual Mouse x: " + x + " y: " + y);
                }
                mcY = AxisReader.mc.field_71440_d - y * scaledResolution.func_78325_e();
                mcX = x * scaledResolution.func_78325_e();
                deltaX = 0.0f;
                deltaY = 0.0f;
            }
        }

        public static void centerCrosshairs() {
            ScaledResolution scaledResolution = new ScaledResolution(mc, AxisReader.mc.field_71443_c, AxisReader.mc.field_71440_d);
            x = scaledResolution.func_78326_a() / 2;
            y = scaledResolution.func_78328_b() / 2;
            mcY = AxisReader.mc.field_71440_d - y * scaledResolution.func_78325_e();
            mcX = x * scaledResolution.func_78325_e();
        }

        public static boolean pollNeeded(boolean inGui) {
            return Minecraft.func_71386_F() - lastAxisReading >= (inGui ? guiPollTimeout : gamePollTimeout);
        }

        public static void setXY(int x, int y) {
            ScaledResolution scaledResolution = new ScaledResolution(mc, AxisReader.mc.field_71443_c, AxisReader.mc.field_71440_d);
            AxisReader.x = x;
            AxisReader.y = y;
            mcX = x * scaledResolution.func_78325_e();
            mcY = AxisReader.mc.field_71440_d - y * scaledResolution.func_78325_e();
        }

        private static float getReading(String bindKey) {
            boolean isButton;
            boolean bl = isButton = ControllerSettings.get((String)bindKey).inputEvent.getEventType() == ControllerInputEvent.EventType.BUTTON;
            if (isButton || ControllerSettings.get((String)bindKey).inputEvent.pressedOnce()) {
                float f = ControllerSettings.get(bindKey).getAnalogReading();
                if (isButton && bindKey.contains("-")) {
                    f *= -1.0f;
                }
                return f;
            }
            return 0.0f;
        }

        private static float getModifiedMultiplier(float currentMultiplier) {
            long elapsed = Minecraft.func_71386_F() - last0Reading;
            if (elapsed < 500L) {
                float base = currentMultiplier * 0.5f;
                currentMultiplier = base + base * (float)elapsed / 500.0f;
                if (ControllerSettings.loggingLevel > 2) {
                    LogHelper.Info("CameraMultiplier " + currentMultiplier);
                }
            }
            return currentMultiplier;
        }

        private static float calculateFinalDelta(boolean inGui, float currentDelta, float currentThreshold) {
            if ((double)Math.abs(currentDelta) < 0.01) {
                return 0.0f;
            }
            if (Math.abs(currentDelta) < Math.abs(currentThreshold / 3.0f)) {
                return currentDelta < 0.0f ? -1 : 1;
            }
            float cameraMultiplier = inGui ? ControllerSettings.inMenuSensitivity : ControllerSettings.inGameSensitivity;
            cameraMultiplier = !inGui && Math.abs(currentDelta) < Math.abs(currentThreshold / 2.0f) ? (float)((double)cameraMultiplier * 0.3) : (Math.abs(currentDelta) < Math.abs(currentThreshold) ? (float)((double)cameraMultiplier * 0.5) : AxisReader.getModifiedMultiplier(cameraMultiplier));
            float finalDelta = currentDelta * cameraMultiplier;
            if ((double)finalDelta < 1.0 && (double)finalDelta > 0.0) {
                finalDelta = 1.0f;
            } else if (finalDelta < 0.0f && (double)finalDelta > -1.0) {
                finalDelta = -1.0f;
            }
            return finalDelta;
        }

        static {
            x = 0;
            y = 0;
            mcX = 0;
            mcY = 0;
            lastAxisReading = 0L;
            guiPollTimeout = 30L;
            gamePollTimeout = 10L;
            last0Reading = 0L;
            lastNon0Reading = 0L;
        }
    }
}

