/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.minecraftExtensions;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McObfuscationHelper;
import com.shiny.joypadmod.minecraftExtensions.JoypadCalibrationList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;

public class JoypadCalibrationMenu
extends GuiScreen {
    public GuiScreen parent;
    private int buttonYStart_bottom;
    private int bottomButtonWidth = 70;
    private int joypadIndex;
    private int yStart = 5;
    private int buttonBoxWidth = 132;
    public int axisBoxWidth = 275;
    private int povBoxWidth;
    private int instructionBoxWidth;
    private int boxSpacing = 5;
    private String lastControllerEvent = "";
    private JoypadCalibrationList calibrationList = null;
    FontRenderer fr;
    String[] instructions;

    public JoypadCalibrationMenu(GuiScreen parent, int joypadIndex) {
        this.fr = Minecraft.func_71410_x().field_71466_p;
        this.instructions = new String[]{"calibrationMenu.instructions1", "calibrationMenu.instructions2", "calibrationMenu.save"};
        this.joypadIndex = joypadIndex;
        this.parent = parent;
    }

    public void func_146281_b() {
        ControllerSettings.applySavedDeadZones(this.joypadIndex);
        super.func_146281_b();
    }

    public void func_73866_w_() {
        this.povBoxWidth = this.fr.func_78256_a("PovX: -10.00");
        this.instructionBoxWidth = 0;
        for (int i = 0; i < this.instructions.length; ++i) {
            int newWidth = this.fr.func_78256_a(McObfuscationHelper.lookupString(this.instructions[i]));
            if (newWidth <= this.instructionBoxWidth) continue;
            this.instructionBoxWidth = newWidth;
        }
        this.instructionBoxWidth += this.fr.func_78256_a("1: ") + 10;
        Math.max(5, this.field_146294_l / 2 - (this.axisBoxWidth + this.instructionBoxWidth + this.boxSpacing) / 2);
        this.buttonYStart_bottom = this.field_146295_m - 20;
        int xPos = this.field_146294_l / 2 - this.bottomButtonWidth / 2;
        GuiButton doneButton = new GuiButton(500, xPos, this.buttonYStart_bottom, this.bottomButtonWidth, 20, "gui.done");
        if (this.joypadIndex != -1 && Controllers.getController((int)this.joypadIndex).getAxisCount() > 0) {
            int listStartY = (this.instructions.length + 3) * this.fr.field_78288_b + 20;
            int entryHeight = 32;
            this.calibrationList = new JoypadCalibrationList(Minecraft.func_71410_x(), this.field_146294_l, this.field_146295_m, listStartY, this.field_146295_m - 25, 0, entryHeight, this.joypadIndex, this);
            this.field_146292_n.add(new GuiButton(400, xPos -= this.bottomButtonWidth / 2, this.buttonYStart_bottom, this.bottomButtonWidth, 20, McObfuscationHelper.lookupString("calibrationMenu.save")));
            xPos += this.bottomButtonWidth;
            doneButton.field_146128_h += this.bottomButtonWidth / 2;
            doneButton.field_146126_j = McObfuscationHelper.lookupString("gui.cancel");
        }
        this.field_146292_n.add(doneButton);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        if (this.calibrationList == null) {
            return;
        }
        for (GuiButton guiButton : this.calibrationList.buttonList) {
            if (!guiButton.func_146116_c(Minecraft.func_71410_x(), par1, par2)) continue;
            this.calibrationList.actionPerformed(guiButton);
            break;
        }
    }

    protected void func_146284_a(GuiButton guiButton) {
        LogHelper.Info("Action performed on buttonID " + guiButton.field_146127_k);
        switch (guiButton.field_146127_k) {
            case 400: {
                ControllerSettings.saveDeadZones(this.joypadIndex);
                ((GuiButton)this.field_146292_n.get((int)1)).field_146126_j = McObfuscationHelper.lookupString("gui.done");
                break;
            }
            case 500: {
                this.field_146297_k.func_147108_a(this.parent);
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        if (this.calibrationList != null) {
            this.calibrationList.drawScreen(par1, par2, par3);
        }
        int ySpace = this.fr.field_78288_b;
        String title = McObfuscationHelper.lookupString("controlMenu.calibrate");
        Controller controller = null;
        if (this.joypadIndex != -1) {
            controller = Controllers.getController((int)this.joypadIndex);
            title = title + " - " + controller.getName();
        }
        this.write(this.yStart, this.fr.func_78269_a(title, this.field_146294_l - 2));
        if (this.joypadIndex == -1) {
            this.write(this.yStart + ySpace * 2, McObfuscationHelper.lookupString("controlMenu.noControllers"));
        } else if (Controllers.getController((int)this.joypadIndex).getAxisCount() <= 0) {
            this.write(this.yStart + ySpace * 2, McObfuscationHelper.lookupString("controlMenu.axis") + "# 0!");
        } else {
            int yPos = this.yStart + ySpace * 2 + 2;
            this.drawInstructions(this.field_146294_l / 2 - this.instructionBoxWidth / 2, yPos, ySpace, this.instructionBoxWidth);
        }
        super.func_73863_a(par1, par2, par3);
    }

    public void drawBoxWithText(int xStart, int yStart, int xEnd, int yEnd, String title, int boxColor, int textColor) {
        boxColor = -1;
        textColor = 0xFFAA00;
        int stringWidth = this.fr.func_78256_a(title);
        int xPos = xStart + (xEnd - xStart) / 2 - stringWidth / 2;
        this.func_73730_a(xStart, xPos, yStart, boxColor);
        int yTitleOffset = this.fr.field_78288_b / 2 + (this.fr.func_82883_a() ? 1 : -1);
        this.write(xPos + 2, yStart - yTitleOffset, title, textColor);
        this.func_73730_a(xPos += stringWidth + 2, xEnd, yStart, boxColor);
        this.func_73728_b(xStart, yStart, yEnd, boxColor);
        this.func_73730_a(xStart, xEnd, yEnd, boxColor);
        this.func_73728_b(xEnd, yStart, yEnd, boxColor);
    }

    private int[] drawInstructions(int xStart, int yStart, int ySpace, int totalWidth) {
        int yPos = yStart;
        String title = McObfuscationHelper.lookupString("calibrationMenu.instructionsTitle");
        int yEnd = yStart + (this.instructions.length + 1) * ySpace;
        this.drawBoxWithText(xStart, yStart, xStart + totalWidth, yEnd, title, 0xAA0000, 170);
        yPos += 7;
        xStart += 5;
        int i = 0;
        while (i < this.instructions.length) {
            String text = String.format("%s: %s", i + 1, McObfuscationHelper.lookupString(this.instructions[i]));
            int strWidth = this.fr.func_78256_a(text);
            this.write((totalWidth - 5) / 2 + xStart - strWidth / 2, yPos, text);
            ++i;
            yPos += ySpace;
        }
        return new int[]{xStart + totalWidth, yEnd};
    }

    private void write(int yPos, String text) {
        this.write(yPos, text, -1);
    }

    private void write(int yPos, String text, int fontColor) {
        this.func_73732_a(this.fr, text, this.field_146294_l / 2, yPos, fontColor);
    }

    public void write(int xPos, int yPos, String text) {
        this.write(xPos, yPos, text, -1);
    }

    public void write(int xPos, int yPos, String text, int fontColor) {
        this.func_73731_b(this.fr, text, xPos, yPos, fontColor);
    }

    public void func_73730_a(int par1, int par2, int par3, int par4) {
        super.func_73730_a(par1, par2, par3, par4);
    }

    public void func_73728_b(int par1, int par2, int par3, int par4) {
        super.func_73728_b(par1, par2, par3, par4);
    }

    private void readLastControllerEvent() {
        try {
            Controller controller = Controllers.getController((int)this.joypadIndex);
            while (Controllers.next() && Controllers.getEventSource() == controller) {
                if (Controllers.isEventAxis()) {
                    this.lastControllerEvent = controller.getAxisName(Controllers.getEventControlIndex());
                    continue;
                }
                if (Controllers.isEventButton()) {
                    this.lastControllerEvent = controller.getButtonName(Controllers.getEventControlIndex());
                    continue;
                }
                if (Controllers.isEventPovX()) {
                    this.lastControllerEvent = "PovX";
                    continue;
                }
                if (Controllers.isEventPovY()) {
                    this.lastControllerEvent = "PovY";
                    continue;
                }
                this.lastControllerEvent = "Unknown controller event with index: " + Controllers.getEventControlIndex();
            }
        }
        catch (Exception ex) {
            this.lastControllerEvent = ex.toString();
        }
    }

    private int[] drawButtons(int xStart, int yStart, int ySpace) {
        Controller controller = Controllers.getController((int)this.joypadIndex);
        int yPos = yStart;
        int maxButtons = 13;
        int butWidth = this.buttonBoxWidth;
        int numStrings = Math.min(controller.getButtonCount(), maxButtons);
        String title = "Buttons";
        int yEnd = yStart + (numStrings + 3) * ySpace;
        this.drawBoxWithText(xStart, yStart, xStart + butWidth, yEnd, title, 0xAA0000, 170);
        yPos += 7;
        xStart += 7;
        int i = 0;
        while (i < numStrings) {
            int maxSize = this.fr.func_78256_a(title + " 10");
            String stringOut = this.fr.func_78269_a(controller.getButtonName(i), maxSize);
            String output = stringOut + ": " + (controller.isButtonPressed(i) ? "Pressed" : "Not pressed");
            this.write(xStart, yPos, output);
            ++i;
            yPos += ySpace;
        }
        this.drawPov(xStart, yPos, ySpace);
        return new int[]{xStart + butWidth, yEnd};
    }

    private int[] drawPov(int xStart, int yStart, int ySpace) {
        Controller controller = Controllers.getController((int)this.joypadIndex);
        int yPos = yStart;
        int butWidth = this.povBoxWidth;
        int numStrings = 2;
        int yEnd = yStart + (numStrings + 1) * ySpace;
        int i = 0;
        while (i < numStrings) {
            String output = i == 0 ? "PovX: " + controller.getPovX() : "PovY: " + controller.getPovY();
            this.write(xStart, yPos, output);
            ++i;
            yPos += ySpace;
        }
        return new int[]{xStart + butWidth, yEnd};
    }
}

