/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.minecraftExtensions;

import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McObfuscationHelper;
import com.shiny.joypadmod.inputevent.ControllerUtils;
import com.shiny.joypadmod.minecraftExtensions.JoypadCalibrationMenu;
import cpw.mods.fml.client.GuiScrollingList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Mouse;

public class JoypadCalibrationList
extends GuiScrollingList {
    private Minecraft mc;
    private int width;
    private int entryHeight;
    private int joypadIndex;
    private JoypadCalibrationMenu parent;
    public List<GuiButton> buttonList = new ArrayList<GuiButton>();

    public JoypadCalibrationList(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, int joypadIndex, JoypadCalibrationMenu parent) {
        super(client, width, height, top, bottom, left, entryHeight);
        this.mc = Minecraft.func_71410_x();
        this.width = width;
        this.entryHeight = entryHeight;
        this.joypadIndex = joypadIndex;
        this.parent = parent;
    }

    protected int getSize() {
        int theHeight;
        int ret = Controllers.getController((int)this.joypadIndex).getAxisCount();
        if (ret > 0 && ret * this.entryHeight < (theHeight = this.bottom - this.top)) {
            ret = (int)Math.floor(theHeight / this.entryHeight);
        }
        return Math.max(Controllers.getController((int)this.joypadIndex).getAxisCount(), ret);
    }

    protected void elementClicked(int index, boolean doubleClick) {
    }

    protected boolean isSelected(int index) {
        return false;
    }

    protected void drawBackground() {
    }

    public void actionPerformed(GuiButton guiButton) {
        Controller controller;
        int axisId = guiButton.field_146127_k;
        LogHelper.Info("Action performed on buttonID " + axisId);
        Controller controller2 = controller = this.joypadIndex != -1 ? Controllers.getController((int)this.joypadIndex) : null;
        if (guiButton.field_146127_k < 100) {
            ControllerUtils.autoCalibrateAxis(this.joypadIndex, axisId);
        } else if (guiButton.field_146127_k >= 100 && guiButton.field_146127_k < 200) {
            controller.setDeadZone(axisId -= 100, controller.getDeadZone(axisId) - 0.01f);
        } else if (guiButton.field_146127_k >= 200 && guiButton.field_146127_k < 300) {
            controller.setDeadZone(axisId -= 200, 0.0f);
        } else if (guiButton.field_146127_k >= 300 && guiButton.field_146127_k < 400) {
            controller.setDeadZone(axisId -= 300, controller.getDeadZone(axisId) + 0.01f);
        }
    }

    protected void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5) {
        ScaledResolution scaledResolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int k = Mouse.getX() * scaledResolution.func_78326_a() / this.mc.field_71443_c;
        int i1 = scaledResolution.func_78328_b() - Mouse.getY() * scaledResolution.func_78328_b() / this.mc.field_71440_d - 1;
        if (var1 < Controllers.getController((int)this.joypadIndex).getAxisCount()) {
            int totalWidth = this.parent.axisBoxWidth;
            this.drawAxis(var1, this.width / 2 - totalWidth / 2, var3 + 2, 21, k, i1, totalWidth);
            for (int i = 4 * var1; i < 4 * var1 + 4; ++i) {
                if (this.buttonList.size() <= i) continue;
                this.buttonList.get((int)i).field_146129_i = var3 + 5;
                this.buttonList.get(i).func_146112_a(Minecraft.func_71410_x(), k, i1);
            }
        }
    }

    private int[] drawAxis(int axisNum, int xStart, int yStart, int ySpace, int par1, int par2, int totalWidth) {
        Controller controller = Controllers.getController((int)this.joypadIndex);
        int yPos = yStart;
        DecimalFormat df = new DecimalFormat("#0.00");
        int autoButtonWidth = this.mc.field_71466_p.func_78256_a(McObfuscationHelper.lookupString("calibrationMenu.auto")) + 10;
        int resetButtonWidth = this.mc.field_71466_p.func_78256_a(McObfuscationHelper.lookupString("controls.reset")) + 10;
        int directionButWidth = 15;
        int maxSize = this.parent.fr.func_78256_a("X Axis:");
        String title = this.parent.fr.func_78269_a(controller.getAxisName(axisNum), maxSize);
        this.parent.drawBoxWithText(xStart, yPos, xStart + totalWidth, yPos + 25, title, 0xAA0000, 170);
        int xPos = xStart + 5;
        String output = title + ": " + df.format(controller.getAxisValue(axisNum));
        this.parent.write(xPos, yPos += 10, output);
        output = McObfuscationHelper.lookupString("calibrationMenu.deadzone") + ": " + df.format(controller.getDeadZone(axisNum));
        this.parent.write(xPos += maxSize + this.parent.fr.func_78256_a(" -1.00") + 4, yPos, output);
        xPos += this.parent.fr.func_78256_a(output) + 5;
        int xPos2 = xStart + totalWidth - directionButWidth;
        int yOffset = -7;
        int xOffset = 2;
        if (this.buttonList.size() <= 4 * axisNum) {
            this.buttonList.add(new GuiButton(axisNum + 300, xPos2, yPos + yOffset, directionButWidth, 20, ">"));
            this.buttonList.add(new GuiButton(axisNum + 200, xPos2 -= resetButtonWidth - xOffset, yPos + yOffset, resetButtonWidth, 20, McObfuscationHelper.lookupString("controls.reset")));
            this.buttonList.add(new GuiButton(axisNum + 100, xPos2 -= directionButWidth - xOffset, yPos + yOffset, directionButWidth, 20, "<"));
            this.buttonList.add(new GuiButton(axisNum, xPos2 -= autoButtonWidth - xOffset, yPos + yOffset, autoButtonWidth, 20, McObfuscationHelper.lookupString("calibrationMenu.auto")));
        }
        return new int[]{xStart + totalWidth, yPos};
    }
}

