/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.inputevent;

import com.shiny.joypadmod.inputevent.ControllerInputEvent;
import org.lwjgl.input.Controllers;

public class ButtonInputEvent
extends ControllerInputEvent {
    public ButtonInputEvent(int controllerNumber, int buttonNumber, float threshold) {
        super(ControllerInputEvent.EventType.BUTTON, controllerNumber, buttonNumber, threshold, 0.0f);
    }

    @Override
    protected boolean isTargetEvent() {
        return Controllers.isEventButton() && Controllers.getEventControlIndex() == this.buttonNumber;
    }

    @Override
    public float getAnalogReading() {
        if (Controllers.getController((int)this.controllerNumber).isButtonPressed(this.buttonNumber)) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public String getName() {
        if (!this.isValid()) {
            return "NONE";
        }
        return Controllers.getController((int)this.controllerNumber).getButtonName(this.buttonNumber);
    }

    public String toString() {
        return "Event: " + this.getName() + " Type: " + (Object)((Object)this.getEventType()) + " Current value: " + this.getAnalogReading() + " Is pressed: " + this.isPressed();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public boolean isValid() {
        return this.controllerNumber >= 0 && this.buttonNumber >= 0 && this.buttonNumber < Controllers.getController((int)this.controllerNumber).getButtonCount();
    }
}

