/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.helpers;

import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McObfuscationHelper;
import com.shiny.joypadmod.helpers.ModVersionHelper;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.Timer;

public class McGuiHelper {
    private static Method mouseClicked = null;
    private static Method mouseMovedOrUp = null;
    private static Method mouseButtonMove = null;
    private static Method clickLeftMouse = null;
    private static Method sendClickBlockToController = null;
    private static Minecraft mc = Minecraft.func_71410_x();
    private static final String[] eventButtonNames = McObfuscationHelper.getMcVarNames("eventButton");
    private static final String[] lastMouseEventNames = McObfuscationHelper.getMcVarNames("lastMouseEvent");
    private static boolean created = false;

    public static void create() throws Exception {
        Class[] classArray;
        Class[] params4;
        Class[] classArray2;
        LogHelper.Info("Creating McGuiHelper");
        String[] names = McObfuscationHelper.getMcVarNames("mouseClicked");
        String[] names2 = McObfuscationHelper.getMcVarNames("mouseMovedOrUp");
        String[] names3 = McObfuscationHelper.getMcVarNames("mouseClickMove");
        String[] names4 = McObfuscationHelper.getMcVarNames(ModVersionHelper.getVersion() == 164 ? "clickMouse" : "leftClick");
        String[] names5 = McObfuscationHelper.getMcVarNames("sendClickBlockToController");
        Class[] params = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
        Class[] params2 = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
        Class[] params3 = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE};
        if (ModVersionHelper.getVersion() == 164) {
            Class[] classArray3 = new Class[1];
            classArray2 = classArray3;
            classArray3[0] = Integer.TYPE;
        } else {
            classArray2 = params4 = null;
        }
        if (ModVersionHelper.getVersion() == 164) {
            Class[] classArray4 = new Class[2];
            classArray4[0] = Integer.TYPE;
            classArray = classArray4;
            classArray4[1] = Boolean.TYPE;
        } else {
            Class[] classArray5 = new Class[1];
            classArray = classArray5;
            classArray5[0] = Boolean.TYPE;
        }
        Class[] params5 = classArray;
        mouseClicked = McGuiHelper.tryGetMethod(GuiScreen.class, params, names);
        mouseMovedOrUp = McGuiHelper.tryGetMethod(GuiScreen.class, params2, names2);
        mouseButtonMove = McGuiHelper.tryGetMethod(GuiScreen.class, params3, names3);
        clickLeftMouse = McGuiHelper.tryGetMethod(Minecraft.class, params4, names4);
        sendClickBlockToController = McGuiHelper.tryGetMethod(Minecraft.class, params5, names5);
        created = true;
    }

    private static Method tryGetMethod(Class<?> inClass, Class[] params, String[] names) throws NoSuchMethodException, SecurityException {
        Method m;
        try {
            m = inClass.getDeclaredMethod(names[0], params);
        }
        catch (Exception ex) {
            m = inClass.getDeclaredMethod(names[1], params);
        }
        m.setAccessible(true);
        return m;
    }

    public static boolean isCreated() {
        return created;
    }

    public static void guiMouseDown(int rawX, int rawY, int button) {
        if (!McGuiHelper.checkCreated()) {
            return;
        }
        LogHelper.Debug("Calling mouseClicked");
        try {
            ObfuscationReflectionHelper.setPrivateValue(GuiScreen.class, (Object)McGuiHelper.mc.field_71462_r, (Object)button, (String[])new String[]{eventButtonNames[0], eventButtonNames[1]});
            ObfuscationReflectionHelper.setPrivateValue(GuiScreen.class, (Object)McGuiHelper.mc.field_71462_r, (Object)Minecraft.func_71386_F(), (String[])new String[]{lastMouseEventNames[0], lastMouseEventNames[1]});
            mouseClicked.invoke((Object)McGuiHelper.mc.field_71462_r, rawX, rawY, button);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void guiMouseUp(int rawX, int rawY, int button) {
        if (!McGuiHelper.checkCreated()) {
            return;
        }
        LogHelper.Debug("Calling mouseUp");
        try {
            mouseMovedOrUp.invoke((Object)McGuiHelper.mc.field_71462_r, rawX, rawY, button);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void guiMouseDrag(int rawX, int rawY) {
        if (!McGuiHelper.checkCreated()) {
            return;
        }
        long lastEvent = -1L;
        int eventButton = -1;
        try {
            eventButton = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)McGuiHelper.mc.field_71462_r, (String[])new String[]{eventButtonNames[0], eventButtonNames[1]});
            lastEvent = (Long)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)McGuiHelper.mc.field_71462_r, (String[])new String[]{lastMouseEventNames[0], lastMouseEventNames[1]});
        }
        catch (Exception ex) {
            LogHelper.Error("Failed calling ObfuscationReflectionHelper" + ex.toString());
            if (lastEvent == -1L) {
                lastEvent = 100L;
            }
            eventButton = 0;
        }
        long var3 = Minecraft.func_71386_F() - lastEvent;
        try {
            mouseButtonMove.invoke((Object)McGuiHelper.mc.field_71462_r, rawX, rawY, eventButton, var3);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void gameLeftClick() {
        if (!McGuiHelper.checkCreated()) {
            return;
        }
        try {
            if (ModVersionHelper.getVersion() == 164) {
                clickLeftMouse.invoke((Object)mc, 0);
            } else {
                clickLeftMouse.invoke((Object)mc, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void gameSendClickBlockToController(int i, boolean b) {
        if (!McGuiHelper.checkCreated()) {
            return;
        }
        try {
            if (ModVersionHelper.getVersion() == 164) {
                sendClickBlockToController.invoke((Object)mc, i, b);
            } else {
                sendClickBlockToController.invoke((Object)mc, b);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Timer getMcTimer() {
        try {
            Field timer = Minecraft.class.getDeclaredField("timer");
            timer.setAccessible(true);
            return (Timer)timer.get(mc);
        }
        catch (Exception ex) {
            LogHelper.Error("Failed getting timer" + ex.toString());
            return null;
        }
    }

    private static boolean checkCreated() {
        if (!created) {
            LogHelper.Error("Unable to use McGuiHelper because it failed to initialize");
        }
        return created;
    }
}

