/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod;

import com.shiny.joypadmod.JoypadMouse;
import com.shiny.joypadmod.helpers.ConfigFile;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McKeyBindHelper;
import com.shiny.joypadmod.helpers.McObfuscationHelper;
import com.shiny.joypadmod.inputevent.AxisInputEvent;
import com.shiny.joypadmod.inputevent.ButtonInputEvent;
import com.shiny.joypadmod.inputevent.ControllerBinding;
import com.shiny.joypadmod.inputevent.ControllerUtils;
import com.shiny.joypadmod.lwjglVirtualInput.VirtualMouse;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;

public class ControllerSettings {
    public static final float defaultAxisDeadZone = 0.2f;
    public static final float defaultAxisThreshhold = 0.7f;
    public static final float defaultPovThreshhold = 0.9f;
    public static List<ControllerBinding> userDefinedBindings;
    public static Map<String, ControllerBinding> joyBindingsMap;
    public static boolean useConstantCameraMovement;
    public static boolean displayHints;
    public static int joyNo;
    public static int inGameSensitivity;
    public static int inMenuSensitivity;
    public static int scrollDelay;
    public static int loggingLevel;
    private static int requiredMinButtonCount;
    private static int requiredButtonCount;
    private static int requiredAxisCount;
    private static Map<String, List<Integer>> validControllers;
    private static Map<String, List<Integer>> inValidControllers;
    public static ControllerUtils controllerUtils;
    public static boolean modDisabled;
    private static boolean inputEnabled;
    private static boolean suspendControllerInput;
    public static boolean invertYAxis;
    public static boolean grabMouse;
    private static ConfigFile config;
    private static int currentDisplayedMap;
    private static long suspendMax;
    private static long suspendStart;
    private static Iterator<Map.Entry<String, ControllerBinding>> gameBindIterator;
    private static Iterator<Map.Entry<String, ControllerBinding>> menuBindIterator;

    public ControllerSettings(File configFile) {
        config = new ConfigFile(configFile);
        config.init();
        controllerUtils = new ControllerUtils();
        validControllers = new HashMap<String, List<Integer>>();
        inValidControllers = new HashMap<String, List<Integer>>();
        joyBindingsMap = new HashMap<String, ControllerBinding>();
        userDefinedBindings = new ArrayList<ControllerBinding>();
        grabMouse = ControllerSettings.getGameOption("-Global-.GrabMouse").equals("true");
        try {
            Controllers.create();
        }
        catch (Exception ex) {
            LogHelper.Error("Failed creating controller object. " + ex.toString());
        }
    }

    public static void setDefaultJoyBindingMap(int joyIndex, boolean updateWithConfigFile) {
        if (currentDisplayedMap == joyIndex) {
            LogHelper.Info("Skipping setting up the joybinding map as it is already set up for this joypad");
            return;
        }
        currentDisplayedMap = joyIndex;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        LogHelper.Info("Setting default joy binding map");
        joyBindingsMap.clear();
        int yAxisIndex = ControllerUtils.findYAxisIndex(joyIndex);
        int xAxisIndex = ControllerUtils.findXAxisIndex(joyIndex);
        joyBindingsMap.put("joy.jump", new ControllerBinding("joy.jump", "Jump", new ButtonInputEvent(joyIndex, 0, 1.0f), new int[]{McObfuscationHelper.keyCode(settings.field_74314_A)}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_MOVEMENT)));
        joyBindingsMap.put("joy.inventory", new ControllerBinding("joy.inventory", "Open inventory", new ButtonInputEvent(joyIndex, 3, 1.0f), new int[]{McObfuscationHelper.keyCode(settings.field_151445_Q)}, 100L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.CATEGORY_INVENTORY)));
        joyBindingsMap.put("joy.drop", new ControllerBinding("joy.drop", "Drop", new ButtonInputEvent(joyIndex, 6, 1.0f), new int[]{McObfuscationHelper.keyCode(settings.field_74316_C)}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.sneak", new ControllerBinding("joy.sneak", "Sneak", new ButtonInputEvent(joyIndex, 8, 1.0f), new int[]{McObfuscationHelper.keyCode(settings.field_74311_E)}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_MOVEMENT)));
        joyBindingsMap.put("joy.attack", new ControllerBinding("joy.attack", "Attack", new AxisInputEvent(joyIndex, 4, -0.7f, 0.2f), new int[]{-100}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.use", new ControllerBinding("joy.use", "Use", new AxisInputEvent(joyIndex, 4, 0.7f, 0.2f), new int[]{-99}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.interact", new ControllerBinding("joy.interact", "Interact", new ButtonInputEvent(joyIndex, 2, 1.0f), new int[]{-99}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.guiLeftClick", new ControllerBinding("joy.guiLeftClick", "Left click", new ButtonInputEvent(joyIndex, 0, 1.0f), new int[]{-100}, 0L, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.CATEGORY_UI)));
        joyBindingsMap.put("joy.guiRightClick", new ControllerBinding("joy.guiRightClick", "Right click", new ButtonInputEvent(joyIndex, 2, 1.0f), new int[]{-99}, 0L, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.CATEGORY_UI)));
        joyBindingsMap.put("joy.prevItem", new ControllerBinding("joy.prevItem", "Previous item", new ButtonInputEvent(joyIndex, 4, 1.0f), new int[]{-199}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.nextItem", new ControllerBinding("joy.nextItem", "Next item", new ButtonInputEvent(joyIndex, 5, 1.0f), new int[]{-201}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.sprint", new ControllerBinding("joy.sprint", "Sprint", new ButtonInputEvent(joyIndex, 9, 1.0f), new int[]{29}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.menu", new ControllerBinding("joy.menu", "Open menu", new ButtonInputEvent(joyIndex, 7, 1.0f), new int[]{1}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.CATEGORY_MISC)));
        joyBindingsMap.put("joy.shiftClick", new ControllerBinding("joy.shiftClick", "Shift-click", new ButtonInputEvent(joyIndex, 1, 1.0f), new int[]{42, -100}, 0L, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_INVENTORY)));
        joyBindingsMap.put("joy.cameraX+", new ControllerBinding("joy.cameraX+", "Look right", new AxisInputEvent(joyIndex, xAxisIndex + 2, 0.7f, 0.2f), null, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.cameraX-", new ControllerBinding("joy.cameraX-", "Look left", new AxisInputEvent(joyIndex, xAxisIndex + 2, -0.7f, 0.2f), null, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.cameraY-", new ControllerBinding("joy.cameraY-", "Look up", new AxisInputEvent(joyIndex, xAxisIndex + 1, -0.7f, 0.2f), null, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.cameraY+", new ControllerBinding("joy.cameraY+", "Look down", new AxisInputEvent(joyIndex, xAxisIndex + 1, 0.7f, 0.2f), null, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_GAMEPLAY)));
        joyBindingsMap.put("joy.right", new ControllerBinding("joy.right", "Strafe right", new AxisInputEvent(joyIndex, xAxisIndex, 0.7f, 0.2f), new int[]{McObfuscationHelper.keyCode(settings.field_74366_z)}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_MOVEMENT)));
        joyBindingsMap.put("joy.left", new ControllerBinding("joy.left", "Strafe left", new AxisInputEvent(joyIndex, xAxisIndex, -0.7f, 0.2f), new int[]{McObfuscationHelper.keyCode(settings.field_74370_x)}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_MOVEMENT)));
        joyBindingsMap.put("joy.back", new ControllerBinding("joy.back", "Move backward", new AxisInputEvent(joyIndex, yAxisIndex, 0.7f, 0.2f), new int[]{McObfuscationHelper.keyCode(settings.field_74368_y)}, yAxisIndex, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_MOVEMENT)));
        joyBindingsMap.put("joy.forward", new ControllerBinding("joy.forward", "Move forward", new AxisInputEvent(joyIndex, yAxisIndex, -0.7f, 0.2f), new int[]{McObfuscationHelper.keyCode(settings.field_74351_w)}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_MOVEMENT)));
        joyBindingsMap.put("joy.guiX+", new ControllerBinding("joy.guiX+", "GUI right", new AxisInputEvent(joyIndex, xAxisIndex, 0.7f, 0.2f), null, 0L, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_UI)));
        joyBindingsMap.put("joy.guiX-", new ControllerBinding("joy.guiX-", "GUI left", new AxisInputEvent(joyIndex, xAxisIndex, -0.7f, 0.2f), null, 0L, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_UI)));
        joyBindingsMap.put("joy.guiY+", new ControllerBinding("joy.guiY+", "GUI down", new AxisInputEvent(joyIndex, yAxisIndex, 0.7f, 0.2f), null, 0L, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_UI)));
        joyBindingsMap.put("joy.guiY-", new ControllerBinding("joy.guiY-", "GUI up", new AxisInputEvent(joyIndex, yAxisIndex, -0.7f, 0.2f), null, 0L, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.CATEGORY_UI)));
        joyBindingsMap.put("joy.closeInventory", new ControllerBinding("joy.closeInventory", "Close container", new ButtonInputEvent(joyIndex, 3, 1.0f), new int[]{McObfuscationHelper.keyCode(settings.field_151445_Q)}, 100L, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.CATEGORY_INVENTORY)));
        joyBindingsMap.put("joy.scrollDown", new ControllerBinding("joy.scrollDown", "Scroll down", new ButtonInputEvent(joyIndex, 5, 1.0f), new int[]{-201}, scrollDelay, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.RENDER_TICK, ControllerBinding.BindingOptions.CATEGORY_UI)));
        joyBindingsMap.put("joy.scrollUp", new ControllerBinding("joy.scrollUp", "Scroll up", new ButtonInputEvent(joyIndex, 4, 1.0f), new int[]{-199}, scrollDelay, EnumSet.of(ControllerBinding.BindingOptions.MENU_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.RENDER_TICK, ControllerBinding.BindingOptions.CATEGORY_UI)));
        if (updateWithConfigFile) {
            config.getJoypadSavedBindings(joyIndex, Controllers.getController((int)joyIndex).getName());
        }
        List<ControllerBinding> userBindings = config.getUserDefinedBindings(joyIndex);
        for (ControllerBinding b : userBindings) {
            joyBindingsMap.put(b.inputString, b);
        }
    }

    public static ControllerBinding get(String key) {
        return joyBindingsMap.get(key);
    }

    public static List<String> getBindingsWithCategory(String categoryString) {
        ArrayList<String> cList = new ArrayList<String>();
        for (Map.Entry<String, ControllerBinding> entry : joyBindingsMap.entrySet()) {
            if (entry.getValue().getCategoryString().compareTo(categoryString) != 0) continue;
            cList.add(entry.getValue().inputString);
        }
        return cList;
    }

    public static void delete(String key) {
        ControllerBinding binding = joyBindingsMap.get(key);
        if (binding != null) {
            if (binding.inputString.contains("user.")) {
                userDefinedBindings.remove(binding);
            }
            joyBindingsMap.remove(key);
            config.deleteUserBinding(binding);
        }
    }

    public static int bindingListSize() {
        return joyBindingsMap.size();
    }

    public void init() {
        LogHelper.Info("Minecraft Joypad (Controller) Mod v1.7.2 by Ljubomir Simin & Andrew Hickey\n---");
        if (ControllerSettings.config.preferedJoyName == "disabled") {
            LogHelper.Warn("Controller input disabled due to joypad value 'preferedJoyName' set to disabled");
            inputEnabled = false;
            modDisabled = true;
            return;
        }
        LogHelper.Info("Initializing Controllers");
        int nControllers = this.detectControllers();
        int selectedController = -1;
        if (nControllers > 0 && ControllerSettings.config.preferedJoyNo >= 0) {
            selectedController = this.checkForControllerAtIndex(ControllerSettings.config.preferedJoyName, ControllerSettings.config.preferedJoyNo);
            if (selectedController >= 0) {
                ControllerSettings.setController(selectedController);
                Controllers.clearEvents();
            } else {
                LogHelper.Info("No joypad set up for this session.  Must enter controller menu to enable");
            }
        }
        if (selectedController < 0) {
            LogHelper.Warn("No joypad set up for this session." + (nControllers > 0 ? " Must enter controller menu to enable." : ""));
            inputEnabled = false;
        }
    }

    private int detectControllers() {
        validControllers.clear();
        inValidControllers.clear();
        try {
            if (!Controllers.isCreated()) {
                Controllers.create();
            }
            if (Controllers.getControllerCount() > 0) {
                LogHelper.Info("Found " + Controllers.getControllerCount() + " controller(s) in total.");
                for (int joyIndex = 0; joyIndex < Controllers.getControllerCount(); ++joyIndex) {
                    Controller thisController = Controllers.getController((int)joyIndex);
                    this.logControllerInfo(thisController);
                    if (controllerUtils.meetsInputRequirements(thisController, requiredButtonCount, requiredMinButtonCount, requiredAxisCount)) {
                        LogHelper.Info("Controller #" + joyIndex + " ( " + thisController.getName() + ") meets the input requirements");
                        ControllerSettings.addControllerToList(validControllers, thisController.getName(), joyIndex);
                    } else {
                        LogHelper.Info("This controller does not meet the input requirements");
                        ControllerSettings.addControllerToList(inValidControllers, thisController.getName(), joyIndex);
                    }
                    LogHelper.Info("---");
                }
            }
        }
        catch (LWJGLException e) {
            System.err.println("Couldn't initialize Controllers: " + e.getMessage());
        }
        LogHelper.Info("Found " + validControllers.size() + " valid controllers!");
        return validControllers.size();
    }

    public static boolean setController(int controllerNo) {
        LogHelper.Info("Attempting to use controller " + controllerNo);
        try {
            if (!Controllers.isCreated()) {
                Controllers.create();
            }
            LogHelper.Info("Controllers.getControllerCount == " + Controllers.getControllerCount());
            if (controllerNo < 0 || controllerNo >= Controllers.getControllerCount()) {
                LogHelper.Error("Attempting to set controller index " + controllerNo + " there are currently " + Controllers.getControllerCount() + " controllers detected.");
                return false;
            }
            ControllerSettings.setDefaultJoyBindingMap(controllerNo, true);
            joyNo = controllerNo;
            controllerUtils.printDeadZones(Controllers.getController((int)controllerNo));
            inputEnabled = true;
            ControllerSettings.applySavedDeadZones(joyNo);
            config.updatePreferedJoy(controllerNo, Controllers.getController((int)controllerNo).getName());
            Minecraft.func_71410_x().field_71474_y.field_82881_y = false;
            JoypadMouse.AxisReader.centerCrosshairs();
            ControllerSettings.checkIfBindingsNeedUpdating();
            ControllerSettings.unpressAll();
            return true;
        }
        catch (Exception e) {
            LogHelper.Error("Couldn't initialize Controllers: " + e.toString());
            inputEnabled = false;
            return false;
        }
    }

    public static void resetBindings(int joyIndex) {
        if (joyIndex >= 0 && joyIndex < Controllers.getControllerCount()) {
            currentDisplayedMap = -1;
            ControllerSettings.setDefaultJoyBindingMap(joyIndex, false);
            for (Map.Entry<String, ControllerBinding> entry : joyBindingsMap.entrySet()) {
                if (entry.getKey().contains("user.")) continue;
                config.saveControllerBinding(Controllers.getController((int)joyIndex).getName(), entry.getValue());
            }
        }
        ControllerSettings.unpressAll();
    }

    public static boolean isInputEnabled() {
        return inputEnabled;
    }

    public static void setInputEnabled(int joyIndex, boolean b) {
        ControllerSettings.unpressAll();
        if (!b) {
            JoypadMouse.AxisReader.setXY(0, 0);
            VirtualMouse.setXY(0, 0);
            inputEnabled = false;
            config.updatePreferedJoy(-1, null);
            return;
        }
        if (joyNo != joyIndex) {
            ControllerSettings.setController(joyIndex);
            return;
        }
        inputEnabled = true;
        config.updatePreferedJoy(joyIndex, Controllers.getController((int)joyIndex).getName());
        JoypadMouse.AxisReader.centerCrosshairs();
    }

    public static void suspendControllerInput(boolean suspend, long maxTicksToSuspend) {
        if (suspend) {
            suspendStart = Minecraft.func_71386_F();
            suspendMax = maxTicksToSuspend;
        }
        suspendControllerInput = suspend;
        JoypadMouse.UnpressButtons();
    }

    public static boolean isSuspended() {
        if (suspendControllerInput && Minecraft.func_71386_F() - suspendStart > suspendMax) {
            suspendControllerInput = false;
        }
        return suspendControllerInput;
    }

    public static void setControllerBinding(int joyIndex, String bindingKey, ControllerBinding binding) {
        joyBindingsMap.put(bindingKey, binding);
        config.saveControllerBinding(Controllers.getController((int)joyIndex).getName(), binding);
    }

    public static void unsetControllerBinding(int joyIndex, String key) {
        ControllerBinding binding = joyBindingsMap.get(key);
        if (binding != null) {
            binding.inputEvent = new ButtonInputEvent(0, -1, 1.0f);
            config.saveControllerBinding(Controllers.getController((int)joyIndex).getName(), binding);
            ControllerSettings.unpressAll();
        }
    }

    public static void addUserBinding(ControllerBinding binding) {
        joyBindingsMap.put(binding.inputString, binding);
        userDefinedBindings.add(binding);
        config.saveControllerBinding(null, binding);
    }

    private static void addControllerToList(Map<String, List<Integer>> listToUse, String name, int id) {
        List<Object> ids = null;
        ids = listToUse.containsKey(name) ? listToUse.get(name) : new ArrayList();
        ids.add(id);
        listToUse.put(name, ids);
    }

    private int checkForControllerAtIndex(String controllerName, int joyIndex) {
        if (controllerName != null && validControllers.containsKey(controllerName)) {
            List<Integer> ids = validControllers.get(controllerName);
            if (ids.contains(joyIndex)) {
                return joyIndex;
            }
            return ids.get(0);
        }
        return -1;
    }

    private void logControllerInfo(Controller controller) {
        LogHelper.Info("Found controller " + controller.getName() + " (" + controller.getIndex() + ")");
        LogHelper.Info("It has  " + controller.getButtonCount() + " buttons.");
        LogHelper.Info("It has  " + controller.getAxisCount() + " axes.");
    }

    private static List<Integer> flattenMap(Map<String, List<Integer>> listToFlatten) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        Iterator<Map.Entry<String, List<Integer>>> it = listToFlatten.entrySet().iterator();
        while (it.hasNext()) {
            List<Integer> ids = it.next().getValue();
            for (int i = 0; i < ids.size(); ++i) {
                values.add(ids.get(i));
            }
        }
        Collections.sort(values);
        return values;
    }

    public static List<Integer> getJoypadList(boolean includeInvalid) {
        List<Integer> joypadList = ControllerSettings.flattenMap(validControllers);
        if (includeInvalid) {
            joypadList.addAll(ControllerSettings.flattenMap(inValidControllers));
        }
        return joypadList;
    }

    public static boolean getInvertYAxis() {
        return invertYAxis;
    }

    public static void setInvertYAxis(boolean b) {
        if (invertYAxis != b) {
            invertYAxis = b;
            config.updateConfigFileSetting(ConfigFile.UserJoypadSettings.InvertY, "" + b);
        }
    }

    public static void setToggle(int joyIndex, String bindingKey, boolean b) {
        ControllerBinding binding = joyBindingsMap.get(bindingKey);
        boolean changed = false;
        changed = b ? binding.bindingOptions.add(ControllerBinding.BindingOptions.IS_TOGGLE) : binding.bindingOptions.remove((Object)ControllerBinding.BindingOptions.IS_TOGGLE);
        if (changed) {
            ControllerSettings.setControllerBinding(joyIndex, bindingKey, binding);
        }
    }

    private static ControllerBinding getNextBinding(Iterator<Map.Entry<String, ControllerBinding>> current, ControllerBinding.BindingOptions target) {
        while (current.hasNext()) {
            Map.Entry<String, ControllerBinding> entry = current.next();
            if (!entry.getValue().bindingOptions.contains((Object)target) || !entry.getValue().inputEvent.isValid()) continue;
            return entry.getValue();
        }
        return null;
    }

    public static ControllerBinding getNextGameAutoBinding() {
        return ControllerSettings.getNextBinding(gameBindIterator, ControllerBinding.BindingOptions.GAME_BINDING);
    }

    public static ControllerBinding getNextMenuAutoBinding() {
        return ControllerSettings.getNextBinding(menuBindIterator, ControllerBinding.BindingOptions.MENU_BINDING);
    }

    public static ControllerBinding startGameBindIteration() {
        gameBindIterator = joyBindingsMap.entrySet().iterator();
        return ControllerSettings.getNextGameAutoBinding();
    }

    public static ControllerBinding startMenuBindIteration() {
        menuBindIterator = joyBindingsMap.entrySet().iterator();
        return ControllerSettings.getNextMenuAutoBinding();
    }

    public static void unpressAll() {
        for (Map.Entry<String, ControllerBinding> entry : joyBindingsMap.entrySet()) {
            if (!entry.getValue().bindingOptions.contains((Object)ControllerBinding.BindingOptions.IS_TOGGLE)) continue;
            entry.getValue().toggleState = false;
        }
        KeyBinding.func_74506_a();
        VirtualMouse.unpressAllButtons();
    }

    public static void saveSensitivityValues() {
        LogHelper.Info("Saving game sensitivity value: " + inGameSensitivity);
        config.updateConfigFileSetting(ConfigFile.UserJoypadSettings.GameSensitivity, "" + inGameSensitivity);
        LogHelper.Info("Saving menu sensitivity value: " + inMenuSensitivity);
        config.updateConfigFileSetting(ConfigFile.UserJoypadSettings.GuiSensitivity, "" + inMenuSensitivity);
    }

    public static void saveDeadZones(int joyId) {
        Controller controller = Controllers.getController((int)joyId);
        DecimalFormat df = new DecimalFormat("#0.00");
        for (int i = 0; i < controller.getAxisCount(); ++i) {
            config.setConfigFileSetting("-Deadzones-." + controller.getName(), controller.getAxisName(i), df.format(controller.getDeadZone(i)));
        }
        config.addComment("-Deadzones-", "Deadzone values here will override values in individual bindings");
        LogHelper.Info("Saved deadzones for " + controller.getName());
    }

    private static void saveCurrentJoyBindings() {
        String joyName = Controllers.getController((int)currentDisplayedMap).getName();
        for (Map.Entry<String, ControllerBinding> entry : joyBindingsMap.entrySet()) {
            config.saveControllerBinding(joyName, entry.getValue());
        }
    }

    public static void applySavedDeadZones(int joyId) {
        if (joyId < 0) {
            return;
        }
        LogHelper.Info("Applying configurated deadzones");
        config.applySavedDeadZones(Controllers.getController((int)joyId));
    }

    public static ControllerBinding findControllerBindingWithKey(int keyCode, ControllerBinding.BindingOptions option) {
        for (Map.Entry<String, ControllerBinding> entry : joyBindingsMap.entrySet()) {
            if (!entry.getValue().inputEvent.isValid() || entry.getValue().keyCodes == null || entry.getValue().bindingOptions == null || !entry.getValue().bindingOptions.contains((Object)option)) continue;
            for (int bindKeyCode : entry.getValue().keyCodes) {
                if (bindKeyCode != keyCode) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public static void checkIfBindingsNeedUpdating() {
        if (joyNo < 0) {
            return;
        }
        for (Map.Entry<String, ControllerBinding> entry : joyBindingsMap.entrySet()) {
            int keyCode;
            if (!entry.getValue().inputEvent.isValid() || entry.getValue().keyCodes == null || entry.getValue().keyCodes.length < 1 || entry.getKey().contains("user.")) continue;
            KeyBinding kb = McKeyBindHelper.getMinecraftKeyBind(entry.getKey());
            if (kb == null && entry.getKey().contains("joy.")) {
                kb = McKeyBindHelper.getMinecraftKeyBind(entry.getKey().replace("joy.", "key."));
            }
            if (kb == null || entry.getValue().keyCodes[0] == (keyCode = McObfuscationHelper.keyCode(kb))) continue;
            entry.getValue().keyCodes = new int[]{keyCode};
            ControllerSettings.setControllerBinding(joyNo, entry.getKey(), entry.getValue());
        }
    }

    public static boolean checkIfDuplicateBinding(String bindingKey) {
        ControllerBinding b = ControllerSettings.get(bindingKey);
        if (b == null || !b.inputEvent.isValid()) {
            return false;
        }
        for (Map.Entry<String, ControllerBinding> entry : joyBindingsMap.entrySet()) {
            if (!entry.getValue().inputEvent.isValid() || entry.getKey().equals(bindingKey) || !entry.getValue().inputEvent.equals(b.inputEvent) || (!b.bindingOptions.contains((Object)ControllerBinding.BindingOptions.GAME_BINDING) || !entry.getValue().bindingOptions.contains((Object)ControllerBinding.BindingOptions.GAME_BINDING)) && (!b.bindingOptions.contains((Object)ControllerBinding.BindingOptions.MENU_BINDING) || !entry.getValue().bindingOptions.contains((Object)ControllerBinding.BindingOptions.MENU_BINDING))) continue;
            return true;
        }
        return false;
    }

    public static String getGameOption(String optionKey) {
        return config.getConfigFileSetting(optionKey);
    }

    public static void setGameOption(String optionKey, String value) {
        config.setConfigFileSetting(optionKey, value);
        if (optionKey.contains("SharedProfile") && currentDisplayedMap != -1) {
            ControllerSettings.saveCurrentJoyBindings();
        } else if (optionKey.contains("GrabMouse")) {
            grabMouse = Boolean.parseBoolean(value);
        }
    }

    static {
        joyBindingsMap = null;
        useConstantCameraMovement = false;
        displayHints = false;
        joyNo = -1;
        inGameSensitivity = 25;
        inMenuSensitivity = 10;
        scrollDelay = 50;
        loggingLevel = 1;
        requiredMinButtonCount = 4;
        requiredButtonCount = 12;
        requiredAxisCount = 4;
        modDisabled = false;
        inputEnabled = false;
        suspendControllerInput = false;
        invertYAxis = false;
        grabMouse = false;
        config = null;
        currentDisplayedMap = -1;
    }
}

