/*
 * Decompiled with CFR 0.152.
 */
package darkknight.jewelrycraft;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import darkknight.jewelrycraft.CommonProxy;
import darkknight.jewelrycraft.CreativeTabLiquids;
import darkknight.jewelrycraft.CreativeTabNecklaces;
import darkknight.jewelrycraft.CreativeTabRings;
import darkknight.jewelrycraft.block.BlockList;
import darkknight.jewelrycraft.config.ConfigHandler;
import darkknight.jewelrycraft.container.GuiHandler;
import darkknight.jewelrycraft.events.BucketHandler;
import darkknight.jewelrycraft.events.EntityEventHandler;
import darkknight.jewelrycraft.item.ItemList;
import darkknight.jewelrycraft.recipes.CraftingRecipes;
import darkknight.jewelrycraft.util.JewelrycraftUtil;
import darkknight.jewelrycraft.worldGen.Generation;
import darkknight.jewelrycraft.worldGen.village.ComponentJewelry;
import darkknight.jewelrycraft.worldGen.village.JCTrades;
import darkknight.jewelrycraft.worldGen.village.VillageJewelryHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="Jewelrycraft", name="Jewelrycraft", version="1.4")
public class JewelrycraftMod {
    @Mod.Instance(value="Jewelrycraft")
    public static JewelrycraftMod instance;
    @Mod.Metadata(value="Jewelrycraft")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="darkknight.jewelrycraft.client.ClientProxy", serverSide="darkknight.jewelrycraft.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static CreativeTabs jewelrycraft;
    public static CreativeTabs rings;
    public static CreativeTabs necklaces;
    public static CreativeTabs liquids;
    public static File liquidsConf;
    public static NBTTagCompound saveData;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) throws IOException {
        ConfigHandler.preInit(e);
        BlockList.preInit(e);
        ItemList.preInit(e);
        CraftingRecipes.preInit(e);
        OreDictionary.registerOre((String)"ingotShadow", (ItemStack)new ItemStack(ItemList.shadowIngot));
        OreDictionary.registerOre((String)"oreShadow", (ItemStack)new ItemStack(BlockList.shadowOre));
        VillagerRegistry.instance().registerVillagerId(3000);
        VillagerRegistry.instance().registerVillageTradeHandler(3000, (VillagerRegistry.IVillageTradeHandler)new JCTrades());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageJewelryHandler());
        try {
            MapGenStructureIO.func_143031_a(ComponentJewelry.class, (String)"Jewelrycraft:Jewelry");
        }
        catch (Throwable e2) {
            logger.severe("Error registering Jewelrycraft Structures with Vanilla Minecraft: this is expected in versions earlier than 1.7.2");
        }
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.INSTANCE);
        BucketHandler.INSTANCE.buckets.put((Block)BlockList.moltenMetal, ItemList.bucket);
        proxy.registerRenderers();
        ModMetadata metadata = e.getModMetadata();
        ArrayList<String> authorList = new ArrayList<String>();
        authorList.add("DarkKnight (or sor1n)");
        authorList.add("bspkrs");
        metadata.autogenerated = false;
        metadata.authorList = authorList;
        metadata.url = "https://github.com/sor1n/Modjam-Mod";
        liquidsConf = new File(e.getModConfigurationDirectory(), "JLP.cfg");
        if (liquidsConf.exists() || !liquidsConf.createNewFile()) {
            // empty if block
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new Generation(), (int)0);
        new GuiHandler();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        JewelrycraftUtil.addMetals();
        JewelrycraftUtil.addStuff();
        JewelrycraftUtil.jamcrafters();
    }

    static {
        logger = Logger.getLogger("Jewelrycraft");
        jewelrycraft = new CreativeTabs("JewelryCraft"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)BlockList.jewelCraftingTable);
            }
        };
        rings = new CreativeTabRings("Rings");
        necklaces = new CreativeTabNecklaces("Necklaces");
        liquids = new CreativeTabLiquids("Liquids");
        saveData = new NBTTagCompound();
    }
}

