/*
 * Decompiled with CFR 0.152.
 */
package darkknight.jewelrycraft.util;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class JewelryNBT {
    public static void addMetal(ItemStack item, ItemStack metal) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound ingotNBT = new NBTTagCompound();
        metal.func_77955_b(ingotNBT);
        itemStackData.func_74782_a("ingot", (NBTBase)ingotNBT);
    }

    public static void addJewel(ItemStack item, ItemStack jewel) {
        if (jewel != null) {
            NBTTagCompound itemStackData;
            if (item.func_77942_o()) {
                itemStackData = item.func_77978_p();
            } else {
                itemStackData = new NBTTagCompound();
                item.func_77982_d(itemStackData);
            }
            NBTTagCompound jewelNBT = new NBTTagCompound();
            jewel.func_77955_b(jewelNBT);
            itemStackData.func_74782_a("jewel", (NBTBase)jewelNBT);
        }
    }

    public static void addModifier(ItemStack item, ItemStack modifier) {
        if (modifier != null) {
            NBTTagCompound itemStackData;
            if (item.func_77942_o()) {
                itemStackData = item.func_77978_p();
            } else {
                itemStackData = new NBTTagCompound();
                item.func_77982_d(itemStackData);
            }
            NBTTagCompound modifierNBT = new NBTTagCompound();
            modifier.func_77955_b(modifierNBT);
            itemStackData.func_74782_a("modifier", (NBTBase)modifierNBT);
        }
    }

    public static void addEntity(ItemStack item, EntityLivingBase entity) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound entityNBT = new NBTTagCompound();
        entity.func_70109_d(entityNBT);
        itemStackData.func_74782_a("entity", (NBTBase)entityNBT);
    }

    public static void addEntityID(ItemStack item, EntityLivingBase entity) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound entityNBT = new NBTTagCompound();
        int id = EntityList.func_75619_a((Entity)entity);
        entityNBT.func_74768_a("entityID", id);
        itemStackData.func_74782_a("entityID", (NBTBase)entityNBT);
    }

    public static void addCoordonates(ItemStack item, double x, double y, double z) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound coords = new NBTTagCompound();
        coords.func_74780_a("x", x);
        coords.func_74780_a("y", y);
        coords.func_74780_a("z", z);
        itemStackData.func_74782_a("x", (NBTBase)coords);
        itemStackData.func_74782_a("y", (NBTBase)coords);
        itemStackData.func_74782_a("z", (NBTBase)coords);
    }

    public static void addTileEntityBlock(ItemStack item, World world, int x, int y, int z) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound tileNBT = new NBTTagCompound();
        NBTTagCompound block = new NBTTagCompound();
        world.func_147438_o(x, y, z).func_145841_b(tileNBT);
        itemStackData.func_74782_a("tile", (NBTBase)tileNBT);
        block.func_74768_a("blockID", Block.func_149682_b((Block)world.func_147439_a(x, y, z)));
        block.func_74768_a("metadata", world.func_72805_g(x, y, z));
        block.func_74768_a("blockX", x);
        block.func_74768_a("blockY", y);
        block.func_74768_a("blockZ", z);
        itemStackData.func_74782_a("metadata", (NBTBase)block);
        itemStackData.func_74782_a("blockID", (NBTBase)block);
        itemStackData.func_74782_a("blockX", (NBTBase)block);
        itemStackData.func_74782_a("blockY", (NBTBase)block);
        itemStackData.func_74782_a("blockZ", (NBTBase)block);
    }

    public static void addBlock(ItemStack item, int block, int metadata) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound blockNBT = new NBTTagCompound();
        blockNBT.func_74768_a("blockID", block);
        itemStackData.func_74782_a("blockID", (NBTBase)blockNBT);
        blockNBT.func_74768_a("metadata", metadata);
        itemStackData.func_74782_a("metadata", (NBTBase)blockNBT);
    }

    public static void addBlockCoordonates(ItemStack item, int x, int y, int z) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound coords = new NBTTagCompound();
        coords.func_74768_a("blockX", x);
        coords.func_74768_a("blockY", y);
        coords.func_74768_a("blockZ", z);
        itemStackData.func_74782_a("blockX", (NBTBase)coords);
        itemStackData.func_74782_a("blockY", (NBTBase)coords);
        itemStackData.func_74782_a("blockZ", (NBTBase)coords);
    }

    public static void addCoordonatesAndDimension(ItemStack item, double x, double y, double z, int dim, String name) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound coords = new NBTTagCompound();
        coords.func_74780_a("x", x);
        coords.func_74780_a("y", y);
        coords.func_74780_a("z", z);
        coords.func_74768_a("dimension", dim);
        coords.func_74778_a("dimName", name);
        itemStackData.func_74782_a("x", (NBTBase)coords);
        itemStackData.func_74782_a("y", (NBTBase)coords);
        itemStackData.func_74782_a("z", (NBTBase)coords);
        itemStackData.func_74782_a("dimension", (NBTBase)coords);
        itemStackData.func_74782_a("dimName", (NBTBase)coords);
    }

    public static void addMode(ItemStack item, String modeN) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound mode = new NBTTagCompound();
        mode.func_74778_a("mode", modeN);
        itemStackData.func_74782_a("mode", (NBTBase)mode);
    }

    public static void addFakeEnchantment(ItemStack item) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        itemStackData.func_74782_a("ench", (NBTBase)new NBTTagList());
    }

    public static void addIngotColor(ItemStack item, int color) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound colors = new NBTTagCompound();
        colors.func_74768_a("ingotColor", color);
        itemStackData.func_74782_a("ingotColor", (NBTBase)colors);
    }

    public static void addJewelColor(ItemStack item, int color) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound colors = new NBTTagCompound();
        colors.func_74768_a("jewelColor", color);
        itemStackData.func_74782_a("jewelColor", (NBTBase)colors);
    }

    public static void addEntities(ItemStack item, List list) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        NBTTagCompound entityNBT = new NBTTagCompound();
        for (int i = 0; i < list.size(); ++i) {
            ((EntityLivingBase)list.get(i)).func_70109_d(entityNBT);
        }
        itemStackData.func_74782_a("entities", (NBTBase)entityNBT);
    }

    public static void removeNBT(ItemStack item, String tag) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        itemStackData.func_82580_o(tag);
    }

    public static void removeEntity(ItemStack item) {
        JewelryNBT.removeNBT(item, "entityID");
        JewelryNBT.removeNBT(item, "entity");
        JewelryNBT.removeNBT(item, "ench");
    }

    public static void removeBlock(ItemStack item) {
        JewelryNBT.removeNBT(item, "blockID");
        JewelryNBT.removeNBT(item, "metadata");
        JewelryNBT.removeNBT(item, "tile");
        JewelryNBT.removeNBT(item, "blockX");
        JewelryNBT.removeNBT(item, "blockY");
        JewelryNBT.removeNBT(item, "blockZ");
    }

    public static boolean hasTag(ItemStack item, String tag) {
        NBTTagCompound itemStackData;
        if (item.func_77942_o()) {
            itemStackData = item.func_77978_p();
        } else {
            itemStackData = new NBTTagCompound();
            item.func_77982_d(itemStackData);
        }
        return itemStackData.func_74764_b(tag);
    }

    public static boolean isJewelX(ItemStack stack, ItemStack jewel) {
        return JewelryNBT.jewel(stack) != null && JewelryNBT.jewel(stack).func_77973_b() == jewel.func_77973_b() && JewelryNBT.jewel(stack).func_77960_j() == jewel.func_77960_j();
    }

    public static boolean isModifierX(ItemStack stack, ItemStack modifier) {
        return JewelryNBT.modifier(stack) != null && JewelryNBT.modifier(stack).func_77973_b() == modifier.func_77973_b() && JewelryNBT.modifier(stack).func_77960_j() == modifier.func_77960_j();
    }

    public static boolean isModifierEffectType(ItemStack stack) {
        return JewelryNBT.modifier(stack) != null && (JewelryNBT.isModifierX(stack, new ItemStack(Items.field_151065_br)) || JewelryNBT.isModifierX(stack, new ItemStack(Items.field_151102_aT)) || JewelryNBT.isModifierX(stack, new ItemStack(Items.field_151035_b)) || JewelryNBT.isModifierX(stack, new ItemStack(Items.field_151008_G)) || JewelryNBT.isModifierX(stack, new ItemStack((Item)Items.field_151068_bn, 1, 8270)));
    }

    public static boolean isIngotX(ItemStack stack, ItemStack ingot) {
        return JewelryNBT.ingot(stack) != null && JewelryNBT.ingot(stack).func_77973_b() == ingot.func_77973_b() && JewelryNBT.ingot(stack).func_77960_j() == ingot.func_77960_j();
    }

    public static boolean isModeX(ItemStack stack, String modeN) {
        return JewelryNBT.modeName(stack) != null && JewelryNBT.modeName(stack).equals(modeN);
    }

    public static boolean isEntityX(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        return entity != null && entity instanceof EntityLivingBase && JewelryNBT.entity(stack, player) != null && JewelryNBT.entity(stack, player).equals((Object)entity);
    }

    public static boolean isDimNameX(ItemStack stack, String dimName) {
        return JewelryNBT.ingot(stack) != null && JewelryNBT.dimName(stack).equals(dimName);
    }

    public static boolean isDimensionX(ItemStack stack, int dimension) {
        return JewelryNBT.dimension(stack) != -2 && JewelryNBT.dimension(stack) == dimension;
    }

    public static ItemStack jewel(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("jewel")) {
            NBTTagCompound jewelNBT = (NBTTagCompound)stack.func_77978_p().func_74781_a("jewel");
            ItemStack jewel = new ItemStack(Item.func_150899_d((int)0), 0, 0);
            jewel.func_77963_c(jewelNBT);
            return jewel;
        }
        return null;
    }

    public static ItemStack modifier(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("modifier")) {
            NBTTagCompound modifierNBT = (NBTTagCompound)stack.func_77978_p().func_74781_a("modifier");
            ItemStack modifier = new ItemStack(Item.func_150899_d((int)0), 0, 0);
            modifier.func_77963_c(modifierNBT);
            return modifier;
        }
        return null;
    }

    public static ItemStack ingot(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("ingot")) {
            NBTTagCompound ingotNBT = (NBTTagCompound)stack.func_77978_p().func_74781_a("ingot");
            ItemStack ingot = new ItemStack(Item.func_150899_d((int)0), 0, 0);
            ingot.func_77963_c(ingotNBT);
            return ingot;
        }
        return null;
    }

    public static EntityLivingBase entity(ItemStack stack, EntityPlayer player) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("entityID") && stack.func_77978_p().func_74764_b("entity")) {
            NBTTagCompound enID = (NBTTagCompound)stack.func_77978_p().func_74781_a("entityID");
            NBTTagCompound en = (NBTTagCompound)stack.func_77978_p().func_74781_a("entity");
            int entityID = 0;
            entityID = enID.func_74762_e("entityID");
            EntityLivingBase entity = (EntityLivingBase)EntityList.func_75616_a((int)entityID, (World)player.field_70170_p);
            if (entity != null && entity instanceof EntityLivingBase) {
                entity.func_70020_e(en);
                return entity;
            }
            return null;
        }
        return null;
    }

    public static TileEntity tileEntity(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("tile")) {
            NBTTagCompound tileNBT = (NBTTagCompound)stack.func_77978_p().func_74781_a("tile");
            TileEntity tile = TileEntity.func_145827_c((NBTTagCompound)tileNBT);
            if (tile != null && tile instanceof TileEntity) {
                tile.func_145839_a(tileNBT);
                return tile;
            }
            return null;
        }
        return null;
    }

    public static String dimName(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("dimName")) {
            NBTTagCompound dim = (NBTTagCompound)stack.func_77978_p().func_74781_a("dimName");
            String name = dim.func_74779_i("dimName");
            return name;
        }
        return null;
    }

    public static String modeName(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("mode")) {
            NBTTagCompound dim = (NBTTagCompound)stack.func_77978_p().func_74781_a("mode");
            String name = dim.func_74779_i("mode");
            return name;
        }
        return null;
    }

    public static int dimension(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("dimension")) {
            NBTTagCompound dim = (NBTTagCompound)stack.func_77978_p().func_74781_a("dimension");
            int dimension = dim.func_74762_e("dimension");
            return dimension;
        }
        return -2;
    }

    public static int blockCoordX(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("blockX")) {
            NBTTagCompound x = (NBTTagCompound)stack.func_77978_p().func_74781_a("blockX");
            int posX = x.func_74762_e("blockX");
            return posX;
        }
        return -1;
    }

    public static int blockCoordY(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("blockY")) {
            NBTTagCompound y = (NBTTagCompound)stack.func_77978_p().func_74781_a("blockY");
            int posY = y.func_74762_e("blockY");
            return posY;
        }
        return -1;
    }

    public static int blockCoordZ(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("blockZ")) {
            NBTTagCompound z = (NBTTagCompound)stack.func_77978_p().func_74781_a("blockZ");
            int posZ = z.func_74762_e("blockZ");
            return posZ;
        }
        return -1;
    }

    public static int blockID(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("blockID")) {
            NBTTagCompound blockID = (NBTTagCompound)stack.func_77978_p().func_74781_a("blockID");
            int blockId = blockID.func_74762_e("blockID");
            return blockId;
        }
        return -1;
    }

    public static int blockMetadata(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("metadata")) {
            NBTTagCompound metadataNBT = (NBTTagCompound)stack.func_77978_p().func_74781_a("metadata");
            int metadata = metadataNBT.func_74762_e("metadata");
            return metadata;
        }
        return -1;
    }

    public static double playerPosX(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("x")) {
            NBTTagCompound x = (NBTTagCompound)stack.func_77978_p().func_74781_a("x");
            double posX = x.func_74769_h("x");
            return posX;
        }
        return -1.0;
    }

    public static double playerPosY(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("y")) {
            NBTTagCompound y = (NBTTagCompound)stack.func_77978_p().func_74781_a("y");
            double posY = y.func_74769_h("y");
            return posY;
        }
        return -1.0;
    }

    public static double playerPosZ(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("z")) {
            NBTTagCompound z = (NBTTagCompound)stack.func_77978_p().func_74781_a("z");
            double posZ = z.func_74769_h("z");
            return posZ;
        }
        return -1.0;
    }

    public static int ingotColor(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("ingotColor")) {
            NBTTagCompound colors = (NBTTagCompound)stack.func_77978_p().func_74781_a("ingotColor");
            int color = colors.func_74762_e("ingotColor");
            return color;
        }
        return 0xFFFFFF;
    }

    public static int jewelColor(ItemStack stack) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("jewelColor")) {
            NBTTagCompound colors = (NBTTagCompound)stack.func_77978_p().func_74781_a("jewelColor");
            int color = colors.func_74762_e("jewelColor");
            return color;
        }
        return 0xFFFFFF;
    }

    public static List entities(ItemStack stack, EntityPlayer player) {
        if (stack != null && stack != new ItemStack(Item.func_150899_d((int)0), 0, 0) && stack.func_77978_p().func_74764_b("entities")) {
            NBTTagCompound enID = (NBTTagCompound)stack.func_77978_p().func_74781_a("entitiesID");
            List list = null;
            int[] entityID = enID.func_74759_k("entitiesID");
            for (int i = 0; i < entityID.length; ++i) {
                EntityLivingBase entity = (EntityLivingBase)EntityList.func_75616_a((int)entityID[i], (World)player.field_70170_p);
                list.add(entity);
            }
            return list;
        }
        return null;
    }
}

