/*
 * Decompiled with CFR 0.152.
 */
package darkknight.jewelrycraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import darkknight.jewelrycraft.JewelrycraftMod;
import darkknight.jewelrycraft.block.BlockList;
import darkknight.jewelrycraft.util.JewelryNBT;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockMoltenMetal
extends BlockFluidClassic {
    @SideOnly(value=Side.CLIENT)
    protected IIcon stillIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon flowingIcon;

    public BlockMoltenMetal(Fluid fluid, Material material) {
        super(fluid, material);
        this.func_149663_c("Jewelrycraft.moltenMetal");
        this.setQuantaPerBlock(100);
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 0 || side == 1 ? this.stillIcon : this.flowingIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.stillIcon = register.func_94245_a("jewelrycraft:moltenMetalStill");
        this.flowingIcon = register.func_94245_a("jewelrycraft:moltenMetalFlow");
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    protected boolean canFlowInto(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).isAir(world, x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return (Boolean)this.displacements.get(block);
        }
        Material material = block.func_149688_o();
        if (material.func_76230_c() || material == Material.field_151586_h || material == Material.field_151587_i || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockMoltenMetal.getDensity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int i, int j, int k) {
        try {
            return BlockMoltenMetal.color(world, i, j, k, false, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int quantaRemaining = this.quantaPerBlock - world.func_72805_g(x, y, z);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int y2 = y - this.densityDir;
            if (world.func_147439_a(x, y2, z) == this && JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y2, z)) == JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z)) || world.func_147439_a(x - 1, y2, z) == this && JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x - 1, y2, z)) == JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z)) || world.func_147439_a(x + 1, y2, z) == this && JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x + 1, y2, z)) == JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z)) || world.func_147439_a(x, y2, z - 1) == this && JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y2, z - 1)) == JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z)) || world.func_147439_a(x, y2, z + 1) == this && JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y2, z + 1)) == JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z))) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x - 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x + 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                } else {
                    world.func_72921_c(x, y, z, this.quantaPerBlock - expQuanta, 3);
                    world.func_147464_a(x, y, z, (Block)this, this.tickRate);
                    world.func_147459_d(x, y, z, (Block)this);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (this.canDisplace((IBlockAccess)world, x, y + this.densityDir, z)) {
            JewelrycraftMod.saveData.func_74768_a(BlockMoltenMetal.coords(x, y + this.densityDir, z), JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z)));
            this.flowIntoBlock(world, x, y + this.densityDir, z, 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, x, y, z) || !this.isFlowingVertically((IBlockAccess)world, x, y, z)) {
            boolean[] flowTo;
            if (world.func_147439_a(x, y - this.densityDir, z) == this) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, x, y, z))[0]) {
                if (JewelrycraftMod.saveData.func_74781_a(BlockMoltenMetal.coords(x - 1, y, z)) == null || world.func_147439_a(x - 1, y, z).isAir((IBlockAccess)world, x - 1, y, z)) {
                    JewelrycraftMod.saveData.func_74768_a(BlockMoltenMetal.coords(x - 1, y, z), JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z)));
                }
                this.flowIntoBlock(world, x - 1, y, z, flowMeta);
            }
            if (flowTo[1]) {
                if (JewelrycraftMod.saveData.func_74781_a(BlockMoltenMetal.coords(x + 1, y, z)) == null || world.func_147439_a(x + 1, y, z).isAir((IBlockAccess)world, x + 1, y, z)) {
                    JewelrycraftMod.saveData.func_74768_a(BlockMoltenMetal.coords(x + 1, y, z), JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z)));
                }
                this.flowIntoBlock(world, x + 1, y, z, flowMeta);
            }
            if (flowTo[2]) {
                if (JewelrycraftMod.saveData.func_74781_a(BlockMoltenMetal.coords(x, y, z - 1)) == null || world.func_147439_a(x, y, z - 1).isAir((IBlockAccess)world, x, y, z - 1)) {
                    JewelrycraftMod.saveData.func_74768_a(BlockMoltenMetal.coords(x, y, z - 1), JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z)));
                }
                this.flowIntoBlock(world, x, y, z - 1, flowMeta);
            }
            if (flowTo[3]) {
                if (JewelrycraftMod.saveData.func_74781_a(BlockMoltenMetal.coords(x, y, z + 1)) == null || world.func_147439_a(x, y, z + 1).isAir((IBlockAccess)world, x, y, z + 1)) {
                    JewelrycraftMod.saveData.func_74768_a(BlockMoltenMetal.coords(x, y, z + 1), JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(x, y, z)));
                }
                this.flowIntoBlock(world, x, y, z + 1, flowMeta);
            }
        }
    }

    public static int color(IBlockAccess world, int i, int j, int k, boolean forcecolor, Item itemC) throws IOException {
        String domain = "";
        IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        ItemStack item = new ItemStack((Block)BlockList.moltenMetal);
        if (JewelrycraftMod.saveData.func_74762_e(String.valueOf(i) + " " + String.valueOf(j) + " " + String.valueOf(k)) > 0) {
            JewelryNBT.addMetal(item, new ItemStack(Item.func_150899_d((int)JewelrycraftMod.saveData.func_74762_e(BlockMoltenMetal.coords(i, j, k)))));
        }
        if (forcecolor) {
            JewelryNBT.addMetal(item, new ItemStack(itemC));
        }
        int x = 0;
        int y = 0;
        boolean ok = false;
        if (JewelryNBT.ingot(item) != null && JewelryNBT.ingot(item).func_77954_c() != null && JewelryNBT.ingotColor(item) == 0xFFFFFF) {
            String ingotIconName = JewelryNBT.ingot(item).func_77954_c().func_94215_i();
            domain = ingotIconName.substring(0, ingotIconName.indexOf(":") + 1) != "" ? ingotIconName.substring(0, ingotIconName.indexOf(":") + 1).replace(":", " ").trim() : "minecraft";
            String texture = ingotIconName.substring(ingotIconName.lastIndexOf(":") + 1) + ".png";
            ResourceLocation ingot = null;
            ingot = JewelryNBT.ingot(item).func_77977_a().contains("item") ? new ResourceLocation(domain, "textures/items/" + texture) : new ResourceLocation(domain, "textures/blocks/" + texture);
            BufferedImage icon = ImageIO.read(rm.func_110536_a(ingot).func_110527_b());
            while (!ok) {
                int red = icon.getRGB(x, y) >> 16 & 0xFF;
                int green = icon.getRGB(x, y) >> 8 & 0xFF;
                int blue = icon.getRGB(x, y) & 0xFF;
                if (red <= 80 && green <= 80 && blue <= 80 || red >= 180 && green >= 180 && blue >= 180) {
                    if (x < icon.getTileWidth() - 1) {
                        ++x;
                    }
                    if (x >= icon.getTileWidth() - 1 && y < icon.getTileWidth() - 1) {
                        x = 0;
                        ++y;
                    }
                    if (x != icon.getTileWidth() - 1 || y != icon.getTileWidth() - 1) continue;
                    ok = true;
                    continue;
                }
                ok = true;
            }
            JewelryNBT.addIngotColor(item, icon.getRGB(x, y));
        }
        if (JewelryNBT.ingot(item) != null) {
            return JewelryNBT.ingotColor(item);
        }
        return 0xFFFFFF;
    }

    public static String coords(int x, int y, int z) {
        return String.valueOf(x) + " " + String.valueOf(y) + " " + String.valueOf(z);
    }
}

