/*
 * Decompiled with CFR 0.152.
 */
package com.briman0094.itemsearch;

import com.briman0094.itemsearch.proxy.CommonProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="ItemSearch", name="Briman's Item Search", useMetadata=true, version="1.3")
public class ItemSearch {
    public static final String MOD_ID = "ItemSearch";
    public static final int DEF_MARKER_TIMEOUT = 90;
    public static final boolean DEF_RENDER_ICONS = true;
    public static final boolean DEF_RENDER_SEARCH = true;
    public static final int DEF_DEFAULT_RADIUS = 32;
    public static final int DEF_MAX_RADIUS = 64;
    public static int markerTimeout = 0;
    public static boolean renderIcons = true;
    public static boolean highlightSearch = true;
    public static int defRadius = 32;
    public static int maxRadius = 64;
    @Mod.Instance(value="ItemSearch")
    public static ItemSearch INSTANCE;
    @SidedProxy(serverSide="com.briman0094.itemsearch.proxy.CommonProxy", clientSide="com.briman0094.itemsearch.proxy.ClientProxy")
    public static CommonProxy PROXY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        config.addCustomCategoryComment("settings", "searchTimeout: The amount of time before the search clears itself. Set to 0 to disable.\nrenderIcons: Whether or not to render the result item next to the name");
        markerTimeout = config.get("settings", "searchTimeout", 90).getInt();
        renderIcons = config.get("settings", "renderIcons", true).getBoolean(true);
        highlightSearch = config.get("settings", "highlightSearchTerm", true).getBoolean(true);
        defRadius = config.get("settings", "defaultSearchRadius", 32).getInt();
        maxRadius = config.get("settings", "maximumSearchRadius", 64).getInt();
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PROXY.initRenderers();
        PROXY.registerMessageHandlers();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) throws Exception {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            ICommandManager cmdManager = MinecraftServer.func_71276_C().func_71187_D();
            if (cmdManager instanceof ServerCommandManager) {
                PROXY.registerCommands((ServerCommandManager)cmdManager);
            } else {
                throw new Exception("ItemSearch cannot load due to an invalid server instance");
            }
        }
    }
}

