/*
 * Decompiled with CFR 0.152.
 */
package com.briman0094.itemsearch.command;

import com.briman0094.itemsearch.ItemSearch;
import com.briman0094.itemsearch.ItemVector;
import com.briman0094.itemsearch.api.NoItemSearch;
import com.briman0094.itemsearch.message.MessageSearchResponse;
import com.briman0094.itemsearch.proxy.CommonProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class CommandSearch
extends CommandBase {
    public static final CommandSearch INSTANCE = new CommandSearch();
    public static final ArrayList<String> ALIASES = new ArrayList();

    public String func_71517_b() {
        return "search";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_71519_b(ICommandSender par1iCommandSender) {
        return true;
    }

    public List func_71514_a() {
        return ALIASES;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (!(sender instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        if (args.length <= 0) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Usage: /search <itemName> [radius]"));
        } else if (args.length == 1 && args[0].equalsIgnoreCase("clear")) {
            MessageSearchResponse message = CommonProxy.buildSearchPacket(new ArrayList<ItemVector>());
            CommonProxy.NET_HANDLER.sendTo((IMessage)message, player);
        } else {
            boolean isLastArgumentNumber = true;
            String numTest = args[args.length - 1];
            for (int c = 0; c < numTest.length(); ++c) {
                char chr = numTest.charAt(c);
                if (Character.isDigit(chr)) continue;
                isLastArgumentNumber = false;
                break;
            }
            String searchString = "";
            for (int i = 0; i < (isLastArgumentNumber ? args.length - 1 : args.length); ++i) {
                searchString = searchString + args[i];
                searchString = searchString + " ";
            }
            searchString = searchString.trim();
            try {
                int radius;
                int n = radius = isLastArgumentNumber ? Integer.parseInt(args[args.length - 1]) : ItemSearch.defRadius;
                if (radius <= ItemSearch.maxRadius) {
                    ArrayList<ItemVector> itemsFound = this.findItemsInRadius(player.field_70170_p, searchString, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, radius, (EntityPlayer)player);
                    MessageSearchResponse message = new MessageSearchResponse();
                    for (ItemVector i : itemsFound) {
                        message.addVector(i);
                    }
                    CommonProxy.NET_HANDLER.sendTo((IMessage)message, player);
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Radius must be " + ItemSearch.maxRadius + " blocks or less"));
                }
            }
            catch (Exception ex) {
                if (ex instanceof NumberFormatException) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\"" + args[1] + "\" is not a number"));
                }
                FMLLog.getLogger().log(Level.ERROR, String.format("An error occurred while executing the \"search\" command: %s", ex.toString()));
                player.func_145747_a((IChatComponent)new ChatComponentText("An internal server error occurred while attempting to execute the command"));
            }
        }
    }

    public ArrayList<ItemStack> getItemFromName(String name) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Object itemKey : GameData.getItemRegistry().func_148742_b()) {
            Item item = (Item)GameData.getItemRegistry().func_82594_a(itemKey.toString());
            if (item == null) continue;
            ItemStack testStack = new ItemStack(item);
            try {
                if (!testStack.func_82833_r().toLowerCase().contains(name.toLowerCase())) continue;
                items.add(testStack);
            }
            catch (Exception ex) {
                FMLLog.getLogger().log(Level.ERROR, "A minor error occurred while searching for items");
            }
        }
        return items;
    }

    public ArrayList<ItemVector> findItemsInRadius(World world, String search, int x, int y, int z, int radius, EntityPlayer player) {
        ArrayList<ItemVector> foundItems = new ArrayList<ItemVector>();
        try {
            Pattern p = Pattern.compile(search, 2);
            for (int xx = x - radius; xx <= x + radius; ++xx) {
                for (int yy = y - radius; yy <= y + radius; ++yy) {
                    for (int zz = z - radius; zz <= z + radius; ++zz) {
                        TileEntity teTest = world.func_147438_o(xx, yy, zz);
                        if (teTest == null || !(teTest instanceof IInventory) || teTest.getClass().isAnnotationPresent(NoItemSearch.class)) continue;
                        IInventory inventory = (IInventory)teTest;
                        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                            String iName;
                            Matcher m;
                            ItemStack test = inventory.func_70301_a(slot);
                            if (test == null || !(m = p.matcher(iName = test.func_82833_r())).find()) continue;
                            foundItems.add(new ItemVector(xx, yy, zz, test, search));
                        }
                    }
                }
            }
        }
        catch (PatternSyntaxException e) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Invalid search syntax"));
        }
        return foundItems;
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /search <clear | item name> [radius (default 64)]";
    }

    static {
        ALIASES.add("s");
    }
}

