/*
 * Decompiled with CFR 0.152.
 */
package com.nettle.inverse_creepers;

import com.nettle.inverse_creepers.EntityInverseCreeper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class InverseExplosion {
    public World worldObj;
    public EntityInverseCreeper exploder;
    public boolean isFlaming;
    public boolean isSmoking;
    public double posX;
    public double posY;
    public double posZ;
    public double explosionStrength;
    public Random Rnd = new Random();

    public InverseExplosion(World worldObj, EntityInverseCreeper entityCreeped, double posX, double posY, double posZ, float strength) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.explosionStrength = strength;
        this.worldObj = worldObj;
        this.exploder = entityCreeped;
    }

    public void doExplosionA(boolean griefingAllowed) {
        int startX = (int)(this.posX - this.explosionStrength);
        int startY = (int)(this.posY - this.explosionStrength);
        int startZ = (int)(this.posZ - this.explosionStrength);
        int endX = (int)(this.posX + this.explosionStrength);
        int endY = (int)(this.posY + this.explosionStrength);
        int endZ = (int)(this.posZ + this.explosionStrength);
        double additiveRange = 2.0;
        double i = MathHelper.func_76128_c((double)(this.posX - this.explosionStrength - additiveRange));
        double j = MathHelper.func_76128_c((double)(this.posX + this.explosionStrength + additiveRange));
        double k = MathHelper.func_76128_c((double)(this.posY - this.explosionStrength - additiveRange));
        int i2 = MathHelper.func_76128_c((double)(this.posY + this.explosionStrength + additiveRange));
        int l = MathHelper.func_76128_c((double)(this.posZ - this.explosionStrength - additiveRange));
        int j2 = MathHelper.func_76128_c((double)(this.posZ + this.explosionStrength + additiveRange));
        List list = this.worldObj.func_72839_b((Entity)this.exploder, AxisAlignedBB.func_72332_a().func_72299_a(i, k, (double)l, j, (double)i2, (double)j2));
        Vec3 vec3 = this.worldObj.func_82732_R().func_72345_a(this.posX, this.posY, this.posZ);
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f(this.posX, this.posY, this.posZ) / (this.explosionStrength * additiveRange);
            if (!(d4 <= 1.0) || (d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.posX) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - this.posY) * d6 + (d7 = entity.field_70161_v - this.posZ) * d7))) == 0.0) continue;
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            double d10 = this.worldObj.func_72842_a(vec3, entity.field_70121_D);
            double d11 = (1.0 - d4) * d10;
            entity.func_70097_a(DamageSource.field_76377_j, (float)((int)((d11 * d11 + d11) / 4.0 * 2.0 * this.explosionStrength + 1.0)));
            double d8 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d11);
            entity.field_70159_w -= d5 * d8 * 40.0;
            entity.field_70181_x -= d6 * d8 * 40.0;
            entity.field_70179_y -= d7 * d8 * 40.0;
        }
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    boolean canPlace;
                    if (!(Math.pow(this.explosionStrength, 2.0) >= Math.pow((double)x - this.posX, 2.0) + Math.pow((double)y - this.posY, 2.0) + Math.pow((double)z - this.posZ, 2.0))) continue;
                    float whichBlock = (float)this.Rnd.nextInt(10000) / 100.0f;
                    boolean bl = canPlace = griefingAllowed || this.worldObj.func_147437_c(x, y, z);
                    if (!canPlace) continue;
                    if (whichBlock < 0.05f) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"diamond_ore"));
                        continue;
                    }
                    if (whichBlock < 0.1f) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"emerald_ore"));
                        continue;
                    }
                    if (whichBlock < 0.15f) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"lapis_ore"));
                        continue;
                    }
                    if (whichBlock < 0.25f) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"redstone_ore"));
                        continue;
                    }
                    if (whichBlock < 0.4f) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"gold_ore"));
                        continue;
                    }
                    if (whichBlock < 0.65f) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"iron_ore"));
                        continue;
                    }
                    if (whichBlock < 1.15f) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"coal_ore"));
                        continue;
                    }
                    if (whichBlock < 8.0f && griefingAllowed) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"fire"));
                        continue;
                    }
                    if (whichBlock < 18.0f) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"stone"));
                        continue;
                    }
                    if (whichBlock < 44.0f) {
                        this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"cobblestone"));
                        continue;
                    }
                    if (!(whichBlock < 70.0f)) continue;
                    this.worldObj.func_147449_b(x, y, z, Block.func_149684_b((String)"dirt"));
                }
            }
        }
    }

    public void doExplosionB(boolean b) {
        this.worldObj.func_72908_a(this.posX, this.posY, this.posZ, "random.explode", 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.explosionStrength >= 2.0 && this.isSmoking) {
            this.worldObj.func_72869_a("hugeexplosion", this.posX, this.posY, this.posZ, 1.0, 0.0, 0.0);
        } else {
            this.worldObj.func_72869_a("largeexplode", this.posX, this.posY, this.posZ, 1.0, 0.0, 0.0);
        }
    }
}

