/*
 * Decompiled with CFR 0.152.
 */
package net.dentzor.minecraft.instant.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.dentzor.minecraft.instant.common.CommonProxy;
import net.dentzor.minecraft.instant.item.ItemCombTool;
import net.dentzor.minecraft.instant.item.ItemDelTool;
import net.dentzor.minecraft.instant.item.ItemGemInstant;
import net.dentzor.minecraft.instant.item.ItemMineTool;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="instant", name="Instant Mining Mod", version="#6")
public class Core {
    @SidedProxy(clientSide="net.dentzor.minecraft.instant.common.ClientProxy", serverSide="net.dentzor.minecraft.instant.common.CommonProxy")
    public static CommonProxy proxy;
    public static final String modid = "instant";
    public static final String modname = "Instant Mining Mod";
    public static final String modversion = "#6";
    public static final String textureLocation = "instant:";
    public static boolean enableCoreSteel;
    public static boolean enableCoreStickSteel;
    public static boolean enableCoreIngotRedstone;
    public static boolean commonConfig;
    public static boolean delBedrock;
    public static boolean combBedrock;
    public static Item.ToolMaterial MINING;
    public static Item.ToolMaterial COMBI;
    public static Item mineTool;
    public static Item deleteTool;
    public static Item combiTool;
    public static Item gemInstant;
    public static boolean enableMineTool;
    public static boolean enableDeleteTool;
    public static boolean enableCombiTool;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        Core.loadConfig(event);
        Core.init_items();
        Core.registerItems();
    }

    @Mod.EventHandler
    public static void atInit(FMLInitializationEvent event) {
        Core.registerOreDictionary();
        Core.init_crafting();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
    }

    public static void registerItems() {
        if (enableMineTool) {
            GameRegistry.registerItem((Item)mineTool, (String)"toolMining");
        }
        if (enableDeleteTool) {
            GameRegistry.registerItem((Item)deleteTool, (String)"toolDelete");
        }
        if (enableCombiTool) {
            GameRegistry.registerItem((Item)combiTool, (String)"toolCombi");
        }
        if (enableMineTool || enableDeleteTool || enableCombiTool) {
            GameRegistry.registerItem((Item)gemInstant, (String)"gemInstant");
        }
    }

    public static void loadConfig(FMLPreInitializationEvent event) {
        String categoryGeneralCore;
        String categoryEnable;
        Configuration coreConfig = new Configuration(new File(event.getSuggestedConfigurationFile().getPath().replace(modid, "FlannCore")));
        coreConfig.load();
        commonConfig = coreConfig.get("core", "combineConfigs", false).getBoolean(false);
        if (commonConfig) {
            categoryEnable = "instant_Enable";
            categoryGeneralCore = "core_General";
        } else {
            categoryEnable = "enable";
            categoryGeneralCore = "general";
        }
        if (enableCoreSteel) {
            Core.set(coreConfig, categoryGeneralCore, "enableSteel", true);
        }
        if (enableCoreStickSteel) {
            Core.set(coreConfig, categoryGeneralCore, "enableStickSteel", true);
        }
        if (enableCoreIngotRedstone) {
            Core.set(coreConfig, categoryGeneralCore, "enableIngotRedstone", true);
        }
        coreConfig.save();
        Configuration config = !commonConfig ? new Configuration(event.getSuggestedConfigurationFile()) : coreConfig;
        config.load();
        enableMineTool = config.get(categoryEnable, "enableMineTool", true).getBoolean(true);
        enableDeleteTool = config.get(categoryEnable, "enableDeleteTool", true).getBoolean(true);
        enableCombiTool = config.get(categoryEnable, "enableCombiTool", true).getBoolean(true);
        delBedrock = config.get(categoryEnable, "Enable Del-Tool To Remove Bedrock", false).getBoolean(false);
        combBedrock = config.get(categoryEnable, "Enable Combi-Tool To Remove Bedrock", false).getBoolean(false);
        config.save();
    }

    public static void init_items() {
        mineTool = new ItemMineTool("Mining Tool", "instant:mineTool", MINING).func_77655_b("toolMining");
        deleteTool = new ItemDelTool("Delete Tool", "instant:delTool", delBedrock).func_77655_b("toolDelete");
        combiTool = new ItemCombTool("Combi Tool", "instant:combTool", combBedrock, COMBI).func_77655_b("toolCombi");
        gemInstant = new ItemGemInstant(textureLocation, new String[]{"gemUniversal", "gemMining", "gemDelete", "gemCombi"}, new String[]{"Instant-Tool Gem", "Instant-Mining Gem", "Instant-Deletion Gem", "Instant-Combi Gem"}).func_77655_b("gemInstant");
    }

    public static void registerOreDictionary() {
        OreDictionary.registerOre((String)"instantMining", (Item)mineTool);
        OreDictionary.registerOre((String)"instantDelete", (Item)deleteTool);
        OreDictionary.registerOre((String)"instantCombi", (Item)combiTool);
        OreDictionary.registerOre((String)"gemInstantUniversal", (ItemStack)new ItemStack(gemInstant, 1, 0));
        OreDictionary.registerOre((String)"gemInstantMining", (ItemStack)new ItemStack(gemInstant, 1, 1));
        OreDictionary.registerOre((String)"gemInstantDelete", (ItemStack)new ItemStack(gemInstant, 1, 2));
        OreDictionary.registerOre((String)"gemInstantCombi", (ItemStack)new ItemStack(gemInstant, 1, 3));
    }

    public static void init_crafting() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(mineTool), (Object[])new Object[]{"  d", " s ", "s  ", Character.valueOf('d'), new ItemStack(gemInstant, 1, 1), Character.valueOf('s'), Items.field_151055_y});
        GameRegistry.addRecipe((ItemStack)new ItemStack(deleteTool), (Object[])new Object[]{"  d", " s ", "s  ", Character.valueOf('d'), new ItemStack(gemInstant, 1, 2), Character.valueOf('s'), Items.field_151055_y});
        GameRegistry.addRecipe((ItemStack)new ItemStack(combiTool), (Object[])new Object[]{"  d", " s ", "s  ", Character.valueOf('d'), new ItemStack(gemInstant, 1, 3), Character.valueOf('s'), Items.field_151055_y});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gemInstant, 1, 0), (Object[])new Object[]{"$#$", "&@&", "$#$", Character.valueOf('$'), Blocks.field_150343_Z, Character.valueOf('#'), Blocks.field_150484_ah, Character.valueOf('&'), Blocks.field_150475_bE, Character.valueOf('@'), Items.field_151156_bN});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gemInstant, 1, 0), (Object[])new Object[]{"$&$", "#@#", "$&$", Character.valueOf('$'), Blocks.field_150343_Z, Character.valueOf('#'), Blocks.field_150484_ah, Character.valueOf('&'), Blocks.field_150475_bE, Character.valueOf('@'), Items.field_151156_bN});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(gemInstant, 1, 1), (Object[])new Object[]{new ItemStack(gemInstant, 1, 0), new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(gemInstant, 1, 2), (Object[])new Object[]{new ItemStack(gemInstant, 1, 0), new ItemStack(Items.field_151100_aR, 1, 15)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gemInstant, 1, 3), (Object[])new Object[]{"###", "M@D", "$$$", Character.valueOf('#'), Items.field_151045_i, Character.valueOf('M'), mineTool, Character.valueOf('@'), Items.field_151156_bN, Character.valueOf('D'), deleteTool, Character.valueOf('$'), Items.field_151166_bC});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gemInstant, 1, 3), (Object[])new Object[]{"###", "M@D", "$$$", Character.valueOf('#'), Blocks.field_150484_ah, Character.valueOf('M'), mineTool, Character.valueOf('@'), Items.field_151156_bN, Character.valueOf('D'), deleteTool, Character.valueOf('$'), Blocks.field_150475_bE});
    }

    public static Property set(Configuration config, String category, String key, boolean defaultValue) {
        return Core.set(config, category, key, defaultValue, null);
    }

    public static Property set(Configuration config, String category, String key, boolean defaultValue, String comment) {
        Property prop = config.get(category, key, Boolean.toString(defaultValue), comment, Property.Type.BOOLEAN);
        prop.set(defaultValue);
        return prop;
    }

    static {
        enableCoreSteel = false;
        enableCoreStickSteel = false;
        enableCoreIngotRedstone = false;
        MINING = EnumHelper.addToolMaterial((String)"MINING", (int)3, (int)0, (float)5000.0f, (float)0.0f, (int)0);
        COMBI = EnumHelper.addToolMaterial((String)"COMBI", (int)3, (int)0, (float)5000.0f, (float)0.0f, (int)0);
    }
}

