package mods.immibis.microblocks.crossmod;

import mods.immibis.microblocks.ItemMicroblock;
import mods.immibis.microblocks.MicroblockSystem;
import mods.immibis.microblocks.ModProperties;
import mods.immibis.microblocks.coremod.CoreModOptions;
import net.minecraft.client.resources.I18n;
import cpw.mods.fml.common.API;

public class NEIMicroblocksConfig implements IConfigureNEI {
	@Override
	public void loadConfig() {
		if(MicroblockSystem.instance != null) {
			try {
				if(CoreModOptions.enableNEI) {
					API.setMaxDamageException(MicroblockSystem.microblockContainerBlock.blockID, 1);
					for(int i : MicroblockSystem.neiPartIDs)
						API.addNBTItem(ItemMicroblock.getStackWithPartID(i));
					API.addSetRange(I18n.getString("immibis_microblocks.nei.subset"), new MultiItemRange().add(MicroblockSystem.microblockContainerBlock));
				
					
					// Not possible as subset API ignores NBT
					/*ArrayList<Integer> sortedIDs = new ArrayList<Integer>(MicroblockSystem.parts.keySet());
					Collections.sort(sortedIDs);
					
					MultiItemRange panels = new MultiItemRange();
					MultiItemRange hpanels = new MultiItemRange();
					MultiItemRange corners = new MultiItemRange();
					MultiItemRange strips = new MultiItemRange();
					
					for(int id : sortedIDs) {
						PartType<?> type = MicroblockSystem.parts.get(id);
						ItemStack stack = MicroblockSystem.instance.partTypeIDToItemStack(id, 1);
						
						switch(type.getPartClass()) {
						case Centre: break;
						case Panel: panels.add(stack); break;
						case HollowPanel: hpanels.add(stack); break;
						case Strip: strips.add(stack); break;
						case Corner: corners.add(stack); break;
						}
					}
					
					API.addSetRange("Microblocks.Panels", panels);
					API.addSetRange("Microblocks.Hollow Panels", hpanels);
					API.addSetRange("Microblocks.Corners", corners);
					API.addSetRange("Microblocks.Strips", strips);*/
					
				} else {
					API.hideItem(MicroblockSystem.microblockContainerBlock.blockID);
				}
			} catch(Throwable e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public String getName() {
		return "Immibis's Microblocks";
	}

	@Override
	public String getVersion() {
		return ModProperties.MOD_VERSION;
	}
}
