/*
 * Decompiled with CFR 0.152.
 */
package hats.client.gui;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.client.FMLClientHandler;
import hats.client.core.HatInfoClient;
import hats.client.gui.GuiTradeMaker;
import hats.common.Hats;
import hats.common.core.CommonProxy;
import hats.common.core.HatHandler;
import hats.common.core.HatInfo;
import hats.common.entity.EntityHat;
import hats.common.packet.PacketPlayerHatSelection;
import hats.common.packet.PacketString;
import ichun.client.gui.GuiSlider;
import ichun.client.gui.ISlider;
import ichun.client.keybind.KeyBind;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import ichun.common.iChunUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiHatSelection
extends GuiScreen
implements ISlider {
    public static final ResourceLocation texIcons = new ResourceLocation("hats", "textures/gui/icons.png");
    public static final ResourceLocation texChooser = new ResourceLocation("hats", "textures/gui/hatchooser.png");
    private final int ID_PAGE_LEFT = 1;
    private final int ID_DONE_SELECT = 2;
    private final int ID_PAGE_RIGHT = 3;
    private final int ID_CLOSE = 4;
    private final int ID_NONE = 8;
    private final int ID_HAT_COLOUR_SWAP = 9;
    private final int ID_RANDOM = 10;
    private final int ID_FAVOURITES = 11;
    private final int ID_CATEGORIES = 12;
    private final int ID_PERSONALIZE = 13;
    private final int ID_RELOAD_HATS = 14;
    private final int ID_HELP = 15;
    private final int ID_SEARCH = 16;
    private final int ID_ADD = 17;
    private final int ID_CANCEL = 18;
    private final int ID_RENAME = 19;
    private final int ID_DELETE = 20;
    private final int ID_FAVOURITE = 21;
    private final int ID_SET_KEY = 22;
    private final int ID_SET_FP = 23;
    private final int ID_RESET_SIDE = 24;
    private final int ID_MOB_SLIDER = 25;
    private final int ID_SHOW_HATS = 26;
    private final int ID_MAKE_TRADE = 27;
    private final int ID_ACCEPT_TRADE = 28;
    private final int ID_CATEGORIES_START = 30;
    private final int ID_HAT_START_ID = 600;
    private final int VIEW_HATS = 0;
    private final int VIEW_COLOURIZER = 1;
    private final int VIEW_CATEGORIES = 2;
    private final int VIEW_CATEGORY = 3;
    private String category = "";
    private String currentDisplay;
    private GuiTextField searchBar;
    private String selectedButtonName = "";
    private int favourite;
    private int randoMob;
    private boolean hasClicked = false;
    private boolean confirmed = false;
    private boolean adding = false;
    private boolean invalidFolderName = false;
    private boolean deleting = false;
    private boolean justClickedButton = false;
    private boolean renaming = false;
    private boolean addingToCategory = false;
    private boolean personalizing = false;
    private boolean settingKey = false;
    private boolean enabledSearchBar = false;
    public EntityPlayer player;
    public EntityHat hat;
    public List<String> availableHats;
    public List<String> hatsToShow;
    public List<String> categories;
    public List<String> categoryHats = new ArrayList<String>();
    public List<String> enabledButtons = new ArrayList<String>();
    protected int xSize = 176;
    protected int ySize = 170;
    public float mouseX;
    public float mouseY;
    protected int guiLeft;
    protected int guiTop;
    public int pageNumber;
    public int colourR;
    public int colourG;
    public int colourB;
    public int alpha;
    private String prevHatName;
    private int prevColourR;
    private int prevColourG;
    private int prevColourB;
    private int prevAlpha;
    private HatInfoClient tempInfo;
    public int view;
    public Random rand;
    private static final String[] invalidChars = new String[]{"\\", "/", ":", "*", "?", "\"", "<", ">", "|"};
    private static int helpPage = 0;
    private static final ArrayList<String[]> help = new ArrayList();
    private static final String[] helpInfo1 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo1.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo1.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo1.desc3"), StatCollector.func_74838_a((String)"hats.gui.helpInfo1.desc4"), StatCollector.func_74838_a((String)"hats.gui.helpInfo1.desc5")};
    private static final String[] helpInfo2 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo2.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo2.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo2.desc3")};
    private static final String[] helpInfo3 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo3.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo3.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo3.desc3"), StatCollector.func_74838_a((String)"hats.gui.helpInfo3.desc4")};
    private static final String[] helpInfo4 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo4.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo4.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo4.desc3"), StatCollector.func_74838_a((String)"hats.gui.helpInfo4.desc4"), StatCollector.func_74838_a((String)"hats.gui.helpInfo4.desc5")};
    private static final String[] helpInfo5 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo5.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo5.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo5.desc3")};
    private static final String[] helpInfo6 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo6.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo6.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo6.desc3"), StatCollector.func_74838_a((String)"hats.gui.helpInfo6.desc4")};
    private static final String[] helpInfo7 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo7.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo7.desc2")};
    private static final String[] helpInfo8 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo8.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo8.desc2")};
    private static final String[] helpInfo9 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo9.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo9.desc2")};
    private static final String[] helpInfo10 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo10.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo10.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo10.desc3"), StatCollector.func_74838_a((String)"hats.gui.helpInfo10.desc4"), StatCollector.func_74838_a((String)"hats.gui.helpInfo10.desc5")};
    private static final String[] helpInfo11 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo11.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo11.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo11.desc3"), StatCollector.func_74838_a((String)"hats.gui.helpInfo11.desc4"), StatCollector.func_74838_a((String)"hats.gui.helpInfo11.desc5"), StatCollector.func_74838_a((String)"hats.gui.helpInfo11.desc6")};
    private static final String[] helpInfo12 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo12.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo12.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo12.desc3")};
    private static final String[] helpInfo13 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo13.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo13.desc2")};
    private static final String[] helpInfo14 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo14.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo14.desc2")};
    private static final String[] helpInfo15 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo15.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo15.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo15.desc3")};
    private static final String[] helpInfo16 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo16.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo16.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo16.desc3"), StatCollector.func_74838_a((String)"hats.gui.helpInfo16.desc4")};
    private static final String[] helpInfo17 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo17.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo17.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo17.desc3")};
    private static final String[] helpInfo18 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo18.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo18.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo18.desc3")};
    private static final String[] helpInfo19 = new String[]{StatCollector.func_74838_a((String)"hats.gui.helpInfo19.desc1"), StatCollector.func_74838_a((String)"hats.gui.helpInfo19.desc2"), StatCollector.func_74838_a((String)"hats.gui.helpInfo19.desc3")};

    public GuiHatSelection(EntityPlayer ply) {
        if (Hats.config.getSessionInt("playerHatsMode") >= 4) {
            if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                HatHandler.repopulateHatsList();
            } else {
                CommonProxy.tickHandlerClient.availableHats = new HashMap<String, Integer>(CommonProxy.tickHandlerClient.serverHats);
            }
        }
        this.player = ply;
        this.hat = CommonProxy.tickHandlerClient.hats.get(this.player.func_70005_c_());
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : CommonProxy.tickHandlerClient.availableHats.entrySet()) {
            list.add(entry.getKey());
        }
        Collections.sort(list);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (Hats.config.getInt("showContributorHatsInGui") != 0 || !((String)list.get(i)).startsWith("(C) ")) continue;
            list.remove(i);
        }
        this.availableHats = ImmutableList.copyOf(list);
        this.hatsToShow = new ArrayList<String>(this.availableHats);
        Collections.sort(this.hatsToShow);
        this.categories = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<String>> entry : HatHandler.categories.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Favourites")) continue;
            this.categories.add(entry.getKey());
        }
        Collections.sort(this.categories);
        if (this.hat != null) {
            this.prevHatName = this.hat.hatName;
            this.prevColourR = this.colourR = this.hat.getR();
            this.prevColourG = this.colourG = this.hat.getG();
            this.prevColourB = this.colourB = this.hat.getB();
            this.prevAlpha = this.alpha = this.hat.getA();
        }
        this.pageNumber = 0;
        this.view = 0;
        this.rand = new Random();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.hat == null || this.player == null) {
            this.field_146297_k.func_147108_a(null);
        } else {
            int i;
            Keyboard.enableRepeatEvents((boolean)true);
            String[] enabledBtn = Hats.config.getString("personalizeEnabled").split(" ");
            this.enabledButtons.clear();
            for (i = 0; i < enabledBtn.length; ++i) {
                if (enabledBtn[i].equalsIgnoreCase("9")) {
                    this.enabledSearchBar = true;
                    continue;
                }
                if (this.enabledButtons.contains(enabledBtn[i])) continue;
                this.enabledButtons.add(enabledBtn[i]);
            }
            this.field_146292_n.clear();
            this.guiLeft = (this.field_146294_l - this.xSize) / 2;
            this.guiTop = (this.field_146295_m - this.ySize) / 2;
            this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 6, this.field_146295_m / 2 + 54, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 + 62, this.field_146295_m / 2 + 54, 20, 20, ">"));
            this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 16, this.field_146295_m / 2 + 54, 44, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
            this.addToolButton(8);
            this.addToolButton(9);
            this.addToolButton(10);
            this.addToolButton(11);
            this.addToolButton(12);
            this.addToolButton(13);
            this.addToolButton(14);
            this.addToolButton(15);
            this.field_146292_n.add(new GuiButton(4, this.field_146294_l - 22, 2, 20, 20, "X"));
            this.pageNumber = 0;
            if (!this.hat.hatName.equalsIgnoreCase("")) {
                for (i = 0; i < this.hatsToShow.size(); ++i) {
                    String hatName = this.hatsToShow.get(i);
                    if (!hatName.equalsIgnoreCase(this.hat.hatName)) continue;
                    i -= i % 6;
                    this.pageNumber = i / 6;
                    break;
                }
            }
            this.updateButtonList();
            this.searchBar = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 65, this.field_146295_m - 24, 150, 20);
            this.searchBar.func_146203_f(255);
            this.searchBar.func_146180_a(StatCollector.func_74838_a((String)"hats.gui.search"));
            this.searchBar.func_146193_g(0xAAAAAA);
            this.searchBar.func_146189_e(this.enabledSearchBar);
        }
    }

    public void addToolButton(int id) {
        boolean enabled = false;
        for (int i = 0; i < this.enabledButtons.size(); ++i) {
            if (!this.enabledButtons.get(i).equalsIgnoreCase(Integer.toString(id - 7))) continue;
            this.field_146292_n.add(new GuiButton(id, this.field_146294_l / 2 + 89, this.field_146295_m / 2 - 85 + i * 21, 20, 20, ""));
            enabled = true;
            break;
        }
        if (!enabled) {
            GuiButton btn = new GuiButton(id, this.field_146294_l - 24, this.field_146295_m / 2 - 93 + (id - 8) * 21, 20, 20, "");
            btn.field_146125_m = false;
            this.field_146292_n.add(btn);
        }
    }

    public void func_73876_c() {
        this.searchBar.func_146178_a();
        if (this.searchBar.func_146206_l()) {
            this.searchBar.func_146189_e(true);
        } else {
            this.searchBar.func_146189_e(this.enabledSearchBar);
        }
        if (this.favourite > 0) {
            --this.favourite;
        }
    }

    public void func_146281_b() {
        if (!this.confirmed && this.hat != null) {
            this.hat.hatName = this.prevHatName;
            this.hat.setR(this.prevColourR);
            this.hat.setG(this.prevColourG);
            this.hat.setB(this.prevColourB);
            this.hat.setA(this.prevAlpha);
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char c, int i) {
        if (this.settingKey) {
            KeyBind oriKeyBind = (KeyBind)Hats.config.keyBindMap.get("guiKeyBind");
            KeyBind bind = new KeyBind(i, false, false, false, false);
            Hats.config.keyBindMap.put("guiKeyBind", iChunUtil.proxy.registerKeyBind(bind, oriKeyBind));
            Hats.config.get("guiKeyBind").set(i);
            for (int i1 = 0; i1 < this.field_146292_n.size(); ++i1) {
                GuiButton btn = (GuiButton)this.field_146292_n.get(i1);
                if (btn.field_146127_k != 22) continue;
                btn.field_146126_j = "GUI: " + Keyboard.getKeyName((int)i);
                break;
            }
            this.settingKey = false;
            Hats.config.save();
        } else if (!this.personalizing) {
            this.searchBar.func_146201_a(c, i);
            if (this.searchBar.func_146206_l()) {
                this.onSearch();
            }
            if (i == 1) {
                if (this.searchBar.func_146206_l()) {
                    this.searchBar.func_146180_a("");
                    this.searchBar.func_146195_b(false);
                    this.onSearchBarInteract();
                } else {
                    this.exitWithoutUpdate();
                    this.field_146297_k.func_71381_h();
                }
            }
            if (!this.searchBar.func_146206_l()) {
                GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
                if (i == 19) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    this.randomize();
                } else if (i == 15 || i == gameSettings.field_74310_D.func_151463_i()) {
                    this.searchBar.func_146195_b(true);
                    this.onSearchBarInteract();
                } else if (!(i != 35 || this.hat.hatName.equalsIgnoreCase("") && this.view == 0)) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    this.toggleHatsColourizer();
                } else if (i == 49 && !this.hat.hatName.equalsIgnoreCase("")) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    this.removeHat();
                } else if (i == 46) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    this.showCategories();
                } else if (i == 33) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    if ((this.view == 0 || this.view == 3) && GuiHatSelection.func_146272_n()) {
                        String s = "";
                        for (String hat1 : this.availableHats) {
                            if (!hat1.toLowerCase().equalsIgnoreCase(this.hat.hatName)) continue;
                            s = hat1;
                        }
                        if (!s.equalsIgnoreCase("")) {
                            if (HatHandler.isInFavourites(s)) {
                                HatHandler.removeFromCategory(s, "Favourites");
                            } else {
                                HatHandler.addToCategory(s, "Favourites");
                            }
                            if (this.view == 3 && this.category.equalsIgnoreCase("Favourites")) {
                                this.showCategory("Favourites");
                            }
                            this.favourite = 6;
                        }
                    } else {
                        this.showCategory("Favourites");
                    }
                } else if (i == 25) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    this.personalize();
                }
                if (this.view == 0) {
                    if ((i == gameSettings.field_74370_x.func_151463_i() || i == 203) && this.pageNumber > 0) {
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                        this.switchPage(true);
                    } else if ((i == gameSettings.field_74366_z.func_151463_i() || i == 205) && (this.pageNumber + 1) * 6 < this.hatsToShow.size()) {
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                        this.switchPage(false);
                    }
                }
            } else if (i == 28 && (this.adding || this.renaming) && this.view == 2 && !this.invalidFolderName && (this.adding && this.addCategory(this.searchBar.func_146179_b().trim()) || this.renaming && this.renameCategory(this.selectedButtonName, this.searchBar.func_146179_b().trim()))) {
                this.searchBar.func_146180_a("");
                this.onSearchBarInteract();
                this.updateButtonList();
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        if (this.settingKey) {
            KeyBind oriKeyBind = (KeyBind)Hats.config.keyBindMap.get("guiKeyBind");
            KeyBind bind = new KeyBind(par3 - 100, false, false, false, false);
            Hats.config.keyBindMap.put("guiKeyBind", iChunUtil.proxy.registerKeyBind(bind, oriKeyBind));
            Hats.config.get("guiKeyBind").set(par3 - 100);
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                GuiButton btn = (GuiButton)this.field_146292_n.get(i);
                if (btn.field_146127_k != 22) continue;
                btn.field_146126_j = "GUI: " + GameSettings.func_74298_c((int)(par3 - 100));
                break;
            }
            this.settingKey = false;
            Hats.config.save();
        } else {
            boolean flag;
            super.func_73864_a(par1, par2, par3);
            boolean bl = flag = par1 >= this.field_146294_l / 2 - 65 && par1 < this.field_146294_l / 2 - 65 + this.field_146294_l && par2 >= this.field_146295_m - 24 && par2 < this.field_146295_m - 24 + this.field_146295_m;
            if (this.enabledSearchBar) {
                if (!this.personalizing) {
                    this.searchBar.func_146192_a(par1, par2, par3);
                    if (par3 == 1 && flag) {
                        this.searchBar.func_146180_a("");
                        this.onSearch();
                    }
                    this.onSearchBarInteract();
                } else if (flag) {
                    this.toggleSearchBar();
                }
            }
        }
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        super.func_146286_b(par1, par2, par3);
        if (this.adding || this.renaming) {
            this.searchBar.func_146195_b(true);
            this.onSearchBarInteract();
            this.onSearch();
        }
        this.justClickedButton = false;
    }

    public void onSearch() {
        if (this.adding || this.renaming) {
            this.invalidFolderName = false;
            this.searchBar.func_146193_g(0xE0E0E0);
            for (String s : this.categories) {
                if (!s.equalsIgnoreCase(this.searchBar.func_146179_b())) continue;
                this.searchBar.func_146193_g(0xFF5555);
                this.invalidFolderName = true;
            }
            for (String s : invalidChars) {
                if (!this.searchBar.func_146179_b().contains(s)) continue;
                this.searchBar.func_146193_g(0xFF5555);
                this.invalidFolderName = true;
            }
            if (this.searchBar.func_146179_b().equalsIgnoreCase("Favourites") || this.searchBar.func_146179_b().equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.allHats")) || this.searchBar.func_146179_b().equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.addNew"))) {
                this.searchBar.func_146193_g(0xFF5555);
                this.invalidFolderName = true;
            }
            if (this.searchBar.func_146179_b().equalsIgnoreCase("")) {
                this.invalidFolderName = true;
            }
            for (int k = 0; k < this.field_146292_n.size(); ++k) {
                GuiButton btn = (GuiButton)this.field_146292_n.get(k);
                if (btn.field_146127_k != 17) continue;
                btn.field_146124_l = !this.invalidFolderName;
                break;
            }
        } else {
            if (this.searchBar.func_146179_b().equalsIgnoreCase("") || !this.hasClicked && this.searchBar.func_146179_b().equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.search"))) {
                this.searchBar.func_146193_g(0xE0E0E0);
                this.hatsToShow = new ArrayList<String>(this.view == 0 ? this.availableHats : (this.view == 3 ? this.categoryHats : this.categories));
                Collections.sort(this.hatsToShow);
                if (this.view == 2) {
                    this.hatsToShow.add(0, StatCollector.func_74838_a((String)"hats.gui.allHats"));
                    this.hatsToShow.add(StatCollector.func_74838_a((String)"hats.gui.addNew"));
                }
            } else {
                String query = this.searchBar.func_146179_b();
                ArrayList<String> matches = new ArrayList<String>();
                block3: for (String s : this.view == 0 ? this.availableHats : (this.view == 3 ? this.categoryHats : this.categories)) {
                    String[] split;
                    if (this.view == 2 && (s.equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.allHats")) || s.equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.addNew")))) continue;
                    if (s.toLowerCase().startsWith(query.toLowerCase())) {
                        if (matches.contains(s)) continue;
                        matches.add(s);
                        continue;
                    }
                    for (String s1 : split = s.split(" ")) {
                        if (!s1.toLowerCase().startsWith(query.toLowerCase())) continue;
                        if (matches.contains(s)) continue block3;
                        matches.add(s);
                        continue block3;
                    }
                }
                if (matches.size() == 0) {
                    this.searchBar.func_146193_g(0xFF5555);
                    this.hatsToShow = new ArrayList<String>(this.view == 0 ? this.availableHats : (this.view == 3 ? this.categoryHats : this.categories));
                    Collections.sort(this.hatsToShow);
                    if (this.view == 2) {
                        this.hatsToShow.add(0, StatCollector.func_74838_a((String)"hats.gui.allHats"));
                        this.hatsToShow.add(StatCollector.func_74838_a((String)"hats.gui.addNew"));
                    }
                } else {
                    this.searchBar.func_146193_g(0xE0E0E0);
                    this.pageNumber = 0;
                    this.hatsToShow = new ArrayList<String>(matches);
                    Collections.sort(this.hatsToShow);
                }
            }
            this.updateButtonList();
        }
    }

    public void onSearchBarInteract() {
        if (this.searchBar.func_146206_l()) {
            this.searchBar.func_146193_g(0xE0E0E0);
            if (!this.hasClicked && this.searchBar.func_146179_b().equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.search"))) {
                this.hasClicked = true;
                this.searchBar.func_146180_a("");
                this.onSearch();
            }
        } else {
            this.searchBar.func_146193_g(0xAAAAAA);
            if (this.searchBar.func_146179_b().equalsIgnoreCase("")) {
                this.hasClicked = false;
                if (!this.adding && !this.renaming) {
                    this.searchBar.func_146180_a(StatCollector.func_74838_a((String)"hats.gui.search"));
                    if (this.view == 2) {
                        this.updateButtonList();
                    }
                }
            }
        }
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn.field_146127_k == 27) {
            FMLClientHandler.instance().displayGuiScreen((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (GuiScreen)new GuiTradeMaker());
            return;
        }
        if (btn.field_146127_k == 28) {
            if (CommonProxy.tickHandlerClient.tradeReq != null) {
                if (CommonProxy.tickHandlerClient.tradeReqTimeout > 0) {
                    PacketHandler.sendToServer(Hats.channels, (AbstractPacket)new PacketString(1, CommonProxy.tickHandlerClient.tradeReq));
                    return;
                }
            }
        }
        if (btn.field_146127_k == 2) {
            if (this.personalizing) {
                this.personalize();
            } else {
                this.exitAndUpdate();
            }
        }
        if (this.personalizing) {
            if (btn.field_146127_k >= 8 && btn.field_146127_k <= 16 && !this.justClickedButton) {
                this.justClickedButton = true;
                this.toggleVisibility(btn);
                if (btn.field_146127_k == 16) {
                    this.field_146292_n.remove(btn);
                }
            } else if (btn.field_146127_k == 22) {
                this.settingKey = true;
                btn.field_146126_j = "GUI: >???<";
            } else if (btn.field_146127_k == 23) {
                Hats.config.get("renderInFirstPerson").set(Hats.config.getInt("renderInFirstPerson") == 1 ? 0 : 1);
                btn.field_146126_j = StatCollector.func_74838_a((String)"hats.gui.firstPerson") + ": " + (Hats.config.getInt("renderInFirstPerson") == 1 ? StatCollector.func_74838_a((String)"gui.yes") : StatCollector.func_74838_a((String)"gui.no"));
            } else if (btn.field_146127_k == 26) {
                Hats.config.get("renderHats").set(Hats.config.getInt("renderHats") == 1 ? 0 : 1);
                Hats.config.updateSession("renderHats", (Object)Hats.config.getInt("renderHats"));
                btn.field_146126_j = StatCollector.func_74838_a((String)"hats.gui.showHats") + ": " + (Hats.config.getInt("renderHats") == 1 ? StatCollector.func_74838_a((String)"gui.yes") : StatCollector.func_74838_a((String)"gui.no"));
            } else if (btn.field_146127_k == 24) {
                this.enabledSearchBar = false;
                this.toggleSearchBar();
                this.enabledButtons.clear();
                this.enabledButtons.add("1");
                this.enabledButtons.add("2");
                this.enabledButtons.add("3");
                this.enabledButtons.add("4");
                this.enabledButtons.add("5");
                this.enabledButtons.add("6");
                this.enabledButtons.add("7");
                this.enabledButtons.add("8");
                for (int i = this.field_146292_n.size() - 1; i >= 0; --i) {
                    GuiButton btn1 = (GuiButton)this.field_146292_n.get(i);
                    if (btn1.field_146127_k >= 8 && btn1.field_146127_k <= 15) {
                        btn1.field_146128_h = this.field_146294_l / 2 + 89;
                        btn1.field_146129_i = this.field_146295_m / 2 - 85 + (btn1.field_146127_k - 8) * 21;
                        continue;
                    }
                    if (btn1.field_146127_k != 16) continue;
                    this.field_146292_n.remove(i);
                }
            }
        } else if (btn.field_146127_k == 1) {
            this.switchPage(true);
        } else if (btn.field_146127_k == 3) {
            this.switchPage(false);
        } else if (btn.field_146127_k == 4) {
            this.exitWithoutUpdate();
        } else if (btn.field_146127_k == 8) {
            this.removeHat();
        } else if (btn.field_146127_k == 9) {
            this.toggleHatsColourizer();
        } else if (btn.field_146127_k == 10) {
            this.randomize();
        } else if (btn.field_146127_k == 14) {
            this.reloadHatsAndReopenGUI();
        } else if (btn.field_146127_k == 11) {
            this.showCategory("Favourites");
        } else if (btn.field_146127_k == 12) {
            this.showCategories();
        } else if (btn.field_146127_k == 13) {
            this.personalize();
        } else if (btn.field_146127_k == 15) {
            if (++helpPage >= help.size()) {
                helpPage = 0;
            }
        } else if (btn.field_146127_k == 18) {
            if ((this.adding || this.renaming) && this.view == 2 && this.searchBar.func_146206_l()) {
                this.searchBar.func_146180_a("");
                this.onSearchBarInteract();
                this.updateButtonList();
            } else if (!this.justClickedButton && !this.selectedButtonName.equalsIgnoreCase("")) {
                this.selectedButtonName = "";
                this.updateButtonList();
            }
        } else if (btn.field_146127_k == 17) {
            if (!this.justClickedButton) {
                if (this.view == 3 && !this.category.equalsIgnoreCase("Favourites") && !this.category.equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.contributors"))) {
                    HatHandler.removeFromCategory(this.selectedButtonName, this.category);
                    this.showCategory(this.category);
                } else if (this.view == 0 || this.view == 3) {
                    this.addingToCategory = true;
                    this.showCategories();
                } else if ((this.adding || this.renaming) && this.view == 2 && this.searchBar.func_146206_l() && (this.adding && this.addCategory(this.searchBar.func_146179_b().trim()) || this.renaming && this.renameCategory(this.selectedButtonName, this.searchBar.func_146179_b().trim()))) {
                    this.searchBar.func_146180_a("");
                    this.onSearchBarInteract();
                    this.updateButtonList();
                }
            }
        } else if (btn.field_146127_k == 20) {
            if (!this.justClickedButton && !this.selectedButtonName.equalsIgnoreCase("")) {
                if (!this.deleting) {
                    this.deleting = true;
                } else {
                    this.deleting = false;
                    try {
                        File dir;
                        if (this.view == 2 && (dir = new File(HatHandler.hatsFolder, "/" + this.selectedButtonName)).exists() && dir.isDirectory()) {
                            File[] files;
                            for (File file : files = dir.listFiles()) {
                                File hat = new File(HatHandler.hatsFolder, file.getName());
                                if (hat.isDirectory() || !hat.getName().endsWith(".tc2")) continue;
                                if (!hat.exists()) {
                                    file.renameTo(hat);
                                }
                                file.delete();
                            }
                            if (!dir.delete()) {
                                Hats.console("Cannot delete category \"" + this.selectedButtonName + "\", directory is not empty!", true);
                            }
                        }
                        if (this.view == 0 || this.view == 3) {
                            HatHandler.deleteHat(this.selectedButtonName, GuiHatSelection.func_146272_n());
                        }
                    }
                    catch (Exception e) {
                        Hats.console("Failed to delete " + (this.view == 2 ? "category" : "hat") + ": " + this.selectedButtonName, true);
                    }
                    this.selectedButtonName = "";
                    this.updateButtonList();
                    this.reloadHatsAndReopenGUI();
                }
            }
        } else if (btn.field_146127_k == 19) {
            if (!this.justClickedButton && !this.selectedButtonName.equalsIgnoreCase("")) {
                this.renaming = true;
                for (int i = this.field_146292_n.size() - 1; i >= 0; --i) {
                    GuiButton button = (GuiButton)this.field_146292_n.get(i);
                    if (button.field_146127_k != 19 && button.field_146127_k != 20 && button.field_146127_k != 18) continue;
                    this.field_146292_n.remove(i);
                }
                this.field_146292_n.add(new GuiButton(17, btn.field_146128_h + 16 - 7, btn.field_146129_i, 20, 20, ""));
                this.field_146292_n.add(new GuiButton(18, btn.field_146128_h + 52 - 7, btn.field_146129_i, 20, 20, ""));
                this.searchBar.func_146180_a(this.selectedButtonName);
            }
        } else if (btn.field_146127_k == 21) {
            if (!this.justClickedButton) {
                if (!this.selectedButtonName.equalsIgnoreCase("") && HatHandler.isInFavourites(this.selectedButtonName)) {
                    HatHandler.removeFromCategory(this.selectedButtonName, "Favourites");
                    if (this.view == 3 && this.category.equalsIgnoreCase("Favourites")) {
                        this.showCategory("Favourites");
                    }
                } else {
                    HatHandler.addToCategory(this.selectedButtonName, "Favourites");
                }
            }
        } else if (btn.field_146127_k >= 600) {
            this.justClickedButton = true;
            if (GuiHatSelection.func_146272_n()) {
                this.updateButtonList();
                this.selectedButtonName = btn.field_146126_j;
                for (int i = this.field_146292_n.size() - 1; i >= 0; --i) {
                    GuiButton button = (GuiButton)this.field_146292_n.get(i);
                    if (button.field_146127_k != btn.field_146127_k) continue;
                    this.field_146292_n.remove(button);
                    break;
                }
                this.field_146292_n.add(new GuiButton(17, btn.field_146128_h + 1, btn.field_146129_i, 20, 20, ""));
                this.field_146292_n.add(new GuiButton(21, btn.field_146128_h + 23, btn.field_146129_i, 20, 20, ""));
                GuiButton btn1 = new GuiButton(20, btn.field_146128_h + 45, btn.field_146129_i, 20, 20, "");
                if (HatHandler.isContributor(this.selectedButtonName)) {
                    btn1.field_146124_l = false;
                }
                this.field_146292_n.add(btn1);
                this.field_146292_n.add(new GuiButton(18, btn.field_146128_h + 67, btn.field_146129_i, 20, 20, ""));
            } else {
                this.hat.hatName = btn.field_146126_j.toLowerCase();
                this.alpha = 255;
                this.colourB = 255;
                this.colourG = 255;
                this.colourR = 255;
                this.hat.setR(255);
                this.hat.setG(255);
                this.hat.setB(255);
                this.hat.setA(255);
                this.updateButtonList();
            }
        } else if (btn.field_146127_k >= 30) {
            this.justClickedButton = true;
            if (this.addingToCategory) {
                HatHandler.addToCategory(this.selectedButtonName, btn.field_146126_j);
                this.view = 1;
                this.category = "";
                this.toggleHatsColourizer();
            } else if (btn.field_146126_j.equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.addNew"))) {
                this.updateButtonList();
                for (int i = this.field_146292_n.size() - 1; i >= 0; --i) {
                    GuiButton button = (GuiButton)this.field_146292_n.get(i);
                    if (button.field_146127_k != btn.field_146127_k) continue;
                    this.field_146292_n.remove(button);
                    break;
                }
                this.field_146292_n.add(new GuiButton(17, btn.field_146128_h + 16, btn.field_146129_i, 20, 20, ""));
                this.field_146292_n.add(new GuiButton(18, btn.field_146128_h + 52, btn.field_146129_i, 20, 20, ""));
                this.adding = true;
                this.searchBar.func_146180_a("");
            } else if (GuiHatSelection.func_146272_n() && !btn.field_146126_j.equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.allHats")) && !btn.field_146126_j.equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.contributors"))) {
                this.updateButtonList();
                this.selectedButtonName = btn.field_146126_j;
                for (int i = this.field_146292_n.size() - 1; i >= 0; --i) {
                    GuiButton button = (GuiButton)this.field_146292_n.get(i);
                    if (button.field_146127_k != btn.field_146127_k) continue;
                    this.field_146292_n.remove(button);
                    break;
                }
                this.field_146292_n.add(new GuiButton(19, btn.field_146128_h + 7, btn.field_146129_i, 20, 20, ""));
                this.field_146292_n.add(new GuiButton(20, btn.field_146128_h + 34, btn.field_146129_i, 20, 20, ""));
                this.field_146292_n.add(new GuiButton(18, btn.field_146128_h + 61, btn.field_146129_i, 20, 20, ""));
            } else {
                this.showCategory(btn.field_146126_j);
            }
        }
    }

    public void exitAndUpdate() {
        this.confirmed = true;
        this.field_146297_k.func_147108_a(null);
        if (Hats.config.getSessionInt("serverHasMod") != 1) {
            Hats.config.get("favouriteHat").set(this.hat.hatName);
            String r = Integer.toHexString(this.colourR);
            String b = Integer.toHexString(this.colourG);
            String g = Integer.toHexString(this.colourB);
            if (r.length() < 2) {
                r = "0" + r;
            }
            if (g.length() < 2) {
                g = "0" + g;
            }
            if (b.length() < 2) {
                b = "0" + b;
            }
            String name = "#" + r + g + b;
            Hats.config.get("favouriteHatColourizer").set(name);
            Hats.favouriteHatInfo = new HatInfo(this.hat.hatName, this.colourR, this.colourG, this.colourB, this.alpha);
            Hats.config.save();
        } else if (this.player != null && !this.player.field_70128_L && this.player.func_70089_S()) {
            CommonProxy.tickHandlerClient.playerWornHats.put(this.player.func_70005_c_(), new HatInfo(this.hat.hatName, this.colourR, this.colourG, this.colourB, this.alpha));
            PacketHandler.sendToServer(Hats.channels, (AbstractPacket)new PacketPlayerHatSelection(this.hat.hatName, this.colourR, this.colourG, this.colourB, this.alpha));
        }
    }

    public void exitWithoutUpdate() {
        this.field_146297_k.func_147108_a(null);
        this.hat.hatName = this.prevHatName;
        this.hat.setR(this.prevColourR);
        this.hat.setG(this.prevColourG);
        this.hat.setB(this.prevColourB);
        this.hat.setA(this.prevAlpha);
    }

    public void updateButtonList() {
        this.adding = false;
        this.deleting = false;
        this.renaming = false;
        if (this.view != 2) {
            this.addingToCategory = false;
        }
        for (int k1 = this.field_146292_n.size() - 1; k1 >= 0; --k1) {
            GuiButton btn = (GuiButton)this.field_146292_n.get(k1);
            if (btn.field_146127_k >= 5 && btn.field_146127_k <= 7 || btn.field_146127_k == 29 || btn.field_146127_k >= 30 || btn.field_146127_k == 17 || btn.field_146127_k == 18 || btn.field_146127_k == 19 || btn.field_146127_k == 20 || btn.field_146127_k == 21 || btn.field_146127_k == 27 || btn.field_146127_k == 28) {
                this.field_146292_n.remove(k1);
                continue;
            }
            if (btn.field_146127_k == 1) {
                if (this.pageNumber == 0 || this.view == 1 || this.personalizing) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k == 3) {
                if ((this.pageNumber + 1) * 6 >= this.hatsToShow.size() || this.view == 1 || this.personalizing) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k == 8) {
                if (this.hat.hatName.equalsIgnoreCase("")) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k == 9) {
                if (this.hat.hatName.equalsIgnoreCase("") && this.view == 0) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k == 12) {
                if (this.view == 2) {
                    btn.field_146124_l = false;
                    continue;
                }
                btn.field_146124_l = true;
                continue;
            }
            if (btn.field_146127_k != 11) continue;
            btn.field_146124_l = this.view != 3 || !this.category.equalsIgnoreCase("Favourites");
        }
        if (!this.personalizing) {
            int button;
            if (this.view == 0 || this.view == 2 || this.view == 3) {
                int pageCount;
                button = 0;
                for (int i = this.pageNumber * 6; i < this.hatsToShow.size() && i < (this.pageNumber + 1) * 6; ++i) {
                    String hatName = this.hatsToShow.get(i);
                    GuiButton btn = new GuiButton(this.view == 0 || this.view == 3 ? 600 + i : 30 + i, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * button, 88, 20, hatName);
                    if ((this.view == 0 || this.view == 3) && hatName.toLowerCase().equalsIgnoreCase(this.hat.hatName)) {
                        btn.field_146124_l = false;
                    }
                    this.field_146292_n.add(btn);
                    if (++button != 6) continue;
                    button = 0;
                    break;
                }
                if ((pageCount = (int)Math.ceil((float)this.hatsToShow.size() / 6.0f)) <= 0) {
                    pageCount = 1;
                }
                this.currentDisplay = (this.view == 0 ? StatCollector.func_74838_a((String)"hats.gui.allHats") : (this.view == 3 ? StatCollector.func_74838_a((String)"hats.gui.category") + " - " + this.category : StatCollector.func_74838_a((String)"hats.gui.categories"))) + " (" + (this.pageNumber + 1) + "/" + pageCount + ")";
            } else if (this.view == 1) {
                button = 0;
                for (int i = 0; i < 4; ++i) {
                    GuiSlider btn = new GuiSlider(i == 3 ? 29 : 5 + i, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22 * button, 88, i == 0 ? StatCollector.func_74838_a((String)"item.fireworksCharge.red") + ": " : (i == 1 ? StatCollector.func_74838_a((String)"item.fireworksCharge.green") + ": " : (i == 2 ? StatCollector.func_74838_a((String)"item.fireworksCharge.blue") + ": " : StatCollector.func_74838_a((String)"hats.gui.alpha") + ": ")), "", 0.0, 255.0, i == 0 ? (double)this.colourR : (i == 1 ? (double)this.colourG : (i == 2 ? (double)this.colourB : (double)this.alpha)), false, true, (ISlider)this);
                    this.field_146292_n.add(btn);
                    ++button;
                }
                this.currentDisplay = StatCollector.func_74838_a((String)"hats.gui.colorizer");
            }
            GuiButton btn = new GuiButton(27, this.guiLeft - 21, this.guiTop + this.ySize - 23, 20, 20, "");
            btn.field_146124_l = Hats.config.getSessionInt("serverHasMod") == 1;
            this.field_146292_n.add(btn);
            btn = new GuiButton(28, this.guiLeft - 21, this.guiTop + this.ySize - 45, 20, 20, "");
            btn.field_146124_l = CommonProxy.tickHandlerClient.tradeReqTimeout > 0;
            this.field_146292_n.add(btn);
        } else {
            this.field_146292_n.add(new GuiButton(22, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78, 88, 20, "GUI: " + GameSettings.func_74298_c((int)Hats.config.getKeyBind((String)"guiKeyBind").keyIndex)));
            this.field_146292_n.add(new GuiButton(23, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 22, 88, 20, StatCollector.func_74838_a((String)"hats.gui.firstPerson") + ": " + (Hats.config.getInt("renderInFirstPerson") == 1 ? StatCollector.func_74838_a((String)"gui.yes") : StatCollector.func_74838_a((String)"gui.no"))));
            this.field_146292_n.add(new GuiButton(26, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 44, 88, 20, StatCollector.func_74838_a((String)"hats.gui.showHats") + ": " + (Hats.config.getInt("renderHats") == 1 ? StatCollector.func_74838_a((String)"gui.yes") : StatCollector.func_74838_a((String)"gui.no"))));
            this.field_146292_n.add(new GuiButton(24, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 110, 88, 20, StatCollector.func_74838_a((String)"hats.gui.resetSide")));
            if (Hats.config.getSessionInt("playerHatsMode") < 4) {
                this.field_146292_n.add(new GuiSlider(25, this.field_146294_l / 2 - 6, this.field_146295_m / 2 - 78 + 66, 88, StatCollector.func_74838_a((String)"hats.gui.randomobs") + ": ", "%", 0.0, 100.0, (double)Hats.config.getInt("randomMobHat"), false, true, (ISlider)this));
            }
            this.currentDisplay = StatCollector.func_74838_a((String)"hats.gui.personalize");
        }
    }

    public void removeHat() {
        this.hat.hatName = "";
        this.updateButtonList();
    }

    public void reloadHatsAndReopenGUI() {
        for (int k1 = this.field_146292_n.size() - 1; k1 >= 0; --k1) {
            GuiButton btn1 = (GuiButton)this.field_146292_n.get(k1);
            if (btn1 instanceof GuiSlider || btn1.field_146127_k == 4) continue;
            btn1.field_146124_l = false;
        }
        Hats.proxy.getHatMobModSupport();
        Hats.proxy.getHatsAndOpenGui();
    }

    public void switchPage(boolean left) {
        if (left) {
            --this.pageNumber;
            if (this.pageNumber < 0) {
                this.pageNumber = 0;
            }
            this.updateButtonList();
        } else {
            ++this.pageNumber;
            if (this.pageNumber * 6 >= this.hatsToShow.size()) {
                --this.pageNumber;
            }
            this.updateButtonList();
        }
    }

    public void toggleHatsColourizer() {
        this.view = this.view == 1 && !GuiHatSelection.func_146272_n() && !this.category.equalsIgnoreCase("") ? 3 : (this.view == 3 && !GuiHatSelection.func_146272_n() ? 1 : (this.view > 0 ? 0 : 1));
        this.hatsToShow = new ArrayList<String>(this.view == 0 ? this.availableHats : this.categoryHats);
        Collections.sort(this.hatsToShow);
        this.searchBar.func_146180_a("");
        this.onSearchBarInteract();
        this.updateButtonList();
    }

    public boolean addCategory(String s) {
        if (this.invalidFolderName) {
            return false;
        }
        try {
            File file = new File(HatHandler.hatsFolder, "/" + s);
            if (!file.mkdirs()) {
                return false;
            }
            this.categories.add(s);
            Collections.sort(this.categories);
            HatHandler.categories.put(s, new ArrayList());
            this.hatsToShow = new ArrayList<String>(this.categories);
            Collections.sort(this.hatsToShow);
            this.hatsToShow.add(0, StatCollector.func_74838_a((String)"hats.gui.allHats"));
            this.hatsToShow.add(StatCollector.func_74838_a((String)"hats.gui.addNew"));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean renameCategory(String oriName, String newName) {
        if (this.invalidFolderName) {
            return false;
        }
        try {
            File oriCat = new File(HatHandler.hatsFolder, "/" + oriName);
            File newCat = new File(HatHandler.hatsFolder, "/" + newName);
            if (!oriCat.exists()) {
                return false;
            }
            if (!oriCat.renameTo(newCat)) {
                return false;
            }
            this.reloadHatsAndReopenGUI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void showCategory(String s) {
        if (s.equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.allHats"))) {
            this.view = 1;
            this.category = "";
            this.toggleHatsColourizer();
        } else {
            this.pageNumber = 0;
            this.view = 3;
            this.category = s;
            ArrayList<String> hatsList = HatHandler.categories.get(s);
            if (hatsList == null) {
                hatsList = new ArrayList();
            }
            ArrayList<String> hatsCopy = new ArrayList<String>(hatsList);
            if (Hats.config.getSessionInt("playerHatsMode") >= 4 && !this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                for (int i = hatsCopy.size() - 1; i >= 0; --i) {
                    String hatName = hatsCopy.get(i);
                    if (CommonProxy.tickHandlerClient.serverHats.containsKey(hatName)) continue;
                    hatsCopy.remove(i);
                }
            }
            this.categoryHats = new ArrayList<String>(hatsCopy);
            this.hatsToShow = new ArrayList<String>(hatsCopy);
            Collections.sort(this.hatsToShow);
            this.updateButtonList();
        }
    }

    public void randomize() {
        if (this.view == 0 || this.view == 3) {
            if (this.hatsToShow.size() > 0) {
                int randVal = this.rand.nextInt(this.hatsToShow.size());
                String hatName = this.hatsToShow.get(randVal);
                this.hat.hatName = hatName.toLowerCase();
                this.alpha = 255;
                this.colourB = 255;
                this.colourG = 255;
                this.colourR = 255;
                this.hat.setR(255);
                this.hat.setG(255);
                this.hat.setB(255);
                this.hat.setA(255);
                this.pageNumber = randVal / 6;
                if (GuiHatSelection.func_146272_n()) {
                    this.view = 1;
                    this.updateButtonList();
                    this.randomizeColour();
                    this.view = 0;
                }
                this.updateButtonList();
            }
        } else if (this.view == 1) {
            if (GuiHatSelection.func_146272_n()) {
                this.alpha = 255;
                this.colourB = 255;
                this.colourG = 255;
                this.colourR = 255;
                this.hat.setR(255);
                this.hat.setG(255);
                this.hat.setB(255);
                this.hat.setA(255);
                this.updateButtonList();
            } else {
                this.randomizeColour();
            }
        } else if (this.view == 2 && this.hatsToShow.size() > 0) {
            int randVal = this.rand.nextInt(this.hatsToShow.size());
            String categoryName = this.hatsToShow.get(randVal);
            this.showCategory(categoryName);
        }
    }

    public void randomizeColour() {
        for (int k1 = this.field_146292_n.size() - 1; k1 >= 0; --k1) {
            GuiButton btn1 = (GuiButton)this.field_146292_n.get(k1);
            if (!(btn1 instanceof GuiSlider)) continue;
            GuiSlider slider = (GuiSlider)btn1;
            if (slider.field_146127_k < 5 || slider.field_146127_k > 7) continue;
            slider.sliderValue = this.hat.hatName.equalsIgnoreCase("") ? 0.0 : (double)this.rand.nextFloat();
            slider.updateSlider();
        }
    }

    public void showCategories() {
        if (this.view != 2) {
            this.view = 2;
            this.pageNumber = 0;
            this.searchBar.func_146180_a("");
            this.onSearchBarInteract();
            this.hatsToShow = new ArrayList<String>(this.categories);
            Collections.sort(this.hatsToShow);
            if (!this.addingToCategory) {
                this.hatsToShow.add(0, StatCollector.func_74838_a((String)"hats.gui.allHats"));
                this.hatsToShow.add(StatCollector.func_74838_a((String)"hats.gui.addNew"));
            } else {
                this.hatsToShow.remove(StatCollector.func_74838_a((String)"hats.gui.contributors"));
            }
            this.updateButtonList();
        }
    }

    public void personalize() {
        this.showCategory(StatCollector.func_74838_a((String)"hats.gui.allHats"));
        if (!this.personalizing) {
            this.personalizing = true;
            this.randoMob = Hats.config.getInt("randomMobHat");
            for (int i = this.field_146292_n.size() - 1; i >= 0; --i) {
                GuiButton btn = (GuiButton)this.field_146292_n.get(i);
                if (btn.field_146127_k >= 8 && btn.field_146127_k <= 15) {
                    btn.field_146125_m = true;
                }
                if (btn.field_146127_k != 16) continue;
                this.field_146292_n.remove(i);
            }
            if (!this.enabledSearchBar) {
                GuiButton btn = new GuiButton(16, this.field_146294_l - 24, this.field_146295_m / 2 - 93 + 168, 20, 20, "");
                this.field_146292_n.add(btn);
            }
            this.updateButtonList();
        } else {
            this.personalizing = false;
            for (int i = this.field_146292_n.size() - 1; i >= 0; --i) {
                GuiButton btn = (GuiButton)this.field_146292_n.get(i);
                if (btn.field_146127_k >= 8 && btn.field_146127_k <= 15 && !this.enabledButtons.contains(Integer.toString(btn.field_146127_k - 7))) {
                    btn.field_146125_m = false;
                }
                if ((btn.field_146127_k < 22 || btn.field_146127_k > 25) && btn.field_146127_k != 16) continue;
                this.field_146292_n.remove(i);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.enabledButtons.size(); ++i) {
                sb.append(this.enabledButtons.get(i));
                sb.append(" ");
            }
            if (this.enabledSearchBar) {
                sb.append("9");
            }
            Hats.config.get("personalizeEnabled").set(sb.toString().trim());
            Hats.config.get("randomMobHat").set(this.randoMob);
            Hats.config.save();
            this.updateButtonList();
        }
    }

    public void toggleSearchBar() {
        if (this.enabledSearchBar) {
            this.enabledSearchBar = false;
            this.searchBar.func_146189_e(false);
            GuiButton btn = new GuiButton(16, this.field_146294_l - 24, this.field_146295_m / 2 - 93 + 168, 20, 20, "");
            this.field_146292_n.add(btn);
        } else {
            this.enabledSearchBar = true;
            this.searchBar.func_146189_e(true);
        }
    }

    public void toggleVisibility(GuiButton btn) {
        if (btn.field_146127_k == 16) {
            this.toggleSearchBar();
        } else if (this.enabledButtons.contains(Integer.toString(btn.field_146127_k - 7))) {
            this.enabledButtons.remove(Integer.toString(btn.field_146127_k - 7));
            btn.field_146128_h = this.field_146294_l - 24;
            btn.field_146129_i = this.field_146295_m / 2 - 93 + (btn.field_146127_k - 8) * 21;
            block0: for (int i = 0; i < this.field_146292_n.size(); ++i) {
                GuiButton btn1 = (GuiButton)this.field_146292_n.get(i);
                if (!this.enabledButtons.contains(Integer.toString(btn1.field_146127_k - 7))) continue;
                for (int i1 = 0; i1 < this.enabledButtons.size(); ++i1) {
                    if (!Integer.toString(btn1.field_146127_k - 7).equalsIgnoreCase(this.enabledButtons.get(i1))) continue;
                    btn1.field_146128_h = this.field_146294_l / 2 + 89;
                    btn1.field_146129_i = this.field_146295_m / 2 - 85 + i1 * 21;
                    continue block0;
                }
            }
        } else if (!this.enabledButtons.contains(Integer.toString(btn.field_146127_k - 7))) {
            this.enabledButtons.add(Integer.toString(btn.field_146127_k - 7));
            btn.field_146128_h = this.field_146294_l / 2 + 89;
            btn.field_146129_i = this.field_146295_m / 2 - 85 + (this.enabledButtons.size() - 1) * 21;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        if (this.field_146297_k == null) {
            this.field_146297_k = Minecraft.func_71410_x();
            this.field_146289_q = this.field_146297_k.field_71466_p;
        }
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texChooser);
        int k = this.guiLeft;
        int l = this.guiTop;
        this.func_73729_b(k, l, 0, 0, this.xSize, this.ySize);
        this.field_146297_k.func_110434_K().func_110577_a(texIcons);
        if (this.personalizing) {
            for (int l1 = 0; l1 < 8; ++l1) {
                this.func_73729_b(k + 176, l - 1 + l1 * 21, 190, 16, 22, 22);
            }
            this.func_73729_b(k - 1, this.field_146295_m - 29, 0, 16, 190, 29);
        }
        for (int k1 = 0; k1 < this.field_146292_n.size(); ++k1) {
            GuiButton btn = (GuiButton)this.field_146292_n.get(k1);
            String disp = btn.field_146126_j;
            if (btn.field_146127_k >= 30) {
                int id;
                int n = id = btn.field_146127_k >= 600 ? btn.field_146127_k - 600 : btn.field_146127_k - 30;
                if (this.pageNumber * 6 > id || (this.pageNumber + 1) * 6 <= id) continue;
                if (btn.field_146126_j.length() > 16) {
                    btn.field_146126_j = btn.field_146126_j.substring(0, 13) + "...";
                }
            }
            btn.func_146112_a(this.field_146297_k, par1, par2);
            if (!(btn instanceof GuiSlider)) {
                btn.field_146126_j = disp;
            }
            if (btn.field_146127_k != 9 && btn.field_146127_k != 8 && btn.field_146127_k != 10 && btn.field_146127_k != 15 && btn.field_146127_k != 14 && btn.field_146127_k != 11 && btn.field_146127_k != 12 && btn.field_146127_k != 13 && btn.field_146127_k != 17 && btn.field_146127_k != 18 && btn.field_146127_k != 19 && btn.field_146127_k != 20 && btn.field_146127_k != 21 && btn.field_146127_k != 16 && btn.field_146127_k != 27 && btn.field_146127_k != 28) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.field_146297_k.func_110434_K().func_110577_a(texIcons);
            if (btn.field_146125_m) {
                if (btn.field_146127_k == 9) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, this.view == 0 || this.view == 3 ? 16 : 0, 0, 16, 16);
                } else if (btn.field_146127_k == 8 || btn.field_146127_k == 18) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 32, 0, 16, 16);
                } else if (btn.field_146127_k == 10) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 80, 0, 16, 16);
                } else if (btn.field_146127_k == 15) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 96, 0, 16, 16);
                } else if (btn.field_146127_k == 14) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 48, 0, 16, 16);
                } else if (btn.field_146127_k == 11) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2 - (this.favourite > 3 ? 6 - this.favourite : this.favourite), 64, 0, 16, 16);
                } else if (btn.field_146127_k == 12) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 112, 0, 16, 16);
                } else if (btn.field_146127_k == 13) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 176, 0, 16, 16);
                } else if (btn.field_146127_k == 17) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, this.view == 3 && !this.category.equalsIgnoreCase("Favourites") && !this.category.equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.contributors")) ? 224 : 160, 0, 16, 16);
                } else if (btn.field_146127_k == 19) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 192, 0, 16, 16);
                } else if (btn.field_146127_k == 20) {
                    if ((this.view == 3 || this.view == 0) && GuiHatSelection.func_146272_n()) {
                        this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 208, 0, 16, 16);
                    } else {
                        this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 144, 0, 16, 16);
                    }
                } else if (btn.field_146127_k == 21) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 64, 0, 16, 16);
                    if (!this.selectedButtonName.equalsIgnoreCase("") && HatHandler.isInFavourites(this.selectedButtonName)) {
                        this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 32, 0, 16, 16);
                    }
                } else if (btn.field_146127_k == 16) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 128, 0, 16, 16);
                } else if (btn.field_146127_k == 27) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 82, 45, 16, 16);
                } else if (btn.field_146127_k == 28) {
                    this.func_73729_b(btn.field_146128_h + 2, btn.field_146129_i + 2, 98, 45, 16, 16);
                }
            }
            GL11.glDisable((int)3042);
        }
        this.func_73731_b(this.field_146289_q, StatCollector.func_74838_a((String)"hats.gui.viewing") + ": " + this.currentDisplay, this.guiLeft + 1, this.guiTop - 9, 0xFFFFFF);
        this.mouseX = par1;
        this.mouseY = par2;
        this.drawSearchBar();
        this.drawPlayerOnGui(k + 42, l + 155, 55, (float)(k + 42) - this.mouseX, (float)(l + 155 - 92) - this.mouseY);
        if (this.player != null && !this.player.field_71075_bZ.field_75098_d && this.tempInfo != null && !this.tempInfo.hatName.isEmpty()) {
            GL11.glDisable((int)2929);
            Object[] objectArray = new Object[1];
            objectArray[0] = CommonProxy.tickHandlerClient.availableHats.get(HatHandler.getNameForHat(this.tempInfo.hatName)) == null ? 1 : CommonProxy.tickHandlerClient.availableHats.get(HatHandler.getNameForHat(this.tempInfo.hatName));
            this.func_73731_b(this.field_146289_q, HatHandler.getHatRarityColour(this.tempInfo.hatName).toString() + StatCollector.func_74837_a((String)"hats.gui.hatsCollected", (Object[])objectArray), this.guiLeft + 10, this.guiTop + this.ySize - 22, 0xFFFFFF);
            GL11.glEnable((int)2929);
        }
        this.drawForeground(par1, par2, par3);
    }

    /*
     * Unable to fully structure code
     */
    public void drawForeground(int par1, int par2, float par3) {
        for (k1 = 0; k1 < this.field_146292_n.size(); ++k1) {
            btn = (GuiButton)this.field_146292_n.get(k1);
            if (!btn.func_146115_a() || this.personalizing) continue;
            if (btn.field_146127_k >= 30 && btn.field_146126_j.length() > 16) {
                this.drawTooltip(Arrays.asList(new String[]{"\u00a77" + btn.field_146126_j}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 4) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.discardChanges")}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 8) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.removeHat") + " (N)"}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 9) {
                this.drawTooltip(Arrays.asList(new String[]{(this.view == 0 || this.view == 3 ? StatCollector.func_74838_a((String)"hats.gui.colorizer") : StatCollector.func_74838_a((String)"hats.gui.hatsList")) + " (H)"}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 10) {
                this.drawTooltip(Arrays.asList(new String[]{(this.view == 0 || this.view == 3 ? StatCollector.func_74838_a((String)"hats.gui.randomHat") : (this.view == 2 ? StatCollector.func_74838_a((String)"hats.gui.randomCategory") : (GuiHatSelection.func_146272_n() != false ? StatCollector.func_74838_a((String)"hats.gui.resetColor") : StatCollector.func_74838_a((String)"hats.gui.randomColor")))) + " (R)"}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 15) {
                this.drawTooltip(GuiHatSelection.getCurrentHelpText(), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 14) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.reloadAllHats"), StatCollector.func_74838_a((String)"hats.gui.discardAllChanges")}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 11) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.favorites") + " (F)"}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 12) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.categories") + " (C)"}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 13) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.personalize") + " (P)"}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 17) {
                v0 = new String[1];
                v0[0] = this.adding || this.renaming ? (this.invalidFolderName ? "\u00a7c" + StatCollector.func_74838_a((String)"hats.gui.invalidName") : StatCollector.func_74838_a((String)"hats.gui.addCategory")) : (this.view == 0 || this.view == 3 && (this.category.equalsIgnoreCase("Favourites") != false || this.category.equalsIgnoreCase(StatCollector.func_74838_a((String)"hats.gui.contributors")) != false) ? StatCollector.func_74838_a((String)"hats.gui.addToCategory") : StatCollector.func_74838_a((String)"hats.gui.removeFromCategory"));
                this.drawTooltip(Arrays.asList(v0), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 18) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"gui.cancel")}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 20) {
                if (this.deleting) {
                    this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.areYouSure"), "", StatCollector.func_74838_a((String)"hats.gui.clickConfirm")}), par1, par2);
                    continue;
                }
                if (this.view == 2) {
                    this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.deleteCategory"), "", StatCollector.func_74838_a((String)"hats.gui.deleteCategory.desc1"), StatCollector.func_74838_a((String)"hats.gui.deleteCategory.desc2"), StatCollector.func_74838_a((String)"hats.gui.deleteCategory.desc3"), "", StatCollector.func_74838_a((String)"hats.gui.doubleClickConfirm")}), par1, par2);
                    continue;
                }
                if (GuiHatSelection.func_146272_n()) {
                    this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.disableHat"), "", StatCollector.func_74838_a((String)"hats.gui.disableHat.desc1"), StatCollector.func_74838_a((String)"hats.gui.disableHat.desc2"), StatCollector.func_74838_a((String)"hats.gui.disableHat.desc3"), StatCollector.func_74838_a((String)"hats.gui.disableHat.desc4"), "", StatCollector.func_74838_a((String)"hats.gui.doubleClickConfirm")}), par1, par2);
                    continue;
                }
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.deleteHat"), "", StatCollector.func_74838_a((String)"hats.gui.deleteHat.desc1"), StatCollector.func_74838_a((String)"hats.gui.deleteHat.desc2"), StatCollector.func_74838_a((String)"hats.gui.deleteHat.desc3"), "", StatCollector.func_74838_a((String)"hats.gui.doubleClickConfirm")}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 19) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.renameCategory"), "", StatCollector.func_74838_a((String)"hats.gui.renameCategory.desc1")}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 21) {
                if (!this.selectedButtonName.equalsIgnoreCase("") && HatHandler.isInFavourites(this.selectedButtonName)) {
                    this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.removeFromFavorites")}), par1, par2);
                    continue;
                }
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.addToFavorites")}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 24) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.gui.resetButtonsOnSide")}), par1, par2);
                continue;
            }
            if (btn.field_146127_k == 27) {
                this.drawTooltip(Arrays.asList(new String[]{StatCollector.func_74838_a((String)"hats.trade")}), par1, par2);
                continue;
            }
            if (btn.field_146127_k != 28) continue;
            v1 = new String[1];
            if (CommonProxy.tickHandlerClient.tradeReq == null) ** GOTO lbl-1000
            if (CommonProxy.tickHandlerClient.tradeReqTimeout > 0) {
                v2 = new Object[2];
                v2[0] = CommonProxy.tickHandlerClient.tradeReq;
                v2[1] = (int)Math.ceil((double)CommonProxy.tickHandlerClient.tradeReqTimeout / 20.0);
                v3 = StatCollector.func_74837_a((String)"hats.trade.acceptRequestSpecific", (Object[])v2);
            } else lbl-1000:
            // 2 sources

            {
                v3 = StatCollector.func_74838_a((String)"hats.trade.acceptRequestGeneral");
            }
            v1[0] = v3;
            this.drawTooltip(Arrays.asList(v1), par1, par2);
        }
    }

    protected void drawTooltip(List par1List, int par2, int par3) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = this.field_146289_q.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                this.field_146289_q.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
        }
    }

    public void drawPlayerOnGui(int par1, int par2, int par3, float par4, float par5) {
        if (this.player != null) {
            this.hat = CommonProxy.tickHandlerClient.hats.get(this.player.func_70005_c_());
            if (this.hat == null || this.hat.renderingParent == null) {
                return;
            }
            GL11.glEnable((int)2903);
            GL11.glPushMatrix();
            GL11.glDisable((int)3008);
            GL11.glTranslatef((float)par1, (float)par2, (float)500.0f);
            GL11.glScalef((float)(-par3), (float)par3, (float)par3);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f2 = this.hat.renderingParent.field_70761_aq;
            float f3 = this.hat.renderingParent.field_70177_z;
            float f4 = this.hat.renderingParent.field_70125_A;
            float ff3 = this.hat.field_70177_z;
            float ff4 = this.hat.field_70125_A;
            GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)Math.atan(par5 / 40.0f)) * 20.0f + 1.0E-5f), (float)1.0f, (float)0.0f, (float)0.0f);
            this.hat.renderingParent.field_70761_aq = (float)Math.atan(par4 / 40.0f) * 20.0f;
            this.hat.renderingParent.field_70177_z = this.hat.field_70177_z = (float)Math.atan(par4 / 40.0f) * 40.0f;
            this.hat.renderingParent.field_70125_A = this.hat.field_70125_A = -((float)Math.atan(par5 / 40.0f)) * 20.0f;
            this.hat.renderingParent.field_70759_as = this.hat.renderingParent.field_70177_z;
            float nextEntSize = this.hat.renderingParent.field_70130_N > this.hat.renderingParent.field_70131_O ? this.hat.renderingParent.field_70130_N : this.hat.renderingParent.field_70131_O;
            float nextScaleMag = nextEntSize > 2.5f ? 2.5f / nextEntSize : 1.0f;
            GL11.glScalef((float)nextScaleMag, (float)nextScaleMag, (float)nextScaleMag);
            GL11.glTranslatef((float)0.0f, (float)(this.hat.parent == this.hat.renderingParent ? this.hat.parent.field_70129_M : 0.0f), (float)0.0f);
            RenderManager.field_78727_a.field_78735_i = 180.0f;
            RenderManager.field_78727_a.func_147940_a((Entity)this.hat.renderingParent, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            Tessellator.field_78398_a.func_78380_c(240);
            int rend = Hats.config.getSessionInt("renderHats");
            Hats.config.updateSession("renderHats", (Object)13131);
            CommonProxy.tickHandlerClient.updateHatPosAndAngle(this.hat, this.hat.renderingParent);
            RenderHelper.func_74518_a();
            int i = 0xF000F0;
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
            HatInfoClient info = this.hat.info;
            if (this.tempInfo == null || info == null || !this.tempInfo.hatName.equalsIgnoreCase(this.hat.hatName) || this.tempInfo.colourR != this.hat.getR() || this.tempInfo.colourG != this.hat.getG() || this.tempInfo.colourB != this.hat.getB() || this.tempInfo.alpha != this.hat.getA()) {
                this.tempInfo = new HatInfoClient(this.hat.hatName, this.hat.getR(), this.hat.getG(), this.hat.getB(), this.hat.getA());
            }
            this.hat.info = this.tempInfo;
            RenderManager.field_78727_a.func_147940_a((Entity)this.hat, 0.0, this.hat.parent == this.hat.renderingParent ? 0.0 : (double)this.hat.parent.field_70129_M, 0.0, this.hat.field_70177_z, 1.0f);
            this.hat.info = info;
            Hats.config.updateSession("renderHats", (Object)rend);
            this.hat.renderingParent.field_70761_aq = f2;
            this.hat.renderingParent.field_70177_z = f3;
            this.hat.renderingParent.field_70125_A = f4;
            this.hat.field_70177_z = ff3;
            this.hat.field_70125_A = ff4;
            GL11.glEnable((int)3008);
            GL11.glPopMatrix();
            GL11.glDisable((int)32826);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GL11.glDisable((int)3553);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        }
    }

    public void drawSearchBar() {
        if (this.searchBar.func_146176_q()) {
            this.searchBar.func_146194_f();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.field_146297_k.func_110434_K().func_110577_a(texIcons);
            this.func_73729_b(this.field_146294_l / 2 - 85, this.field_146295_m - 22, this.adding || this.renaming ? 112 : 128, 0, 16, 16);
            GL11.glDisable((int)3042);
            if ((this.adding || this.renaming) && this.searchBar.func_146179_b().equalsIgnoreCase("")) {
                this.field_146289_q.func_78276_b("Category Name?", this.field_146294_l / 2 - 61, this.field_146295_m - 18, 0xAAAAAA);
            }
        }
    }

    public void onChangeSliderValue(GuiSlider slider) {
        if (slider.field_146127_k == 5) {
            this.colourR = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
            this.hat.setR(this.colourR);
        } else if (slider.field_146127_k == 6) {
            this.colourG = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
            this.hat.setG(this.colourG);
        } else if (slider.field_146127_k == 7) {
            this.colourB = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
            this.hat.setB(this.colourB);
        } else if (slider.field_146127_k == 29) {
            this.alpha = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
            this.hat.setA(this.alpha);
        } else if (slider.field_146127_k == 25) {
            this.randoMob = (int)Math.round(slider.sliderValue * (slider.maxValue - slider.minValue) + slider.minValue);
        }
    }

    private static String getHelpHeader() {
        return "\u00a7cProtip! (" + Integer.toString(helpPage + 1) + "/" + Integer.toString(help.size()) + ")";
    }

    private static List getCurrentHelpText() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(GuiHatSelection.getHelpHeader());
        list.add("");
        String[] str = help.get(helpPage);
        for (int i = 0; i < str.length; ++i) {
            list.add(str[i]);
        }
        return list;
    }

    static {
        help.add(helpInfo1);
        help.add(helpInfo2);
        help.add(helpInfo3);
        help.add(helpInfo4);
        help.add(helpInfo5);
        help.add(helpInfo6);
        help.add(helpInfo7);
        help.add(helpInfo8);
        help.add(helpInfo9);
        help.add(helpInfo10);
        help.add(helpInfo11);
        help.add(helpInfo12);
        help.add(helpInfo13);
        help.add(helpInfo14);
        help.add(helpInfo15);
        help.add(helpInfo16);
        help.add(helpInfo17);
        help.add(helpInfo18);
        help.add(helpInfo19);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        helpPage = calendar.get(5) % help.size();
    }
}

