/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.utility;

import com.djgiannuzz.hyperioncraft.handler.FastTravelPosition;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityFastTravel;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ServerFastTravelHandler {
    private static Vector<FastTravelPosition> globalPoints = new Vector();
    private static HashMap<String, Vector<FastTravelPosition>> privatePoints = new HashMap();

    public static Vector<FastTravelPosition> getGlobalPoints() {
        return globalPoints;
    }

    public static Vector<FastTravelPosition> getPrivatePoints(String username) {
        return privatePoints.get(username);
    }

    public static boolean containsGlobalPoint(int dimensionID, int x, int y, int z) {
        for (FastTravelPosition pos : globalPoints) {
            if (!pos.equals(dimensionID, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPrivatePoint(String username, int dimensionID, int x, int y, int z) {
        for (FastTravelPosition pos : ServerFastTravelHandler.getPrivatePoints(username)) {
            if (!pos.equals(dimensionID, x, y, z)) continue;
            return true;
        }
        return false;
    }

    private static TileEntityFastTravel getTileEntityFastTravel(int dimensionID, int x, int y, int z) {
        WorldServer world = DimensionManager.getWorld((int)dimensionID);
        if (world == null) {
            return null;
        }
        return (TileEntityFastTravel)world.func_147438_o(x, y, z);
    }

    public static void addGlobalPoint(int dimensionID, int x, int y, int z, String name) {
        if (!ServerFastTravelHandler.containsGlobalPoint(dimensionID, x, y, z)) {
            globalPoints.add(new FastTravelPosition(dimensionID, x, y, z, name));
        } else {
            ServerFastTravelHandler.renameGlobalPoint(name, dimensionID, x, y, z);
        }
        TileEntityFastTravel tile = ServerFastTravelHandler.getTileEntityFastTravel(dimensionID, x, y, z);
        tile.isGlobal = true;
        tile.globalName = name;
    }

    public static void addPrivatePoint(String username, int dimensionID, int x, int y, int z, String name) {
        if (ServerFastTravelHandler.getPrivatePoints(username) == null) {
            privatePoints.put(username, new Vector());
        }
        if (!ServerFastTravelHandler.containsPrivatePoint(username, dimensionID, x, y, z)) {
            ServerFastTravelHandler.getPrivatePoints(username).add(new FastTravelPosition(dimensionID, x, y, z, name));
        } else {
            ServerFastTravelHandler.renamePrivatePoint(username, name, dimensionID, x, y, z);
        }
        TileEntityFastTravel tile = ServerFastTravelHandler.getTileEntityFastTravel(dimensionID, x, y, z);
        tile.isPrivate = true;
        tile.privateName = name;
    }

    public static void removeGlobalPoint(int dimensionID, int x, int y, int z) {
        for (int i = 0; i < globalPoints.size(); ++i) {
            if (!globalPoints.get(i).equals(dimensionID, x, y, z)) continue;
            globalPoints.remove(i);
            TileEntityFastTravel tile = ServerFastTravelHandler.getTileEntityFastTravel(dimensionID, x, y, z);
            if (tile == null) continue;
            tile.isGlobal = false;
            tile.globalName = "";
        }
    }

    public static void removePrivatePoint(String username, int dimensionID, int x, int y, int z) {
        for (int i = 0; i < ServerFastTravelHandler.getPrivatePoints(username).size(); ++i) {
            if (!ServerFastTravelHandler.getPrivatePoints(username).get(i).equals(dimensionID, x, y, z)) continue;
            ServerFastTravelHandler.getPrivatePoints(username).remove(i);
            TileEntityFastTravel tile = ServerFastTravelHandler.getTileEntityFastTravel(dimensionID, x, y, z);
            if (tile == null) continue;
            tile.isPrivate = false;
            tile.privateName = "";
        }
    }

    public static void removeAllPrivatePoint(int dimensionID, int x, int y, int z) {
        for (String username : privatePoints.keySet()) {
            ServerFastTravelHandler.removePrivatePoint(username, dimensionID, x, y, z);
        }
    }

    public static void renameGlobalPoint(String name, int dimensionID, int x, int y, int z) {
        for (FastTravelPosition pos : globalPoints) {
            if (!pos.equals(dimensionID, x, y, z)) continue;
            pos.setName(name);
            TileEntityFastTravel tile = ServerFastTravelHandler.getTileEntityFastTravel(dimensionID, x, y, z);
            tile.globalName = name;
        }
    }

    public static void renamePrivatePoint(String username, String name, int dimensionID, int x, int y, int z) {
        for (FastTravelPosition pos : ServerFastTravelHandler.getPrivatePoints(username)) {
            if (!pos.equals(dimensionID, x, y, z)) continue;
            pos.setName(name);
            TileEntityFastTravel tile = ServerFastTravelHandler.getTileEntityFastTravel(dimensionID, x, y, z);
            tile.privateName = name;
        }
    }

    public static void unload() {
        globalPoints.clear();
        privatePoints.clear();
    }
}

