/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.utility;

import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class RenderCheckpointHelper {
    private static final float ANTENNA_UP_HEIGH = 30.0f;
    private static final float TOP_HEIGH = 8.0f;
    private static final float DOWN_HEIGH = -8.4f;
    private static final float ANTENNA_DOWN_HEIGH = 2.6f;
    private static final float LIGHT_FORWARD = 1.6f;

    public static float shiftRange(float moveVal, float min, float max) {
        float shift = (max - min) * moveVal;
        return min + shift;
    }

    public static void renderUp(IModelCustom model, float moveVal, boolean wasDown) {
        if (wasDown) {
            model.renderAllExcept(new String[]{"AntennaTop", "AntennaBottom", "ToP", "BodyTop", "BodyLight", "DoorLeft", "DoorRight", "Top", "DoorLeftTop", "DoorRightTop"});
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)((1.0f - moveVal) * -8.4f), (float)0.0f);
            model.renderOnly(new String[]{"BodyTop", "DoorLeft", "DoorRight", "DoorLeftTop", "DoorRightTop"});
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, -14.0f, 20.0f), (float)0.0f);
            model.renderOnly(new String[]{"AntennaTop"});
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)1.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 0.6f, 1.0f), (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 10.0f, 20.0f), (float)0.0f);
            model.renderOnly(new String[]{"AntennaBottom"});
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(moveVal * 8.0f), (float)0.0f);
            model.renderOnly(new String[]{"Top"});
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(moveVal * 1.6f));
            model.renderOnly(new String[]{"BodyLight"});
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        } else {
            model.renderAllExcept(new String[]{"DoorLeft", "DoorRight", "AntennaTop", "AntennaBottom", "ToP", "BodyLight"});
            GL11.glPushMatrix();
            GL11.glTranslatef((float)RenderCheckpointHelper.shiftRange(moveVal, -1.5f, 0.0f), (float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, -3.0f, 0.0f));
            GL11.glRotatef((float)RenderCheckpointHelper.shiftRange(moveVal, -60.0f, 0.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            model.renderOnly(new String[]{"DoorLeft"});
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)RenderCheckpointHelper.shiftRange(moveVal, 7.0f, 0.0f), (float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 6.0f, 0.0f));
            GL11.glRotatef((float)RenderCheckpointHelper.shiftRange(moveVal, 60.0f, 0.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            model.renderOnly(new String[]{"DoorRight"});
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 30.0f, 20.0f), (float)0.0f);
            model.renderOnly(new String[]{"AntennaTop", "AntennaBottom"});
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)8.0f, (float)0.0f);
            model.renderOnly(new String[]{"Top"});
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.6f);
            model.renderOnly(new String[]{"BodyLight"});
            GL11.glPopMatrix();
        }
    }

    public static void renderDown(IModelCustom model, float moveVal) {
        model.renderAllExcept(new String[]{"AntennaBottom", "AntennaTop", "BodyTop", "BodyLight", "DoorLeft", "DoorRight", "Top", "DoorLeftTop", "DoorRightTop"});
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(moveVal * -8.4f), (float)0.0f);
        model.renderOnly(new String[]{"BodyTop", "BodyLight", "DoorLeft", "DoorRight", "DoorLeftTop", "DoorRightTop"});
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 20.0f, -11.0f), (float)0.0f);
        model.renderOnly(new String[]{"AntennaTop"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)1.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 1.0f, 0.6f), (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 20.0f, 20.0f), (float)0.0f);
        model.renderOnly(new String[]{"AntennaBottom"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 8.0f, 0.0f), (float)0.0f);
        model.renderOnly(new String[]{"Top"});
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderOpen(IModelCustom model, float moveVal) {
        model.renderAllExcept(new String[]{"DoorLeft", "DoorRight", "AntennaTop", "AntennaBottom", "ToP", "BodyLight"});
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(moveVal * -1.5f), (float)0.0f, (float)(moveVal * -3.0f));
        GL11.glRotatef((float)(moveVal * -60.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        model.renderOnly(new String[]{"DoorLeft"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(moveVal * 7.0f), (float)0.0f, (float)(moveVal * 6.0f));
        GL11.glRotatef((float)(moveVal * 60.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        model.renderOnly(new String[]{"DoorRight"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 20.0f, 30.0f), (float)0.0f);
        model.renderOnly(new String[]{"AntennaTop"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)RenderCheckpointHelper.shiftRange(moveVal, 20.0f, 30.0f), (float)0.0f);
        model.renderOnly(new String[]{"AntennaBottom"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)8.0f, (float)0.0f);
        model.renderOnly(new String[]{"Top"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.6f);
        model.renderOnly(new String[]{"BodyLight"});
        GL11.glPopMatrix();
    }

    public static void renderUp(IModelCustom model) {
        RenderCheckpointHelper.renderUp(model, 1.0f, false);
    }

    public static void renderDown(IModelCustom model) {
        RenderCheckpointHelper.renderDown(model, 1.0f);
    }

    public static void renderOpen(IModelCustom model) {
        RenderCheckpointHelper.renderOpen(model, 1.0f);
    }

    public static void renderOpenFastTravel(IModelCustom model) {
        model.renderAllExcept(new String[]{"DoorLeft", "DoorRight", "AntennaTop", "BodyLight"});
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.5f, (float)0.0f, (float)-3.0f);
        GL11.glRotatef((float)-60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        model.renderOnly(new String[]{"DoorLeft"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)7.0f, (float)0.0f, (float)6.0f);
        GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        model.renderOnly(new String[]{"DoorRight"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-10.0f, (float)0.0f);
        model.renderOnly(new String[]{"AntennaTop"});
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.6f);
        model.renderOnly(new String[]{"BodyLight"});
        GL11.glPopMatrix();
    }
}

