/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.utility;

import com.djgiannuzz.hyperioncraft.blocks.BlockCheckpoint;
import com.djgiannuzz.hyperioncraft.handler.CheckpointsHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class HUtility {
    public static ChunkCoordinates getPlayerCheckpointAround(EntityPlayer player) {
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        World world = player.field_70170_p;
        WorldServer worldServer = DimensionManager.getWorld((int)world.field_73011_w.field_76574_g);
        if (HUtility.isPlayerBlockCheckpoint((World)worldServer, x - 2, y, z, player.getDisplayName())) {
            return new ChunkCoordinates(x - 2, y, z);
        }
        if (HUtility.isPlayerBlockCheckpoint((World)worldServer, x + 2, y, z, player.getDisplayName())) {
            return new ChunkCoordinates(x + 2, y, z);
        }
        if (HUtility.isPlayerBlockCheckpoint((World)worldServer, x, y, z - 2, player.getDisplayName())) {
            return new ChunkCoordinates(x, y, z - 2);
        }
        if (HUtility.isPlayerBlockCheckpoint((World)worldServer, x, y, z + 2, player.getDisplayName())) {
            return new ChunkCoordinates(x, y, z + 2);
        }
        return null;
    }

    public static boolean isBlockCheckpoint(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof BlockCheckpoint;
    }

    public static boolean isPlayerBlockCheckpoint(World world, int x, int y, int z, String playerUsername) {
        if (HUtility.isBlockCheckpoint(world, x, y, z)) {
            return CheckpointsHandler.isPlayerCheckpoint(new ChunkCoordinates(x, y, z), playerUsername);
        }
        return false;
    }

    public static void addChatMessage(EntityPlayer player, String message) {
        player.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public static void addUnlocalizedChatMessage(EntityPlayer player, String unlocalizedMessage) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(unlocalizedMessage, new Object[0]));
    }

    public static float getPlayerRotationFromMeta(int meta) {
        switch (meta) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return 90.0f;
            }
            case 2: {
                return 180.0f;
            }
            case 3: {
                return 270.0f;
            }
        }
        return 0.0f;
    }

    public static boolean isIntegerInRangeEqual(int n, int min, int max) {
        return n >= min && n <= max;
    }
}

