/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.utility;

import com.djgiannuzz.hyperioncraft.handler.FastTravelPosition;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityFastTravel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;

public class ClientFastTravelHandler {
    private static Vector<FastTravelPosition> globalPoints = new Vector();
    private static HashMap<String, Vector<FastTravelPosition>> privatePoints = new HashMap();

    public static void load(Vector<FastTravelPosition> global, Vector<FastTravelPosition> priv, String username) {
        globalPoints = global;
        privatePoints.put(username, priv);
    }

    public static Vector<FastTravelPosition> getGlobalPoints() {
        return globalPoints;
    }

    public static Vector<FastTravelPosition> getPrivatePoints(String username) {
        return privatePoints.get(username);
    }

    public static boolean containsGlobalPoint(int dimensionID, int x, int y, int z) {
        for (FastTravelPosition pos : globalPoints) {
            if (!pos.equals(dimensionID, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPrivatePoint(String username, int dimensionID, int x, int y, int z) {
        for (FastTravelPosition pos : ClientFastTravelHandler.getPrivatePoints(username)) {
            if (!pos.equals(dimensionID, x, y, z)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private static TileEntityFastTravel getServerTileEntityFastTravel(int dimensionID, int x, int y, int z) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return null;
        }
        return (TileEntityFastTravel)world.func_147438_o(x, y, z);
    }

    public static void addGlobalPoint(int dimensionID, int x, int y, int z, String name) {
        if (!ClientFastTravelHandler.containsGlobalPoint(dimensionID, x, y, z)) {
            globalPoints.add(new FastTravelPosition(dimensionID, x, y, z, name));
        } else {
            ClientFastTravelHandler.renameGlobalPoint(name, dimensionID, x, y, z);
        }
        TileEntityFastTravel tile = ClientFastTravelHandler.getServerTileEntityFastTravel(dimensionID, x, y, z);
        if (tile != null) {
            tile.isGlobal = true;
            tile.globalName = name;
        }
    }

    public static void addPrivatePoint(String username, int dimensionID, int x, int y, int z, String name) {
        if (ClientFastTravelHandler.getPrivatePoints(username) == null) {
            privatePoints.put(username, new Vector());
        }
        if (!ClientFastTravelHandler.containsPrivatePoint(username, dimensionID, x, y, z)) {
            ClientFastTravelHandler.getPrivatePoints(username).add(new FastTravelPosition(dimensionID, x, y, z, name));
        } else {
            ClientFastTravelHandler.renamePrivatePoint(username, name, dimensionID, x, y, z);
        }
        TileEntityFastTravel tile = ClientFastTravelHandler.getServerTileEntityFastTravel(dimensionID, x, y, z);
        tile.isPrivate = true;
        tile.privateName = name;
    }

    public static void removeGlobalPoint(int dimensionID, int x, int y, int z) {
        for (int i = 0; i < globalPoints.size(); ++i) {
            if (!globalPoints.get(i).equals(dimensionID, x, y, z)) continue;
            globalPoints.remove(i);
            TileEntityFastTravel tile = ClientFastTravelHandler.getServerTileEntityFastTravel(dimensionID, x, y, z);
            if (tile == null) continue;
            tile.isGlobal = false;
            tile.globalName = "";
        }
    }

    public static void removePrivatePoint(String username, int dimensionID, int x, int y, int z) {
        for (int i = 0; i < ClientFastTravelHandler.getPrivatePoints(username).size(); ++i) {
            if (!ClientFastTravelHandler.getPrivatePoints(username).get(i).equals(dimensionID, x, y, z)) continue;
            ClientFastTravelHandler.getPrivatePoints(username).remove(i);
            TileEntityFastTravel tile = ClientFastTravelHandler.getServerTileEntityFastTravel(dimensionID, x, y, z);
            if (tile == null) continue;
            tile.isPrivate = false;
            tile.privateName = "";
        }
    }

    public static void removeAllPrivatePoint(int dimensionID, int x, int y, int z) {
        for (String username : privatePoints.keySet()) {
            ClientFastTravelHandler.removePrivatePoint(username, dimensionID, x, y, z);
        }
    }

    public static void renameGlobalPoint(String name, int dimensionID, int x, int y, int z) {
        for (FastTravelPosition pos : globalPoints) {
            if (!pos.equals(dimensionID, x, y, z)) continue;
            pos.setName(name);
            TileEntityFastTravel tile = ClientFastTravelHandler.getServerTileEntityFastTravel(dimensionID, x, y, z);
            tile.globalName = name;
        }
    }

    public static void renamePrivatePoint(String username, String name, int dimensionID, int x, int y, int z) {
        for (FastTravelPosition pos : ClientFastTravelHandler.getPrivatePoints(username)) {
            if (!pos.equals(dimensionID, x, y, z)) continue;
            pos.setName(name);
            TileEntityFastTravel tile = ClientFastTravelHandler.getServerTileEntityFastTravel(dimensionID, x, y, z);
            tile.privateName = name;
        }
    }

    public static void unload() {
        globalPoints.clear();
        privatePoints.clear();
    }
}

