/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.tileentity;

import com.djgiannuzz.hyperioncraft.HyperionCraft;
import com.djgiannuzz.hyperioncraft.handler.PacketHandler;
import com.djgiannuzz.hyperioncraft.packets.ClientFastTravelRemovePacket;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityCheckpoint;
import com.djgiannuzz.hyperioncraft.utility.ClientFastTravelHandler;
import com.djgiannuzz.hyperioncraft.utility.HUtility;
import com.djgiannuzz.hyperioncraft.utility.ServerFastTravelHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileEntityFastTravel
extends TileEntityCheckpoint {
    public boolean isLocked = false;
    public boolean isPrivate;
    public boolean isGlobal;
    public String ownerUsername = "";
    public String privateName = "";
    public String globalName = "";
    public float animationValue = 0.0f;
    protected ForgeChunkManager.Ticket chunkTicket;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)HyperionCraft.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            this.chunkTicket.getModData().func_74768_a("FastTravelX", this.field_145851_c);
            this.chunkTicket.getModData().func_74768_a("FastTravelY", this.field_145848_d);
            this.chunkTicket.getModData().func_74768_a("FastTravelZ", this.field_145849_e);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4));
        }
        this.animationValue = this.animationValue >= 1.0f ? 0.0f : (this.animationValue += 0.01f);
    }

    @Override
    protected void onFirstTick() {
        super.onFirstTick();
        if (this.isPrivate) {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                ClientFastTravelHandler.addPrivatePoint(this.ownerUsername, this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.privateName);
            } else if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                ServerFastTravelHandler.addPrivatePoint(this.ownerUsername, this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.privateName);
            }
        }
        if (this.isGlobal) {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                ClientFastTravelHandler.addGlobalPoint(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.globalName);
            } else if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                ServerFastTravelHandler.addGlobalPoint(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.globalName);
            }
        }
    }

    @Override
    public boolean activate(EntityPlayer player) {
        if (!this.isLocked || player.getDisplayName().equals(this.ownerUsername)) {
            player.openGui((Object)HyperionCraft.instance, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            HUtility.addUnlocalizedChatMessage(player, "chat.hyperioncraft:fasttravelprivate.name");
        }
        return false;
    }

    @Override
    public void func_145843_s() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ClientFastTravelHandler.removeGlobalPoint(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            ServerFastTravelHandler.removeGlobalPoint(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ClientFastTravelHandler.removeAllPrivatePoint(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            ServerFastTravelHandler.removeAllPrivatePoint(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        PacketHandler.network.sendToAll((IMessage)new ClientFastTravelRemovePacket(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        super.func_145843_s();
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("isLocked", this.isLocked);
        par1NBTTagCompound.func_74757_a("isPrivate", this.isPrivate);
        par1NBTTagCompound.func_74757_a("isGlobal", this.isGlobal);
        par1NBTTagCompound.func_74778_a("Owner", this.ownerUsername.isEmpty() ? "undef" : this.ownerUsername);
        par1NBTTagCompound.func_74778_a("privateName", this.privateName.isEmpty() ? "undef" : this.privateName);
        par1NBTTagCompound.func_74778_a("globalName", this.globalName.isEmpty() ? "undef" : this.globalName);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.isLocked = par1NBTTagCompound.func_74767_n("isLocked");
        this.isPrivate = par1NBTTagCompound.func_74767_n("isPrivate");
        this.isGlobal = par1NBTTagCompound.func_74767_n("isGlobal");
        String owner = par1NBTTagCompound.func_74779_i("Owner");
        this.ownerUsername = owner.equals("undef") ? "" : owner;
        String privName = par1NBTTagCompound.func_74779_i("privateName");
        this.privateName = privName.equals("undef") ? "" : privName;
        String globName = par1NBTTagCompound.func_74779_i("globalName");
        this.globalName = globName.equals("undef") ? "" : globName;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        ChunkCoordIntPair chunkCoord = new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkCoord);
    }
}

